/*
 * Copyright 2009-2014 UnboundID Corp.
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2009-2014 UnboundID Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.android.ldap.client;



import android.app.Activity;
import android.content.Intent;
import android.view.View;
import android.view.View.OnClickListener;

import static com.unboundid.android.ldap.client.Logger.*;



/**
 * This class provides an on-click listener that is meant to display a set of
 * options whenever the user clicks on a generic attribute value.
 */
final class GenericAttributeClickListener
      implements OnClickListener
{
  /**
   * The tag that will be used for log messages generated by this class.
   */
  private static final String LOG_TAG = "AttrClickListener";



  // The activity that created this on-click listener.
  private final Activity activity;

  // The attribute value.
  private final String attrValue;



  /**
   * Creates a new generic attribute on-click listener with the provided
   * attribute value.
   *
   * @param  activity   The activity that created this on-click listener.
   * @param  attrValue  The attribute value with which this listener is
   *                    associated.
   */
  GenericAttributeClickListener(final Activity activity, final String attrValue)
  {
    logEnter(LOG_TAG, "<init>", activity, attrValue);

    this.activity  = activity;
    this.attrValue = attrValue;
  }



  /**
   * Takes any appropriate action after a click on the attribute value.
   *
   * @param  view      The view for the item that was clicked.
   */
  public void onClick(final View view)
  {
    logEnter(LOG_TAG, "onClick", view);

    final Intent i = new Intent(activity, GenericAttributeOptions.class);
    i.putExtra(GenericAttributeOptions.BUNDLE_FIELD_ATTR_VALUE, attrValue);
    activity.startActivity(i);
  }
}
