/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.NamingListener;
import javax.naming.spi.ResolveResult;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingMessages;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.RequireResolveException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ServiceBasedNamingStore
implements NamingStore {
    private final Name EMPTY_NAME = new CompositeName();
    private final ServiceRegistry serviceRegistry;
    private final ServiceName serviceNameBase;
    private ConcurrentSkipListSet<ServiceName> boundServices = new ConcurrentSkipListSet();

    public ServiceBasedNamingStore(ServiceRegistry serviceRegistry, ServiceName serviceNameBase) {
        this.serviceRegistry = serviceRegistry;
        this.serviceNameBase = serviceNameBase;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContext(this.EMPTY_NAME, this, null);
        }
        ServiceName lookupName = this.buildServiceName(name);
        Object obj = this.lookup(name.toString(), lookupName);
        if (obj == null) {
            ServiceName lower = this.boundServices.lower(lookupName);
            if (lower != null && lower.isParentOf(lookupName)) {
                obj = this.lookup(name.toString(), lower);
                this.checkReferenceForContinuation(name, obj);
                return new ResolveResult(obj, this.suffix(lower, lookupName));
            }
            ServiceName ceiling = this.boundServices.ceiling(lookupName);
            if (ceiling != null && lookupName.isParentOf(ceiling)) {
                return new NamingContext((Name)name.clone(), this, null);
            }
            throw new NameNotFoundException(name.toString() + " -- " + lookupName);
        }
        return obj;
    }

    private void checkReferenceForContinuation(Name name, Object object) throws CannotProceedException {
        if (object instanceof Reference && ((Reference)object).get("nns") != null) {
            throw ServiceBasedNamingStore.cannotProceedException(object, name);
        }
    }

    private static CannotProceedException cannotProceedException(Object resolvedObject, Name remainingName) {
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(resolvedObject);
        cpe.setRemainingName(remainingName);
        return cpe;
    }

    private Object lookup(String name, ServiceName lookupName) throws NameNotFoundException {
        Object object;
        ServiceController controller = this.serviceRegistry.getService(lookupName);
        if (controller != null) {
            try {
                object = controller.getValue();
            }
            catch (IllegalStateException e) {
                throw new NameNotFoundException("Error looking up " + name + ", service " + lookupName + " is not started");
            }
        } else {
            return null;
        }
        if (object instanceof ManagedReferenceFactory) {
            return ((ManagedReferenceFactory)ManagedReferenceFactory.class.cast(object)).getReference().getInstance();
        }
        return object;
    }

    @Override
    public List<NameClassPair> list(Name name) throws NamingException {
        Object obj;
        ServiceName lookupName = this.buildServiceName(name);
        ServiceName floor = this.boundServices.floor(lookupName);
        if (floor != null && floor.isParentOf(lookupName) && (obj = this.lookup(name.toString(), floor)) != null) {
            throw new RequireResolveException(this.convert(floor));
        }
        List<ServiceName> children = this.listChildren(lookupName);
        String[] lookupParts = lookupName.toArray();
        HashSet<String> childContexts = new HashSet<String>();
        ArrayList<NameClassPair> results = new ArrayList<NameClassPair>();
        for (ServiceName child : children) {
            String[] childParts = child.toArray();
            if (childParts.length > lookupParts.length + 1) {
                childContexts.add(childParts[lookupParts.length]);
                continue;
            }
            Object binding = this.lookup(name.toString(), child);
            results.add(new NameClassPair(childParts[childParts.length - 1], binding.getClass().getName()));
        }
        for (String contextName : childContexts) {
            results.add(new NameClassPair(contextName, Context.class.getName()));
        }
        return results;
    }

    @Override
    public List<Binding> listBindings(Name name) throws NamingException {
        Object obj;
        ServiceName lookupName = this.buildServiceName(name);
        ServiceName floor = this.boundServices.floor(lookupName);
        if (floor != null && floor.isParentOf(lookupName) && (obj = this.lookup(name.toString(), floor)) != null) {
            throw new RequireResolveException(this.convert(floor));
        }
        List<ServiceName> children = this.listChildren(lookupName);
        String[] lookupParts = lookupName.toArray();
        HashSet<String> childContexts = new HashSet<String>();
        ArrayList<Binding> results = new ArrayList<Binding>();
        for (ServiceName child : children) {
            String[] childParts = child.toArray();
            if (childParts.length > lookupParts.length + 1) {
                childContexts.add(childParts[lookupParts.length]);
                continue;
            }
            Object binding = this.lookup(name.toString(), child);
            results.add(new Binding(childParts[childParts.length - 1], binding));
        }
        for (String contextName : childContexts) {
            results.add(new Binding(contextName, new NamingContext(((Name)name.clone()).add(contextName), this, null)));
        }
        return results;
    }

    private List<ServiceName> listChildren(ServiceName name) throws NamingException {
        ServiceName next;
        ConcurrentSkipListSet<ServiceName> boundServices = this.boundServices;
        if (boundServices.contains(name)) {
            throw NamingMessages.MESSAGES.cannotListNonContextBinding();
        }
        SortedSet tail = boundServices.tailSet((Object)name);
        ArrayList<ServiceName> children = new ArrayList<ServiceName>();
        Iterator i$ = tail.iterator();
        while (i$.hasNext() && name.isParentOf(next = (ServiceName)i$.next())) {
            children.add(next);
        }
        return children;
    }

    @Override
    public void close() throws NamingException {
        this.boundServices.clear();
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener listener) {
    }

    @Override
    public void removeNamingListener(NamingListener listener) {
    }

    public void add(ServiceName serviceName) {
        ConcurrentSkipListSet<ServiceName> boundServices = this.boundServices;
        if (boundServices.contains(serviceName)) {
            throw NamingMessages.MESSAGES.serviceAlreadyBound(serviceName);
        }
        boundServices.add(serviceName);
    }

    public void remove(ServiceName serviceName) {
        this.boundServices.remove(serviceName);
    }

    protected ServiceName buildServiceName(Name name) {
        Enumeration<String> parts = name.getAll();
        ServiceName current = this.serviceNameBase;
        while (parts.hasMoreElements()) {
            String currentPart = parts.nextElement();
            if (currentPart.isEmpty()) continue;
            current = current.append(new String[]{currentPart});
        }
        return current;
    }

    private Name convert(ServiceName serviceName) {
        String[] c = serviceName.toArray();
        CompositeName name = new CompositeName();
        for (int i = 0; i < c.length; ++i) {
            try {
                name.add(c[i]);
                continue;
            }
            catch (InvalidNameException e) {
                throw new IllegalStateException(e);
            }
        }
        return name;
    }

    private Name suffix(ServiceName parent, ServiceName child) {
        String[] p = parent.toArray();
        String[] c = child.toArray();
        CompositeName name = new CompositeName();
        for (int i = p.length; i < c.length; ++i) {
            try {
                name.add(c[i]);
                continue;
            }
            catch (InvalidNameException e) {
                throw new IllegalStateException(e);
            }
        }
        return name;
    }

    protected ServiceName getServiceNameBase() {
        return this.serviceNameBase;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

