#
# Copyright (c) 2010 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


from cli import compat


class Error(Exception):
    """Base class for python-cli errors."""

    def __init__(self, message=None, **kwargs):
        if message is None:
            message = self.__doc__
        compat.super(Error, self).__init__(message)
        for key in kwargs:
            setattr(self, key, kwargs[key])


class ParseError(Error):
    """Error parsing command line."""


class CommandError(Error):
    """Illegal command."""
