package org.ovirt.engine.ui.webadmin.section.main.view.popup.storage.backup;

import org.ovirt.engine.core.common.businessentities.OriginType;
import org.ovirt.engine.core.common.businessentities.VmTemplate;
import org.ovirt.engine.ui.common.uicommon.model.DetailModelProvider;
import org.ovirt.engine.ui.common.widget.editor.IVdcQueryableCellTable;
import org.ovirt.engine.ui.common.widget.table.column.EnumColumn;
import org.ovirt.engine.ui.common.widget.table.column.IsObjectInSystemColumn;
import org.ovirt.engine.ui.common.widget.table.column.TextColumnWithTooltip;
import org.ovirt.engine.ui.uicommonweb.models.templates.TemplateGeneralModel;
import org.ovirt.engine.ui.uicommonweb.models.templates.TemplateListModel;
import org.ovirt.engine.ui.uicommonweb.models.vms.ImportVmModel;
import org.ovirt.engine.ui.webadmin.ApplicationConstants;
import org.ovirt.engine.ui.webadmin.ApplicationResources;
import org.ovirt.engine.ui.webadmin.gin.ClientGinjector;
import org.ovirt.engine.ui.webadmin.section.main.presenter.popup.storage.backup.ImportTemplatePopupPresenterWidget;

import com.google.gwt.dom.client.Style.Position;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.inject.Inject;

public class ImportTemplatePopupView extends ImportVmPopupView implements ImportTemplatePopupPresenterWidget.ViewDef {

    private ImportTemplateGeneralSubTabView generalView;

    @Inject
    public ImportTemplatePopupView(ClientGinjector ginjector,
            EventBus eventBus,
            ApplicationResources resources,
            ApplicationConstants constants) {
        super(ginjector, eventBus, resources, constants);
    }

    protected void initMainTable() {
        this.table = new IVdcQueryableCellTable<Object, ImportVmModel>();

        TextColumnWithTooltip<Object> nameColumn = new TextColumnWithTooltip<Object>() {
            @Override
            public String getValue(Object object) {
                return ((VmTemplate) object).getname();
            }
        };
        table.addColumn(nameColumn, constants.nameTemplate(), "150px"); //$NON-NLS-1$

        TextColumnWithTooltip<Object> originColumn = new EnumColumn<Object, OriginType>() {
            @Override
            protected OriginType getRawValue(Object object) {
                return ((VmTemplate) object).getorigin();
            }
        };
        table.addColumn(originColumn, constants.originTemplate(), "100px"); //$NON-NLS-1$

        TextColumnWithTooltip<Object> memoryColumn = new TextColumnWithTooltip<Object>() {
            @Override
            public String getValue(Object object) {
                return String.valueOf(((VmTemplate) object).getmem_size_mb()) + " MB"; //$NON-NLS-1$
            }
        };
        table.addColumn(memoryColumn, constants.memoryTemplate(), "100px"); //$NON-NLS-1$

        TextColumnWithTooltip<Object> cpuColumn = new TextColumnWithTooltip<Object>() {
            @Override
            public String getValue(Object object) {
                return String.valueOf(((VmTemplate) object).getnum_of_cpus());
            }
        };
        table.addColumn(cpuColumn, constants.cpusTemplate(), "50px"); //$NON-NLS-1$

        TextColumnWithTooltip<Object> diskColumn = new TextColumnWithTooltip<Object>() {
            @Override
            public String getValue(Object object) {
                return String.valueOf(((VmTemplate) object).getDiskList().size());
            }
        };
        table.addColumn(diskColumn, constants.disksTemplate(), "50px"); //$NON-NLS-1$

        isObjectInSystemColumn = new IsObjectInSystemColumn<Object>();
        table.addColumn(isObjectInSystemColumn, constants.templateInSetup(), "60px"); //$NON-NLS-1$

        ScrollPanel sp = new ScrollPanel();
        sp.add(table);
        splitLayoutPanel.add(sp);
        table.getElement().getStyle().setPosition(Position.RELATIVE);
    }

    @Override
    protected void initGeneralSubTabView() {
        ScrollPanel generalPanel = new ScrollPanel();
        DetailModelProvider<TemplateListModel, TemplateGeneralModel> modelProvider =
                new DetailModelProvider<TemplateListModel, TemplateGeneralModel>() {
                    @Override
                    public TemplateGeneralModel getModel() {
                        return (TemplateGeneralModel) object.getDetailModels().get(0);
                    }

                    @Override
                    public void onSubTabSelected() {
                    }
                };
        generalView = new ImportTemplateGeneralSubTabView(modelProvider, constants);
        generalPanel.add(generalView);
        subTabLayoutPanel.add(generalPanel, constants.generalImpTempTab());
    }

    @Override
    protected void subTabLayoutPanelSelectionChanged(Integer selectedItem) {
        if (object != null) {
            object.setActiveDetailModel(object.getDetailModels().get(selectedItem));
            if (selectedItem == 0) {
                generalView.setMainTabSelectedItem((VmTemplate) object.getSelectedItem());
            }
        }
    }

    @Override
    protected void setGeneralViewSelection(Object selectedItem) {
        generalView.setMainTabSelectedItem((VmTemplate) selectedItem);
    }

    @Override
    protected void addAllocationColumn() {
    }

    @Override
    protected void initAppTable() {
    }

}
