# Settings
%global product_name oVirt Engine
%global product_name_short oVirt Engine
%global user_description oVirt Manager
%global install_poms 1

# Short names for engine directories:
%global engine_name ovirt-engine
%global engine_etc %{_sysconfdir}/%{engine_name}
%global engine_data %{_datadir}/%{engine_name}
%global engine_ear %{engine_data}/engine.ear
%global engine_java %{_javadir}/%{engine_name}
%global engine_pki %{_sysconfdir}/pki/%{engine_name}
%global engine_jboss_modules %{engine_data}/modules

%global engine_state %{_localstatedir}/lib/%{engine_name}
%global engine_log %{_localstatedir}/log/%{engine_name}
%global engine_run %{_localstatedir}/run/%{engine_name}
%global engine_lock %{_localstatedir}/lock/%{engine_name}
%global engine_cache %{_localstatedir}/cache/%{engine_name}

%global restapi_war %{engine_ear}/restapi.war
%global root_war %{engine_ear}/root.war

# The name and ids of the engine user and group:
%global engine_user ovirt
%global engine_group ovirt
%global engine_gid 108
%global engine_uid 108

# The name and ids of the VDSM user and group:
%global vdsm_description Node Virtualization Manager
%global vdsm_user vdsm
%global vdsm_group kvm
%global vdsm_uid 36
%global vdsm_gid 36

# Macro to create an user:
#
# %1 user name
# %2 user id
# %3 primary group name
# %4 primary group id
# %5 description
# %6 home directory
#
%global create_user() \
getent group %3 >/dev/null || groupadd -r -g %4 %3; \
getent passwd %1 >/dev/null || useradd -r -u %2 -g %3 -c %5 -s /sbin/nologin -d %6 %1

# Macro to create the engine user and group:
%global create_engine_user \
%create_user %{engine_user} %{engine_uid} %{engine_group} %{engine_gid} "%{user_description}" %{engine_state}

# Macro to create the VDSM user and group:
%global create_vdsm_user \
%create_user %{vdsm_user} %{vdsm_uid} %{vdsm_group} %{vdsm_gid} "%{vdsm_description}" /var/lib/vdsm

%global make_common_opts \\\
	-j1 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE_VERSION=%{release} \\\
	ENGINE_NAME=%{engine_name} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	ENGINE_STATE=%{engine_state} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	BIN_DIR=%{_bindir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	MAN_DIR=%{_mandir} \\\
	PYTHON=%{__python} \\\
	PYTHON_DIR=%{python_sitelib} \\\
	JAVA_DIR=%{_javadir} \\\
	MAVENPOM_DIR=%{_mavenpomdir} \\\
	PKG_JAVA_DIR=%{engine_java} \\\
	PKG_SYSCONF_DIR=%{engine_etc} \\\
	PKG_EAR_DIR=%{engine_ear} \\\
	PKG_PKI_DIR=%{engine_pki} \\\
	PKG_JBOSS_MODULES=%{engine_jboss_modules} \\\
	%{?BUILD_FLAGS:BUILD_FLAGS="%{BUILD_FLAGS}"} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name: ovirt-engine
Version: 3.2.0
Release: 1%{?release_suffix}%{?dist}
Summary: Management server for Open Virtualization
Group: Virtualization/Management
License: ASL 2.0
URL: http://www.ovirt.org
Source0: http://ovirt.org/releases/stable/src/%{name}-%{version}.tar.gz

BuildArch: noarch

# Build time requirements:
BuildRequires: apache-commons-beanutils
BuildRequires: apache-commons-codec
BuildRequires: apache-commons-collections
BuildRequires: apache-commons-configuration
BuildRequires: apache-commons-jxpath
BuildRequires: apache-commons-lang
BuildRequires: apache-commons-logging
BuildRequires: apache-commons-compress
BuildRequires: apache-mina
BuildRequires: apache-sshd
BuildRequires: bea-stax-api
BuildRequires: dos2unix
BuildRequires: jackson
BuildRequires: hibernate-commons-annotations
BuildRequires: hibernate-jpa-2.0-api
BuildRequires: hibernate-validator
BuildRequires: jakarta-commons-httpclient
BuildRequires: java-devel
BuildRequires: javamail
BuildRequires: javassist
BuildRequires: jboss-annotations-1.1-api
BuildRequires: jboss-ejb-3.1-api
BuildRequires: jboss-logging
BuildRequires: jboss-interceptors-1.1-api
BuildRequires: jboss-servlet-3.0-api
BuildRequires: jpackage-utils
BuildRequires: jsch
BuildRequires: log4j
BuildRequires: make
BuildRequires: maven
BuildRequires: maven-antrun-plugin
BuildRequires: maven-assembly-plugin
BuildRequires: maven-checkstyle-plugin
BuildRequires: maven-clean-plugin
BuildRequires: maven-compiler-plugin
BuildRequires: maven-dependency-plugin
BuildRequires: maven-ear-plugin
BuildRequires: maven-eclipse-plugin
BuildRequires: maven-ejb-plugin
BuildRequires: maven-jar-plugin
BuildRequires: maven-jaxb2-plugin
BuildRequires: maven-javadoc-plugin
BuildRequires: maven-plugin-exec
BuildRequires: maven-resources-plugin
BuildRequires: maven-source-plugin
BuildRequires: maven-surefire-plugin
BuildRequires: maven-war-plugin
BuildRequires: postgresql-jdbc
BuildRequires: quartz
BuildRequires: resteasy
BuildRequires: springframework-instrument
BuildRequires: springframework-jdbc
BuildRequires: spring-ldap
BuildRequires: xmlrpc3-client
BuildRequires: unzip
BuildRequires: ovirt-host-deploy-java

# Run time requirements (most of these requirements should be
# moved to the subpackages):
Requires: bea-stax-api
Requires: bind-utils
Requires: cracklib-python
Requires: geronimo-validation
Requires: hibernate-commons-annotations
Requires: hibernate-jpa-2.0-api
Requires: hibernate-validator
Requires: httpd
Requires: jakarta-commons-httpclient
Requires: java
Requires: jboss-interceptors-1.1-api
Requires: jboss-logging
Requires: jpackage-utils
Requires: log4j
Requires: mod_ssl
Requires: ntp
Requires: openssl
Requires: policycoreutils-python
Requires: postgresql-jdbc
Requires: python-configobj
Requires: python-cheetah
Requires: ovirt-host-deploy-java
Requires: yum-plugin-versionlock
Requires: ovirt-engine-cli

# For local database:
Requires: postgresql-server >= 8.4.7

# Require JBoss AS 7:
Requires: jboss-as >= 7.1.1

# We can't require exactly the same version and release of the
# setup package because it needs to be updated independely as part
# of the update process implemented in the engine-upgrade script:
Requires: %{name}-setup >= %{version}-%{release}

# Require the subpackages so that everything is installed when the
# main package is installed:
Requires: %{name}-backend = %{version}-%{release}
Requires: %{name}-restapi = %{version}-%{release}
Requires: %{name}-genericapi = %{version}-%{release}
Requires: %{name}-userportal = %{version}-%{release}
Requires: %{name}-config = %{version}-%{release}
Requires: %{name}-notification-service = %{version}-%{release}
Requires: %{name}-dbscripts = %{version}-%{release}
Requires: %{name}-webadmin-portal = %{version}-%{release}

# Require other tool packages:
Requires: ovirt-iso-uploader
Requires: ovirt-image-uploader
Requires: ovirt-log-collector


%description
%{product_name} is a feature-rich server virtualization management
system that provides advanced capabilities for managing the Open
virtualization infrastructure for Servers and Desktops.


%package backend
Summary: Engine core of %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}
Requires: apache-commons-beanutils
Requires: apache-commons-codec
Requires: apache-commons-collections
Requires: apache-commons-lang
Requires: apache-commons-compress
Requires: apache-mina
Requires: apache-sshd
Requires: bea-stax-api
Requires: dom4j
Requires: geronimo-validation
Requires: jackson
Requires: jakarta-commons-httpclient
Requires: java
Requires: javassist
Requires: jboss-interceptors-1.1-api
Requires: jsch
Requires: objectweb-asm
Requires: openssh
Requires: openssl
Requires: picketbox
Requires: quartz
Requires: slf4j
Requires: springframework
Requires: springframework-aop
Requires: springframework-beans
Requires: springframework-context
Requires: springframework-instrument
Requires: springframework-jdbc
Requires: springframework-tx
Requires: spring-ldap
Requires: ws-commons-util
Requires: xmlrpc3-client
Requires: xmlrpc3-common


%description backend
The backend engine of %{product_name_short}


%package restapi
Summary: RESTful API for %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description restapi
The RESTful API for %{product_name_short}


%package genericapi
Summary: Generic API for %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description genericapi
The generic API for %{product_name_short}


%package setup
Summary: Setup and upgrade scripts for %{product_name_short}
Group: Virtualization/Management
Requires: %{name}
Requires: yum
Requires: lsof
Requires: nfs-utils
Requires: python-cheetah

%description setup
Setup and upgrade scripts for %{product_name_short}


%package dbscripts
Summary: Database scripts for %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description dbscripts
Database scripts for %{product_name_short}


%package userportal
Summary: User Portal of %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description userportal
The user portal interface to %{product_name_short}


%package webadmin-portal
Summary: Web Admin Portal of %{product_name_short}
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}

%description webadmin-portal
The web administration interface to %{product_name_short}


%package tools-common
Summary: Common libraries for  %{product_name_short} Tools
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}
Requires: apache-commons-collections
Requires: apache-commons-logging
Requires: apache-commons-lang
Requires: apache-commons-codec
Requires: apache-commons-configuration
Requires: apache-commons-jxpath
Requires: log4j

%description tools-common
The common libraries used by %{product_name_short} Tools


%package notification-service
Summary: Notification service for %{product_name_short} Tools
Group: Virtualization/Management
Requires: %{name} = %{version}-%{release}
Requires: %{name}-tools-common = %{version}-%{release}
Requires: classpathx-mail

%description notification-service
The notification service used by %{product_name_short}


%package config
Summary: Configuration tool for %{product_name_short}
Group: Virtualization/Management
Requires: %{name}-tools-common = %{version}-%{release}

%description config
The configuration tool for %{product_name_short}


%package setup-plugin-allinone
Summary: All-in-one plugin for %{product_name_short}'s setup
Group: Virtualization/Management
Requires: %{name}-setup
Requires: %{name}-sdk
Requires: vdsm
Requires: ovirt-host-deploy-offline

%description setup-plugin-allinone
All-in-one plugin for %{product_name_short}'s setup


%prep

%setup -c -q

%build

make %{make_common_opts}

%install

rm -fr "%{buildroot}"

# Use the makefile to do the normal installation, after that we
# will need to replace jar files with links to their actual
# locations:
make %{make_common_opts} install DESTDIR=%{buildroot}

install -dm 755 %{buildroot}/%{engine_state}/deployments
install -dm 755 %{buildroot}/%{engine_state}/content
install -dm 755 %{buildroot}/%{engine_log}/{host-deploy,notifier,engine-manage-domains}
install -dm 755 %{buildroot}/%{engine_run}/notifier
install -dm 755 %{buildroot}/%{engine_lock}

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{engine_name}"
ln -s "%{engine_name}" "%{buildroot}%{engine_java}/../%{name}"
%endif

#
# Force TLS/SSL for selected applications.
#
for war in restapi userportal webadmin; do
    sed -i \
        's#<transport-guarantee>NONE</transport-guarantee>#<transport-guarantee>CONFIDENTIAL</transport-guarantee>#' \
        "%{buildroot}%{engine_ear}/${war}.war/WEB-INF/web.xml"
done

# Register poms
%if !%{install_poms}
rm -fr "%{buildroot}%{_mavenpomdir}"
%else
for pom in %{buildroot}%{_mavenpomdir}/*.pom
do
  pomdir=`dirname "${pom}"`
  pom=`basename "${pom}"`
  jpppom="JPP.${pom}"
  mv "${pomdir}/${pom}" "${pomdir}/${jpppom}"
  artifact_id=`echo "${pom}" | sed -e 's/^%{name}-//' -e 's/\.pom//'`
  if [ -f "%{buildroot}%{engine_java}/${artifact_id}.jar" ]
  then
    %add_maven_depmap "${jpppom}" "%{name}/${artifact_id}.jar"
  else
    %add_maven_depmap "${jpppom}"
  fi
done
%endif

# Remove the jar files that are not needed:
while read lib_path
do
  rm -rf %{buildroot}%{engine_ear}/lib/${lib_path}*.jar
done <<'.'
activation
antlr
aopalliance
c3p0
ejb3-persistence
jaxb-api
jaxb-impl
jboss-interceptors-api_1.1_spec
stax-api
xml-apis
.

# Attention!
# spring-asm *IS* required on rhel-6
rm -rf %{buildroot}%{engine_ear}/lib/spring-asm*.jar

# Then for the system jar files (using build-classpath):
while read jar_name lib_path
do
  rm -rf %{buildroot}%{engine_ear}/lib/${lib_path}*.jar
  ln -s `build-classpath ${jar_name}` %{buildroot}%{engine_ear}/lib/${lib_path}.jar
done <<'.'
apache-mina/mina-core mina-core
apache-sshd/sshd-core sshd-core
commons-beanutils commons-beanutils
commons-codec commons-codec
commons-collections commons-collections
commons-httpclient commons-httpclient
commons-lang commons-lang
commons-compress commons-compress
dom4j dom4j
geronimo-validation validation-api
hibernate/hibernate-commons-annotations hibernate-commons-annotations
hibernate-validator hibernate-validator
jsch jsch
objectweb-asm/asm-all asm-all
quartz quartz
slf4j/api slf4j-api
springframework/spring-aop spring-aop
springframework/spring-beans spring-beans
springframework/spring-context spring-context
springframework/spring-core spring-core
springframework/spring-expression spring-expression
springframework/spring-instrument spring-instrument
springframework/spring-jdbc spring-jdbc
springframework/spring-tx spring-tx
spring-ldap/spring-ldap-core spring-ldap-core
ws-commons-util ws-commons-util
xmlrpc3-client xmlrpc-client
xmlrpc3-common xmlrpc-common
otopi/otopi otopi
ovirt-host-deploy/ovirt-host-deploy ovirt-host-deploy
.

# Replace jar files in the RESTAPI web application with links to ther
# actual locations, first for jar files from this package, as for these
# can't use build-classpath:
while read jar_name lib_path
do
  rm -rf %{buildroot}%{restapi_war}/WEB-INF/lib/${lib_path}*.jar
  ln -s %{engine_java}/${jar_name}.jar %{buildroot}%{restapi_war}/WEB-INF/lib/${lib_path}.jar
done <<'.'
interface-common-jaxrs interface-common-jaxrs
restapi-definition restapi-definition
restapi-jaxrs restapi-jaxrs
restapi-types restapi-types
.

# Remove the jar files that are not needed:
while read lib_path
do
  rm -rf %{buildroot}%{restapi_war}/WEB-INF/lib/${lib_path}*.jar
done <<'.'
commons-codec
log4j
.

# Then for the system jar files (using build-classpath):
while read jar_name lib_path
do
  rm -rf %{buildroot}%{restapi_war}/WEB-INF/lib/${lib_path}*.jar
  ln -s `build-classpath ${jar_name}` %{buildroot}%{restapi_war}/WEB-INF/lib/${lib_path}.jar
done <<'.'
snakeyaml snakeyaml
.

# Copy the module definitions:
install -dm 755 %{buildroot}%{engine_jboss_modules}
cp -r deployment/modules/* %{buildroot}%{engine_jboss_modules}
find %{buildroot}%{engine_jboss_modules} -type d -exec chmod 755 {} \;
find %{buildroot}%{engine_jboss_modules} -type f -exec chmod 644 {} \;

# Apache commons-codec module:
ln -s `build-classpath commons-codec` %{buildroot}%{engine_jboss_modules}/org/apache/commons/codec/main/.

# Apache HTTP components module:
ln -s `build-classpath httpcomponents/httpcore` %{buildroot}%{engine_jboss_modules}/org/apache/httpcomponents/main/.
ln -s `build-classpath httpcomponents/httpclient` %{buildroot}%{engine_jboss_modules}/org/apache/httpcomponents/main/.
ln -s `build-classpath httpcomponents/httpmime` %{buildroot}%{engine_jboss_modules}/org/apache/httpcomponents/main/.

# Scannotation module:
ln -s `build-classpath scannotation` %{buildroot}%{engine_jboss_modules}/org/scannotation/scannotation/main/.

# JAXB module:
ln -s `build-classpath glassfish-jaxb/jaxb-impl` %{buildroot}%{engine_jboss_modules}/com/sun/xml/bind/main/.
ln -s `build-classpath glassfish-jaxb/jaxb-xjc` %{buildroot}%{engine_jboss_modules}/com/sun/xml/bind/main/.
ln -s `build-classpath istack-commons-runtime` %{buildroot}%{engine_jboss_modules}/com/sun/xml/bind/main/.

# JAX-RS API modules:
ln -s `build-classpath resteasy/jaxrs-api` %{buildroot}%{engine_jboss_modules}/javax/ws/rs/api/main/.

# Resteasy modules:
ln -s `build-classpath resteasy/resteasy-cdi` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-cdi/main/.
ln -s `build-classpath resteasy/resteasy-jettison-provider` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-jettison-provider/main/.
ln -s `build-classpath resteasy/resteasy-atom-provider` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-atom-provider/main/.
ln -s `build-classpath resteasy/resteasy-yaml-provider` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-yaml-provider/main/.
ln -s `build-classpath resteasy/resteasy-multipart-provider` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-multipart-provider/main/.
ln -s `build-classpath resteasy/resteasy-jackson-provider` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-jackson-provider/main/.
ln -s `build-classpath resteasy/resteasy-jaxb-provider` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-jaxb-provider/main/.
ln -s `build-classpath resteasy/resteasy-jaxrs` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-jaxrs/main/.
ln -s `build-classpath resteasy/async-http-servlet-3.0` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-jaxrs/main/.
ln -s `build-classpath resteasy/resteasy-jsapi` %{buildroot}%{engine_jboss_modules}/org/jboss/resteasy/resteasy-jsapi/main/.

# Jackson modules:
ln -s `build-classpath jackson/jackson-jaxrs` %{buildroot}%{engine_jboss_modules}/org/codehaus/jackson/jackson-jaxrs/main/.
ln -s `build-classpath jackson/jackson-core-asl` %{buildroot}%{engine_jboss_modules}/org/codehaus/jackson/jackson-core-asl/main/.
ln -s `build-classpath jackson/jackson-mapper-asl` %{buildroot}%{engine_jboss_modules}/org/codehaus/jackson/jackson-mapper-asl/main/.
ln -s `build-classpath jackson/jackson-xc` %{buildroot}%{engine_jboss_modules}/org/codehaus/jackson/jackson-xc/main/.

# Hibernate validator module:
ln -s `build-classpath hibernate-validator` %{buildroot}%{engine_jboss_modules}/org/hibernate/validator/main/.
ln -s `build-classpath jtype` %{buildroot}%{engine_jboss_modules}/org/hibernate/validator/main/.

# Jettison:
ln -s `build-classpath jettison` %{buildroot}%{engine_jboss_modules}/org/codehaus/jettison/main

# Apache MIME4J:
ln -s `build-classpath apache-mime4j/core` %{buildroot}%{engine_jboss_modules}/org/apache/james/mime4j/main/.
ln -s `build-classpath apache-mime4j/dom` %{buildroot}%{engine_jboss_modules}/org/apache/james/mime4j/main/.
ln -s `build-classpath apache-mime4j/storage` %{buildroot}%{engine_jboss_modules}/org/apache/james/mime4j/main/.

# Snakeyaml:
ln -s `build-classpath snakeyaml` %{buildroot}%{engine_jboss_modules}/org/yaml/snakeyaml/main/.


%preun
if [ "$1" -eq 0 ]
then
    if [ -d "%{engine_pki}" ]; then
        #backup whole 'rhevm' dir into the backup dir with current date
        dest="%{engine_pki}/../%{engine_name}-backups/%{engine_name}-$(date +"%%Y_%%m_%%d_%%H_%%M_%%S")"
        mkdir -p "${dest}"
        cp -pR "%{engine_pki}" "${dest}"
    fi
fi


%postun
if [ "$1" -eq 0 ]
then
    rm -rf "%{engine_cache}"
    rm -rf "%{engine_pki}"

    if [[ -f %{_sysconfdir}/yum/pluginconf.d/versionlock.list ]]
    then
        sed -i '/ovirt/d' %{_sysconfdir}/yum/pluginconf.d/versionlock.list
    fi
fi


%pre
%create_engine_user


%pre backend
%create_engine_user


%pre notification-service
%create_engine_user


%pre setup
%create_vdsm_user


%files

# The main package owns most of the directories:
%dir %{engine_data}
%dir %{engine_data}/ovirt-isos
%dir %{engine_data}/db-backups
%dir %{engine_data}/scripts
%dir %{engine_run}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_lock}

# Log rotation script:
%{engine_data}/scripts/ovirtlogrot.sh
%{_sysconfdir}/cron.daily/ovirt-cron

# Misc configuration files:
%{engine_data}/conf
%{_sysconfdir}/tmpfiles.d/ovirt-engine.conf

# Engine configuration files:
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_etc}
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_etc}/engine.conf

# Files needed by the service:
%config(noreplace) %{_sysconfdir}/security/limits.d/10-ovirt-engine.conf
%config(noreplace) %{_sysconfdir}/sysconfig/%{engine_name}
%dir %{_sysconfdir}/sysconfig/%{engine_name}.d
%{engine_data}/service
%{_bindir}/engine-service
%{_unitdir}/%{engine_name}.service

# Jar files used by all the components:
%dir %{engine_java}
%{engine_java}/common.jar
%{engine_java}/compat.jar
%{engine_java}/utils.jar

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{engine_name}"
%{_javadir}/%{name}
%endif

# POM files:
%if %{install_poms}
%{_mavendepmapfragdir}/%{name}
%{_mavenpomdir}/JPP.%{name}-root.pom
%{_mavenpomdir}/JPP.%{name}-common.pom
%{_mavenpomdir}/JPP.%{name}-compat.pom
%{_mavenpomdir}/JPP.%{name}-utils.pom
%endif

# Documentation:
%doc LICENSE


%files backend

# Directory for binaries and scripts:
%dir %{engine_data}/bin

# Jar files:
%{engine_java}/bll.jar
%{engine_java}/dal.jar
%{engine_java}/engine-config.jar
%{engine_java}/engineencryptutils.jar
%{engine_java}/scheduler.jar
%{engine_java}/searchbackend.jar
%{engine_java}/vdsbroker.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-backend.pom
%{_mavenpomdir}/JPP.%{name}-manager.pom
%{_mavenpomdir}/JPP.%{name}-manager-modules.pom
%{_mavenpomdir}/JPP.%{name}-manager-tools.pom
%{_mavenpomdir}/JPP.%{name}-bll.pom
%{_mavenpomdir}/JPP.%{name}-dal.pom
%{_mavenpomdir}/JPP.%{name}-engine-config.pom
%{_mavenpomdir}/JPP.%{name}-engine-notifier-resources.pom
%{_mavenpomdir}/JPP.%{name}-engine-notifier-service.pom
%{_mavenpomdir}/JPP.%{name}-engineencryptutils.pom
%{_mavenpomdir}/JPP.%{name}-scheduler.pom
%{_mavenpomdir}/JPP.%{name}-searchbackend.pom
%{_mavenpomdir}/JPP.%{name}-vdsbroker.pom
%endif

# The state directory is owned by the backend, but not recursively, as
# some of its subdirectories are owned by other packages (backups, for
# example, has to be owned by the setup package):
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_state}

# Directories for the deployments and content files need to be owned by
# the engine user because the application server needs to write to them:
%attr(-, %{engine_user}, %{engine_group}) %{engine_state}/content
%attr(-, %{engine_user}, %{engine_group}) %{engine_state}/deployments

# Host deploy logs
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/host-deploy

# The backend owns the directory of the ear and most of its contents,
# but not all, as most of the web applications are owned by other
# subpackages:
%dir %{engine_ear}
%{engine_ear}/META-INF
%{engine_ear}/lib
%{engine_ear}/engine-bll.jar
%{engine_ear}/engine-scheduler.jar
%{engine_ear}/ovirtengineweb.war

# Root web application:
%{root_war}

# Sysprep files:
%config(noreplace) %{engine_etc}/sysprep

# PKI directories are owned by the engine user because it needs to
# create files inside:
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/certs
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/keys
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/private
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/requests

# PKI scripts:
%{engine_pki}/*.sh

# PKI configuration files:
%config(noreplace) %{engine_pki}/openssl.conf
%config(noreplace) %{engine_pki}/cacert.template
%config(noreplace) %{engine_pki}/cert.template

# The certificate database files:
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/database.txt
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/serial.txt

# Modules:
%{engine_jboss_modules}

%files setup

# Links to the main programs:
%{_bindir}/engine-setup
%{_bindir}/engine-upgrade
%{_bindir}/engine-check-update
%{_bindir}/engine-cleanup

# Python scripts:
%{engine_data}/scripts/basedefs.py*
%{engine_data}/scripts/engine_validators.py*
%{engine_data}/scripts/setup_params.py*
%{engine_data}/scripts/setup_sequences.py*
%{engine_data}/scripts/setup_controller.py*
%{engine_data}/scripts/common_utils.py*
%{engine_data}/scripts/miniyum.py*
%{engine_data}/scripts/output_messages.py*
%{engine_data}/scripts/nfsutils.py*
%{engine_data}/scripts/engine-setup.py*
%{engine_data}/scripts/engine-cleanup.py*
%{engine_data}/scripts/engine-upgrade.py*
%{engine_data}/scripts/post_upgrade.py*
%{engine_data}/scripts/add_fn_db_get_async_tasks_function.sql

# Man pages
%{_mandir}/man8/engine-setup.*
%{_mandir}/man8/engine-upgrade.*

# Plugins directory:
%dir %{engine_data}/scripts/plugins
%{engine_data}/scripts/plugins/example_plugin_000.py*

# Backups directory
%dir %{engine_state}/backups

%files setup-plugin-allinone
%{engine_data}/scripts/plugins/all_in_one_100.py*


%files dbscripts
%{engine_data}/dbscripts


%files restapi

# Jar files:
%{engine_java}/interface-common-jaxrs.jar
%{engine_java}/restapi-definition.jar
%{engine_java}/restapi-jaxrs.jar
%{engine_java}/restapi-types.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-interface-common-jaxrs.pom
%{_mavenpomdir}/JPP.%{name}-restapi-definition.pom
%{_mavenpomdir}/JPP.%{name}-restapi-jaxrs.pom
%{_mavenpomdir}/JPP.%{name}-restapi-parent.pom
%{_mavenpomdir}/JPP.%{name}-restapi-types.pom
%endif

# Everything inside of the web application is owned by this
# subpackage:
%{restapi_war}


%files genericapi

# Jar files:
%{engine_java}/genericapi.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-genericapi.pom
%endif

# Link to the jar file inside the ear:
%{engine_ear}/engine-genericapi.jar


%files userportal
%config(noreplace) %{engine_etc}/usbfilter.txt
%{engine_ear}/userportal.war


%files webadmin-portal
%{engine_ear}/webadmin.war


%files tools-common

# Scripts:
%{engine_data}/bin/engine-prolog.sh

# Jar files:
%{engine_java}/engine-tools-common.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-engine-tools-common.pom
%endif


%files config

# Scripts and links:
%{_bindir}/engine-config
%{_bindir}/engine-manage-domains
%{engine_data}/bin/engine-config.sh
%{engine_data}/bin/engine-manage-domains.sh

# Configuration files for the configuration tool:
%dir %{engine_etc}/engine-config
%config(noreplace) %{engine_etc}/engine-config/engine-config.conf
%{engine_etc}/engine-config/engine-config.*properties
%{engine_etc}/engine-config/log4j.xml

# Configuration files for the domain management tool:
%dir %{engine_etc}/engine-manage-domains
%config(noreplace) %{engine_etc}/engine-manage-domains/engine-manage-domains.conf
%{engine_etc}/engine-manage-domains/log4j.xml


%files notification-service

# Startup scripts:
%{engine_data}/bin/engine-notifier.sh
%{_initddir}/engine-notifierd

# Log and state directories must be owned by ovirt because the notifier service
# runs with that user and needs to write them:
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}/notifier
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_run}/notifier

# Configuration files:
%dir %{engine_etc}/notifier
%config(noreplace) %attr(-, %{engine_user}, %{engine_group}) %{engine_etc}/notifier/notifier.conf
%{engine_etc}/notifier/log4j.xml

# Jar files:
%{engine_java}/engine-notifier-service.jar

# POM files:
%if %{install_poms}
%{_mavenpomdir}/JPP.%{name}-engine-notifier.pom
%endif


%changelog
* Fri Nov 02 2012 Juan Hernandez <juan.hernandez@redhat.com> - 3.2.0-1
- Bump version to 3.2.0

* Mon May 07 2012 Keith Robertson <kroberts@redhat.com> - 3.1.0-3
- Removed image uploader, iso uploader, and log collector from this
  git repo.  The are now in their own respective ovirt.org git
  repos. BZ#803240.

* Wed Apr 04 2012 Stephen Gordon <sgordon@redhat.com> - 3.1.0-2
- The ovirt-engine spec file did not previously contain a BuildRequires
  statement for the maven package. As a result in mock environments the
  build failed with an error when attempting to call the 'mvn' binary -
  BZ#807761.

* Wed Jan 04 2012 Ronen Angluste <ranglust@redhat.com> - 3.1.0-1
- Adjust code for Jboss AS 7.1

* Sun Dec 11 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Moved all hard coded paths to macros

* Wed Oct 26 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Initial build
- Cloned from RHEVM spec file
