#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%global		package_version 3.3.0_beta1
%global		package_name ovirt-image-uploader

Summary:	Image Uploader for oVirt Engine
Name:		%{package_name}
Version:	3.3.0
Release:	0.1.beta1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/releases/3.3/src/%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch
Requires:	python
Requires:	ovirt-engine-sdk
BuildRequires:	python2-devel
BuildRequires:	gettext

%description
Image Uploader tool for oVirt Engine

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc AUTHORS
%doc COPYING
%config(noreplace) %{_sysconfdir}/ovirt-engine/imageuploader.conf
%{_sysconfdir}/ovirt-engine/imageuploader.conf.d/.keep
%{python_sitelib}/ovirt_image_uploader/*.py*
%{python_sitelib}/ovirt_image_uploader/ovf/*.py*
%{_bindir}/engine-image-uploader
%{_mandir}/man8/*

%changelog
* Mon Jul 15 2013 Kiril Nesenko <knesenko@redhat.com> - 3.3.0-0.1.beta1
- 3.3.0-0.1.beta1

* Thu Feb 14 2013 Kiril Nesenko <knesenko@redhat.com> - 3.2.0-1
- 3.2.0-1

* Tue Feb 5 2013 Kiril Nesenko <knesenko@redhat.com> - 3.2.0-0.1.beta
- 3.2.0-0.1.beta

* Thu Jan 17 2013 Kiril Nesenko <knesenko@redhat.com> - 1.0.0-0
- Rewrite build

* Thu Mar 8 2012 Keith Robertson <kroberts@redhat.com> - 1.0.0-0
- Initial build
