#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2012-2014 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global     package_version 10.0.1
%global     package_name ovirt-release

Summary:	oVirt repository files
Name:		%{package_name}
Version:	10.0.1
Release:	3%{?release_suffix}
License:	ASL 2.0
URL:		http://ovirt.org
Source:		%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch
Requires:   tar
BuildRequires: automake autoconf
Epoch: 0

%package	fedora
Summary:	oVirt Repository Files for Fedora systems
Group:		System Environment/Base
Requires:	fedora-release
Obsoletes:  ovirt-release <= 0:4-1
Provides:   ovirt-release = %{epoch}:%{version}-%{release}
Requires:   tar

%package	el6
Summary:    oVirt Repository Files for EL6 systems
Group:		System Environment/Base
Requires:	/etc/system-release
Requires:   tar
Requires:   epel-release

%description
should be nothing...

%description fedora
oVirt repository file required to obtain stable releases, beta,
and nightly versions for Fedora systems.

%description el6
oVirt repository file required to obtain stable releases, beta,
and nightly versions for EL6 based systems.

%prep
%setup -q -n %{package_name}-%{package_version}

%build

%install
rm -rf "%{buildroot}"
install -d 755 "%{buildroot}"/etc/yum.repos.d
install -m 644 fedora-ovirt.repo "%{buildroot}"/etc/yum.repos.d/ovirt.repo
install -m 644 fedora-virt-preview.repo "%{buildroot}"/etc/yum.repos.d/fedora-virt-preview.repo
install -m 644 el6-ovirt.repo "%{buildroot}"/etc/yum.repos.d
install -m 644 glusterfs-epel.repo "%{buildroot}"/etc/yum.repos.d

%clean
rm -rf "%{buildroot}"

%files fedora
%defattr(-,root,root,-)
%doc COPYING
%config(noreplace) /etc/yum.repos.d/ovirt.repo
%config(noreplace) /etc/yum.repos.d/fedora-virt-preview.repo

%files el6
%defattr(-,root,root,-)
%doc COPYING
%config(noreplace) /etc/yum.repos.d/el6-ovirt.repo
%config(noreplace) /etc/yum.repos.d/glusterfs-epel.repo

%changelog
* Wed Jan 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 10.0.1-3
- new ovirt-3.3.3 repository, Releasing oVirt 3.3.3
- 3.3.2 packages are now in stable

* Wed Jan 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 10.0.1-2
- Update the repositories with 3.4.0_pre for testing (disabled by default)

* Wed Jan 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 10.0.1-1
- Update the repositories with 3.4.0_pre for testing

* Mon Jan 13 2014 Kiril Nesenko <knesenko@redhat.com> - 10-2
- Update the repositories with 3.4.0-alpha testing

* Thu Dec 19 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 10-1
- new ovirt-3.3.2 repository, Releasing oVirt 3.3.2
- ovirt-stable repository now provides Older Stable builds.
- ovirt-updates-testing provides Test Updates builds
- removed ovirt-alpha, obsolete and no longer used in oVirt >= 3.3.0.

* Thu Nov 28 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 9-1
- change glusterfs-epel to use LATEST branch

* Thu Aug 22 2013 Mike Burns <mburns@redhat.com> - 8-1
- Add glusterfs-epel repo to el6 package

* Wed Jun 26 2013 Mike Burns <mburns@redhat.com> - 7-1
- Add Fedora virt-preview repo for Fedora builds

* Tue May 07 2013 Mike Burns <mburns@redhat.com> - 6-1
- Add updates-testing repository

* Thu Jun 14 2012 Mike Burns <mburns@redhat.com> - 2-1
- Add Beta repo
- convert to automake/autoconf build system.

* Mon Mar 19 2012 Stephen Gordon <sgordon@redhat.com> - 1-2
- Removed SRPM repositories as they do not exist.
* Thu Nov 24 2011 Stephen Gordon <sgordon@redhat.com> - 1-1
- Initial creation.
