#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for STIG for Apache ActiveMQ
#
# Profile Description:
# This is a *draft* profile for STIG. This profile is being developed under the DoD consensus model to become a STIG in coordination with DISA FSO.
#
# Profile ID:  amq-stig
# Benchmark ID:  Jboss-Fuse-6
# Benchmark Version:  0.1.61
# XCCDF Version:  1.1
#
# This file was generated by OpenSCAP 1.3.5 using:
# $ oscap xccdf generate fix --profile amq-stig --fix-type bash xccdf-file.xml
#
# This Bash Remediation Script is generated from an OpenSCAP profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 67) for 'jboss_activemq-cleartext_passwords'
###############################################################################
(>&2 echo "Remediating rule 1/67: 'jboss_activemq-cleartext_passwords'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-cleartext_passwords' IS MISSING!")

# END fix for 'jboss_activemq-cleartext_passwords'

###############################################################################
# BEGIN fix (2 / 67) for 'jboss_activemq-default_roles_removed'
###############################################################################
(>&2 echo "Remediating rule 2/67: 'jboss_activemq-default_roles_removed'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-default_roles_removed' IS MISSING!")

# END fix for 'jboss_activemq-default_roles_removed'

###############################################################################
# BEGIN fix (3 / 67) for 'jboss_activemq-default_users_removed'
###############################################################################
(>&2 echo "Remediating rule 3/67: 'jboss_activemq-default_users_removed'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-default_users_removed' IS MISSING!")

# END fix for 'jboss_activemq-default_users_removed'

###############################################################################
# BEGIN fix (4 / 67) for 'jboss_activemq-encrypted_passwords'
###############################################################################
(>&2 echo "Remediating rule 4/67: 'jboss_activemq-encrypted_passwords'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-encrypted_passwords' IS MISSING!")

# END fix for 'jboss_activemq-encrypted_passwords'

###############################################################################
# BEGIN fix (5 / 67) for 'jboss_activemq-file_permissions'
###############################################################################
(>&2 echo "Remediating rule 5/67: 'jboss_activemq-file_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-file_permissions' IS MISSING!")

# END fix for 'jboss_activemq-file_permissions'

###############################################################################
# BEGIN fix (6 / 67) for 'jboss_activemq-java_aaa_service'
###############################################################################
(>&2 echo "Remediating rule 6/67: 'jboss_activemq-java_aaa_service'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-java_aaa_service' IS MISSING!")

# END fix for 'jboss_activemq-java_aaa_service'

###############################################################################
# BEGIN fix (7 / 67) for 'jboss_activemq-pki_dod_certificates'
###############################################################################
(>&2 echo "Remediating rule 7/67: 'jboss_activemq-pki_dod_certificates'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-pki_dod_certificates' IS MISSING!")

# END fix for 'jboss_activemq-pki_dod_certificates'

###############################################################################
# BEGIN fix (8 / 67) for 'jboss_activemq-pki_web_console'
###############################################################################
(>&2 echo "Remediating rule 8/67: 'jboss_activemq-pki_web_console'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-pki_web_console' IS MISSING!")

# END fix for 'jboss_activemq-pki_web_console'

###############################################################################
# BEGIN fix (9 / 67) for 'jboss_activemq-security_config_attributes'
###############################################################################
(>&2 echo "Remediating rule 9/67: 'jboss_activemq-security_config_attributes'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-security_config_attributes' IS MISSING!")

# END fix for 'jboss_activemq-security_config_attributes'

###############################################################################
# BEGIN fix (10 / 67) for 'jboss_activemq-ssl_enabled'
###############################################################################
(>&2 echo "Remediating rule 10/67: 'jboss_activemq-ssl_enabled'")
(>&2 echo "FIX FOR THIS RULE 'jboss_activemq-ssl_enabled' IS MISSING!")

# END fix for 'jboss_activemq-ssl_enabled'

###############################################################################
# BEGIN fix (11 / 67) for 'jboss_karaf-config_file_permissions'
###############################################################################
(>&2 echo "Remediating rule 11/67: 'jboss_karaf-config_file_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-config_file_permissions' IS MISSING!")

# END fix for 'jboss_karaf-config_file_permissions'

###############################################################################
# BEGIN fix (12 / 67) for 'jboss_karaf-deployed_java_file_permissions'
###############################################################################
(>&2 echo "Remediating rule 12/67: 'jboss_karaf-deployed_java_file_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-deployed_java_file_permissions' IS MISSING!")

# END fix for 'jboss_karaf-deployed_java_file_permissions'

###############################################################################
# BEGIN fix (13 / 67) for 'jboss_karaf-deployed_java_network_permissions'
###############################################################################
(>&2 echo "Remediating rule 13/67: 'jboss_karaf-deployed_java_network_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-deployed_java_network_permissions' IS MISSING!")

# END fix for 'jboss_karaf-deployed_java_network_permissions'

###############################################################################
# BEGIN fix (14 / 67) for 'jboss_karaf-deployed_permissions'
###############################################################################
(>&2 echo "Remediating rule 14/67: 'jboss_karaf-deployed_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-deployed_permissions' IS MISSING!")

# END fix for 'jboss_karaf-deployed_permissions'

###############################################################################
# BEGIN fix (15 / 67) for 'jboss_karaf-deployed_runtime_permissions'
###############################################################################
(>&2 echo "Remediating rule 15/67: 'jboss_karaf-deployed_runtime_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-deployed_runtime_permissions' IS MISSING!")

# END fix for 'jboss_karaf-deployed_runtime_permissions'

###############################################################################
# BEGIN fix (16 / 67) for 'jboss_karaf-deployed_socket_permissions'
###############################################################################
(>&2 echo "Remediating rule 16/67: 'jboss_karaf-deployed_socket_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-deployed_socket_permissions' IS MISSING!")

# END fix for 'jboss_karaf-deployed_socket_permissions'

###############################################################################
# BEGIN fix (17 / 67) for 'jboss_karaf-disable_hot_deployment'
###############################################################################
(>&2 echo "Remediating rule 17/67: 'jboss_karaf-disable_hot_deployment'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-disable_hot_deployment' IS MISSING!")

# END fix for 'jboss_karaf-disable_hot_deployment'

###############################################################################
# BEGIN fix (18 / 67) for 'jboss_karaf-disable_services_ports'
###############################################################################
(>&2 echo "Remediating rule 18/67: 'jboss_karaf-disable_services_ports'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-disable_services_ports' IS MISSING!")

# END fix for 'jboss_karaf-disable_services_ports'

###############################################################################
# BEGIN fix (19 / 67) for 'jboss_karaf-dod_cns_certificates'
###############################################################################
(>&2 echo "Remediating rule 19/67: 'jboss_karaf-dod_cns_certificates'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-dod_cns_certificates' IS MISSING!")

# END fix for 'jboss_karaf-dod_cns_certificates'

###############################################################################
# BEGIN fix (20 / 67) for 'jboss_karaf-dod_hardware_pki_token'
###############################################################################
(>&2 echo "Remediating rule 20/67: 'jboss_karaf-dod_hardware_pki_token'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-dod_hardware_pki_token' IS MISSING!")

# END fix for 'jboss_karaf-dod_hardware_pki_token'

###############################################################################
# BEGIN fix (21 / 67) for 'jboss_karaf-downloaded_software_valid'
###############################################################################
(>&2 echo "Remediating rule 21/67: 'jboss_karaf-downloaded_software_valid'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-downloaded_software_valid' IS MISSING!")

# END fix for 'jboss_karaf-downloaded_software_valid'

###############################################################################
# BEGIN fix (22 / 67) for 'jboss_karaf-enable_encrypted_passwords'
###############################################################################
(>&2 echo "Remediating rule 22/67: 'jboss_karaf-enable_encrypted_passwords'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_encrypted_passwords' IS MISSING!")

# END fix for 'jboss_karaf-enable_encrypted_passwords'

###############################################################################
# BEGIN fix (23 / 67) for 'jboss_karaf-enable_fips_authentication'
###############################################################################
(>&2 echo "Remediating rule 23/67: 'jboss_karaf-enable_fips_authentication'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_fips_authentication' IS MISSING!")

# END fix for 'jboss_karaf-enable_fips_authentication'

###############################################################################
# BEGIN fix (24 / 67) for 'jboss_karaf-enable_fips_modules'
###############################################################################
(>&2 echo "Remediating rule 24/67: 'jboss_karaf-enable_fips_modules'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_fips_modules' IS MISSING!")

# END fix for 'jboss_karaf-enable_fips_modules'

###############################################################################
# BEGIN fix (25 / 67) for 'jboss_karaf-enable_ldap_ssl'
###############################################################################
(>&2 echo "Remediating rule 25/67: 'jboss_karaf-enable_ldap_ssl'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_ldap_ssl' IS MISSING!")

# END fix for 'jboss_karaf-enable_ldap_ssl'

###############################################################################
# BEGIN fix (26 / 67) for 'jboss_karaf-enable_pki_web_console'
###############################################################################
(>&2 echo "Remediating rule 26/67: 'jboss_karaf-enable_pki_web_console'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_pki_web_console' IS MISSING!")

# END fix for 'jboss_karaf-enable_pki_web_console'

###############################################################################
# BEGIN fix (27 / 67) for 'jboss_karaf-enable_secure_connections'
###############################################################################
(>&2 echo "Remediating rule 27/67: 'jboss_karaf-enable_secure_connections'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_secure_connections' IS MISSING!")

# END fix for 'jboss_karaf-enable_secure_connections'

###############################################################################
# BEGIN fix (28 / 67) for 'jboss_karaf-enable_ssl'
###############################################################################
(>&2 echo "Remediating rule 28/67: 'jboss_karaf-enable_ssl'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-enable_ssl' IS MISSING!")

# END fix for 'jboss_karaf-enable_ssl'

###############################################################################
# BEGIN fix (29 / 67) for 'jboss_karaf-file_permissions'
###############################################################################
(>&2 echo "Remediating rule 29/67: 'jboss_karaf-file_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-file_permissions' IS MISSING!")

# END fix for 'jboss_karaf-file_permissions'

###############################################################################
# BEGIN fix (30 / 67) for 'jboss_karaf-files_ownership'
###############################################################################
(>&2 echo "Remediating rule 30/67: 'jboss_karaf-files_ownership'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-files_ownership' IS MISSING!")

# END fix for 'jboss_karaf-files_ownership'

###############################################################################
# BEGIN fix (31 / 67) for 'jboss_karaf-java_aaa_service'
###############################################################################
(>&2 echo "Remediating rule 31/67: 'jboss_karaf-java_aaa_service'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-java_aaa_service' IS MISSING!")

# END fix for 'jboss_karaf-java_aaa_service'

###############################################################################
# BEGIN fix (32 / 67) for 'jboss_karaf-java_vendor_supported'
###############################################################################
(>&2 echo "Remediating rule 32/67: 'jboss_karaf-java_vendor_supported'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-java_vendor_supported' IS MISSING!")

# END fix for 'jboss_karaf-java_vendor_supported'

###############################################################################
# BEGIN fix (33 / 67) for 'jboss_karaf-ldap_securely_fail'
###############################################################################
(>&2 echo "Remediating rule 33/67: 'jboss_karaf-ldap_securely_fail'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-ldap_securely_fail' IS MISSING!")

# END fix for 'jboss_karaf-ldap_securely_fail'

###############################################################################
# BEGIN fix (34 / 67) for 'jboss_karaf-log_retention'
###############################################################################
(>&2 echo "Remediating rule 34/67: 'jboss_karaf-log_retention'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-log_retention' IS MISSING!")

# END fix for 'jboss_karaf-log_retention'

###############################################################################
# BEGIN fix (35 / 67) for 'jboss_karaf-logging_access'
###############################################################################
(>&2 echo "Remediating rule 35/67: 'jboss_karaf-logging_access'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-logging_access' IS MISSING!")

# END fix for 'jboss_karaf-logging_access'

###############################################################################
# BEGIN fix (36 / 67) for 'jboss_karaf-non-essential_bundles_features'
###############################################################################
(>&2 echo "Remediating rule 36/67: 'jboss_karaf-non-essential_bundles_features'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-non-essential_bundles_features' IS MISSING!")

# END fix for 'jboss_karaf-non-essential_bundles_features'

###############################################################################
# BEGIN fix (37 / 67) for 'jboss_karaf-pki_assocation_permission'
###############################################################################
(>&2 echo "Remediating rule 37/67: 'jboss_karaf-pki_assocation_permission'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-pki_assocation_permission' IS MISSING!")

# END fix for 'jboss_karaf-pki_assocation_permission'

###############################################################################
# BEGIN fix (38 / 67) for 'jboss_karaf-process_owner_console_access'
###############################################################################
(>&2 echo "Remediating rule 38/67: 'jboss_karaf-process_owner_console_access'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-process_owner_console_access' IS MISSING!")

# END fix for 'jboss_karaf-process_owner_console_access'

###############################################################################
# BEGIN fix (39 / 67) for 'jboss_karaf-process_owner_permissions'
###############################################################################
(>&2 echo "Remediating rule 39/67: 'jboss_karaf-process_owner_permissions'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-process_owner_permissions' IS MISSING!")

# END fix for 'jboss_karaf-process_owner_permissions'

###############################################################################
# BEGIN fix (40 / 67) for 'jboss_karaf-reduce_logging'
###############################################################################
(>&2 echo "Remediating rule 40/67: 'jboss_karaf-reduce_logging'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-reduce_logging' IS MISSING!")

# END fix for 'jboss_karaf-reduce_logging'

###############################################################################
# BEGIN fix (41 / 67) for 'jboss_karaf-remove_cleartext_passwords'
###############################################################################
(>&2 echo "Remediating rule 41/67: 'jboss_karaf-remove_cleartext_passwords'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-remove_cleartext_passwords' IS MISSING!")

# END fix for 'jboss_karaf-remove_cleartext_passwords'

###############################################################################
# BEGIN fix (42 / 67) for 'jboss_karaf-remove_default_roles'
###############################################################################
(>&2 echo "Remediating rule 42/67: 'jboss_karaf-remove_default_roles'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-remove_default_roles' IS MISSING!")

# END fix for 'jboss_karaf-remove_default_roles'

###############################################################################
# BEGIN fix (43 / 67) for 'jboss_karaf-remove_default_users'
###############################################################################
(>&2 echo "Remediating rule 43/67: 'jboss_karaf-remove_default_users'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-remove_default_users' IS MISSING!")

# END fix for 'jboss_karaf-remove_default_users'

###############################################################################
# BEGIN fix (44 / 67) for 'jboss_karaf-secure_java_security_manager'
###############################################################################
(>&2 echo "Remediating rule 44/67: 'jboss_karaf-secure_java_security_manager'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-secure_java_security_manager' IS MISSING!")

# END fix for 'jboss_karaf-secure_java_security_manager'

###############################################################################
# BEGIN fix (45 / 67) for 'jboss_karaf-secure_jmx_access'
###############################################################################
(>&2 echo "Remediating rule 45/67: 'jboss_karaf-secure_jmx_access'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-secure_jmx_access' IS MISSING!")

# END fix for 'jboss_karaf-secure_jmx_access'

###############################################################################
# BEGIN fix (46 / 67) for 'jboss_karaf-secure_logging'
###############################################################################
(>&2 echo "Remediating rule 46/67: 'jboss_karaf-secure_logging'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-secure_logging' IS MISSING!")

# END fix for 'jboss_karaf-secure_logging'

###############################################################################
# BEGIN fix (47 / 67) for 'jboss_karaf-secure_remote_access'
###############################################################################
(>&2 echo "Remediating rule 47/67: 'jboss_karaf-secure_remote_access'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-secure_remote_access' IS MISSING!")

# END fix for 'jboss_karaf-secure_remote_access'

###############################################################################
# BEGIN fix (48 / 67) for 'jboss_karaf-secure_web_console'
###############################################################################
(>&2 echo "Remediating rule 48/67: 'jboss_karaf-secure_web_console'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-secure_web_console' IS MISSING!")

# END fix for 'jboss_karaf-secure_web_console'

###############################################################################
# BEGIN fix (49 / 67) for 'jboss_karaf-security_config_attributes'
###############################################################################
(>&2 echo "Remediating rule 49/67: 'jboss_karaf-security_config_attributes'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-security_config_attributes' IS MISSING!")

# END fix for 'jboss_karaf-security_config_attributes'

###############################################################################
# BEGIN fix (50 / 67) for 'jboss_karaf-stored_passwords_encrypted'
###############################################################################
(>&2 echo "Remediating rule 50/67: 'jboss_karaf-stored_passwords_encrypted'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-stored_passwords_encrypted' IS MISSING!")

# END fix for 'jboss_karaf-stored_passwords_encrypted'

###############################################################################
# BEGIN fix (51 / 67) for 'jboss_karaf-system_admin_access'
###############################################################################
(>&2 echo "Remediating rule 51/67: 'jboss_karaf-system_admin_access'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-system_admin_access' IS MISSING!")

# END fix for 'jboss_karaf-system_admin_access'

###############################################################################
# BEGIN fix (52 / 67) for 'jboss_karaf-valid_dod_certificates'
###############################################################################
(>&2 echo "Remediating rule 52/67: 'jboss_karaf-valid_dod_certificates'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-valid_dod_certificates' IS MISSING!")

# END fix for 'jboss_karaf-valid_dod_certificates'

###############################################################################
# BEGIN fix (53 / 67) for 'jboss_karaf-vender_supported_version'
###############################################################################
(>&2 echo "Remediating rule 53/67: 'jboss_karaf-vender_supported_version'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-vender_supported_version' IS MISSING!")

# END fix for 'jboss_karaf-vender_supported_version'

###############################################################################
# BEGIN fix (54 / 67) for 'jboss_karaf-access_control_docs'
###############################################################################
(>&2 echo "Remediating rule 54/67: 'jboss_karaf-access_control_docs'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-access_control_docs' IS MISSING!")

# END fix for 'jboss_karaf-access_control_docs'

###############################################################################
# BEGIN fix (55 / 67) for 'jboss_karaf-application_data_flow_docs'
###############################################################################
(>&2 echo "Remediating rule 55/67: 'jboss_karaf-application_data_flow_docs'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-application_data_flow_docs' IS MISSING!")

# END fix for 'jboss_karaf-application_data_flow_docs'

###############################################################################
# BEGIN fix (56 / 67) for 'jboss_karaf-assign_administator'
###############################################################################
(>&2 echo "Remediating rule 56/67: 'jboss_karaf-assign_administator'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-assign_administator' IS MISSING!")

# END fix for 'jboss_karaf-assign_administator'

###############################################################################
# BEGIN fix (57 / 67) for 'jboss_karaf-auditing_policy'
###############################################################################
(>&2 echo "Remediating rule 57/67: 'jboss_karaf-auditing_policy'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-auditing_policy' IS MISSING!")

# END fix for 'jboss_karaf-auditing_policy'

###############################################################################
# BEGIN fix (58 / 67) for 'jboss_karaf-backup_schedule'
###############################################################################
(>&2 echo "Remediating rule 58/67: 'jboss_karaf-backup_schedule'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-backup_schedule' IS MISSING!")

# END fix for 'jboss_karaf-backup_schedule'

###############################################################################
# BEGIN fix (59 / 67) for 'jboss_karaf-deployed_apps-java_perm_docs'
###############################################################################
(>&2 echo "Remediating rule 59/67: 'jboss_karaf-deployed_apps-java_perm_docs'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-deployed_apps-java_perm_docs' IS MISSING!")

# END fix for 'jboss_karaf-deployed_apps-java_perm_docs'

###############################################################################
# BEGIN fix (60 / 67) for 'jboss_karaf-disaster_recovery'
###############################################################################
(>&2 echo "Remediating rule 60/67: 'jboss_karaf-disaster_recovery'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-disaster_recovery' IS MISSING!")

# END fix for 'jboss_karaf-disaster_recovery'

###############################################################################
# BEGIN fix (61 / 67) for 'jboss_karaf-disaster_recovery_exerises'
###############################################################################
(>&2 echo "Remediating rule 61/67: 'jboss_karaf-disaster_recovery_exerises'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-disaster_recovery_exerises' IS MISSING!")

# END fix for 'jboss_karaf-disaster_recovery_exerises'

###############################################################################
# BEGIN fix (62 / 67) for 'jboss_karaf-incident_response'
###############################################################################
(>&2 echo "Remediating rule 62/67: 'jboss_karaf-incident_response'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-incident_response' IS MISSING!")

# END fix for 'jboss_karaf-incident_response'

###############################################################################
# BEGIN fix (63 / 67) for 'jboss_karaf-incident_response_exercises'
###############################################################################
(>&2 echo "Remediating rule 63/67: 'jboss_karaf-incident_response_exercises'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-incident_response_exercises' IS MISSING!")

# END fix for 'jboss_karaf-incident_response_exercises'

###############################################################################
# BEGIN fix (64 / 67) for 'jboss_karaf-password_complexity_policy'
###############################################################################
(>&2 echo "Remediating rule 64/67: 'jboss_karaf-password_complexity_policy'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-password_complexity_policy' IS MISSING!")

# END fix for 'jboss_karaf-password_complexity_policy'

###############################################################################
# BEGIN fix (65 / 67) for 'jboss_karaf-password_expiration_policy'
###############################################################################
(>&2 echo "Remediating rule 65/67: 'jboss_karaf-password_expiration_policy'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-password_expiration_policy' IS MISSING!")

# END fix for 'jboss_karaf-password_expiration_policy'

###############################################################################
# BEGIN fix (66 / 67) for 'jboss_karaf-password_length_policy'
###############################################################################
(>&2 echo "Remediating rule 66/67: 'jboss_karaf-password_length_policy'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-password_length_policy' IS MISSING!")

# END fix for 'jboss_karaf-password_length_policy'

###############################################################################
# BEGIN fix (67 / 67) for 'jboss_karaf-physical_protections'
###############################################################################
(>&2 echo "Remediating rule 67/67: 'jboss_karaf-physical_protections'")
(>&2 echo "FIX FOR THIS RULE 'jboss_karaf-physical_protections' IS MISSING!")

# END fix for 'jboss_karaf-physical_protections'

