%if 0%{?fedora}
%global java_devel java-devel
%endif

%if 0%{?rhel}
%global java_devel java7-devel
%endif

%global product_name Reports package for oVirt Virtualization Management
%global product_description oVirt virtualization reports

%global engine_name ovirt-engine
%global reports_name ovirt-engine-reports
%global reports_jasper_suffix %{nil}
%global reports_java %{_javadir}/%{reports_name}
%global engine_group ovirt
%global engine_user ovirt

%global make_common_opts \\\
	-j1 \\\
	BUILD_VALIDATION=0 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE=%{release} \\\
	OVIRT_REPORTS_NAME=%{reports_name} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	PYTHON=%{__python} \\\
	PYTHON_DIR=%{python_sitelib} \\\
	JAVA_DIR=%{_javadir} \\\
	PKG_JAVA_DIR=%{reports_java} \\\
	PKG_LOG_DIR=%{_localstatedir}/log/%{reports_name} \\\
	PKG_STATE_DIR=%{_localstatedir}/lib/%{reports_name} \\\
	%{?BUILD_FLAGS:BUILD_FLAGS="%{BUILD_FLAGS}"} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name:		ovirt-engine-reports
Version:	3.4.2
Release:	1%{?release_suffix}%{?dist}
License:	AGPLv3
Summary:	%{product_name}
Group:		Virtualization/Management
URL:		http://www.ovirt.org
BuildArch:	noarch
Source0:	http://ovirt.org/releases/stable/src/ovirt-engine-reports-3.4.2.tar.gz

BuildRequires:	jasperreports-server%{reports_jasper_suffix} >= 5.5.0-6
BuildRequires:	%{java_devel}
BuildRequires:	jpackage-utils
BuildRequires:	log4j
BuildRequires:	make
BuildRequires:	ant

Requires:	%{name}-setup >= %{version}-%{release}
Requires:	jasperreports-server%{reports_jasper_suffix} < 5.6.0
Requires:	jasperreports-server%{reports_jasper_suffix} >= 5.5.0-6
Requires:	java
Requires:	jpackage-utils
Requires:	logrotate
Requires:	m2crypto
Requires:	%{engine_name} >= 3.4.0
Requires:	patch

# bug#862355
Requires:	liberation-mono-fonts

%description
The %{product_description} package provides a suite of
pre-configured reports and dashboards that enable you to
monitor the system. The reports module is based on
JasperReports and JasperServer, and can also be used to create
ad-hoc reports.

%package setup
Summary:	%{product_name} setup
Group:		Virtualization/Management
Requires:	cracklib-python
Requires:	libxml2-python
Requires:	%{engine_name}-dwh-setup
Requires:	%{engine_name}-setup-plugin-ovirt-engine-common
Requires:	python

%description setup
%{product_description} setup package.

%prep
%setup -c -T -a 0 -n ovirt-reports

%build
make %{make_common_opts}

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install DESTDIR="%{buildroot}"

# Compile python files
%{__python} -m compileall -f -q -d / "%{buildroot}"
%{__python} -O -m compileall -f -q -d / "%{buildroot}"

#
# /var creation
#
install -dm 755 "%{buildroot}/%{_localstatedir}/lib/%{reports_name}"
install -dm 755 "%{buildroot}/%{_localstatedir}/log/%{reports_name}"

#
# Packaging branding
#
%if "%{name}" != "%{reports_name}"
ln -s "%{reports_name}" "%{buildroot}%{_javadir}/%{name}"
%endif

%postun
if [ "$1" -eq 0 ]; then
	rm -rf /var/lib/ovirt-engine-reports/%{reports_name}.war
	rm -f /var/lib/ovirt-engine/reports.xml
fi

%files
%config(noreplace) %{_sysconfdir}/logrotate.d/ovirt-engine-reports
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/lib/%{reports_name}
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/log/%{reports_name}
%{_localstatedir}/lib/ovirt-engine-reports/backups/
%{_sysconfdir}/ovirt-engine/engine.conf.d/20-ovirt-engine-reports.conf
%{reports_java}
%{_datadir}/%{reports_name}
%if "%{name}" != "%{reports_name}"
%{_javadir}/%{name}
%endif

%files setup
%{_datadir}/ovirt-engine/setup/ovirt_engine_setup/reports*
%{_datadir}/ovirt-engine/setup/plugins/*/ovirt-engine-reports/

%changelog
* Mon Jun 9 2014 Shirly Radco <sradco@redhat.com> - 3.4.2
oVirt 3.4.2 GA release.

Fixed issues:
-  Move JASPER_HOME init to common (#1098149)

* Wed May 7 2014 Shirly Radco <sradco@redhat.com> - 3.4.1
Fixed issues:
- Removing build-conf files on failure(#1091700 / #1084749)
- Do not check jasper home existance (#1093360)
- added leading question mark to dist tag (#1094024)

* Tue Apr 29 2014 Yaniv Dary <ydary@redhat.com> - 3.4.1
Fixed issues:
- Ask to config only during setup (#1080431)

* Wed Apr 23 2014 Yaniv Dary <ydary@redhat.com> - 3.4.1
fixed issue with log4j JRS patch (#1083501)

* Tue Apr 1 2014 Yaniv Dary <ydary@redhat.com> - 3.4.1
Fixed issues:
- Added strandard logrotate config file for JRS log.
- set legacy reports war from env (#1077775)

* Mon Mar 24 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
Fixed issues:
- 'Install' is now 'Configure' in DWH/Reports questions (#1064876)
- fix typo in manual instructions (#1067548)

* Tue Mar 11 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
oVirt 3.4.0 GA release.

Fixed issues:
1017183 - Wrong reference in error message
1031612 - BR18 - the numbers of OSs are incorrect

* Mon Feb 17 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
- Moved war customization to patches instead of overwrites
- Moved to otopi setup.
- Admin user name is now 'admin' in clean installations.
- A new folder called 'Saved Reports' is now saved between upgrades.

* Sun Nov 4 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
- Update
* Wed Feb 15 2012 Yaniv Dary <ydary@redhat.com> - 3.0.2
- Initial Commit
