#
# ovirt-hosted-engine-setup -- ovirt hosted engine setup
# Copyright (C) 2013-2014 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global         engine ovirt-engine
%global         package_version 1.1.3
%global         package_maven_version 1.1.0
%global         ovirt_hosted_engine_setup_templates %{_datadir}/%{name}/templates
%global         ovirt_hosted_engine_setup_scripts %{_datadir}/%{name}/scripts
%global         vdsmhooksdir %{_libexecdir}/vdsm/hooks


Summary:        oVirt hosted engine setup tool
Name:           ovirt-hosted-engine-setup
Version:        1.1.3
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

Requires:       python
Requires:       python-ethtool >= 0.6-3
Requires:       otopi >= 1.2.0
Requires:       vdsm >= 4.14.0
Requires:       vdsm-cli >= 4.14.0
Requires:       vdsm-python >= 4.14.0
Requires:       ovirt-host-deploy >= 1.2.0
Requires:       openssh-server
Requires:       python-paramiko
Requires:       virt-viewer
Requires:       openssl
Requires:       sudo
Requires:       bind-utils
Requires:       ovirt-hosted-engine-ha >= 1.1.3
Requires:       sanlock >= 2.8
Requires:       sanlock-python >= 2.8
Requires:       lsof
Requires:       iptables
BuildRequires:  gettext
BuildRequires:  otopi-devtools >= 1.2.0
BuildRequires:  python2-devel

Requires:       %{engine}-sdk-python >= 3.4.0.7
Requires:       qemu-img

%description
Hosted engine tool for oVirt project.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc COPYING
%doc README
%dir %{_sysconfdir}/ovirt-hosted-engine-setup.env.d
%dir %{_sysconfdir}/ovirt-hosted-engine
%dir %{_localstatedir}/log/ovirt-hosted-engine-setup
%{_sbindir}/hosted-engine
%{_sbindir}/%{name}
%{python_sitelib}/ovirt_hosted_engine_setup/
%{_datadir}/%{name}/
%{_mandir}/man8/*

#move to a separate package?
%{vdsmhooksdir}/before_vm_start/

%changelog
* Tue May 06 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.3-1
- updated to 1.1.3

* Mon Mar 24 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.3-0.0.master
- 1.1.3-0.0.master

* Mon Mar 24 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.2-1
- 1.1.2-1

* Mon Mar 17 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.2-0.0.master
- 1.1.2-0.0.master

* Mon Mar 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.1-1
- 1.1.1-1

* Mon Feb 24 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.1-0.0.master
- 1.1.1-0.0.master

* Mon Feb 24 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-1
- 1.1.0-1

* Mon Feb 17 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-0.7.beta3
- 1.1.0-0.7.beta3

* Thu Feb  6 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-0.5.beta2
- beta 2 respin, updating dependencies on otopi devel package

* Wed Feb  5 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-0.3.beta2
- 1.1.0-0.3.beta2

* Fri Jan 17 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-0.1.beta1
- 1.1.0-0.1.beta1
