%define is_f19 %(test "0%{?fedora}" -eq "019" && echo 1 || echo 0)

Summary:        A plugin to make oVirt Node installs compatible with oVirt Engine and vdsm
Name:           ovirt-node-plugin-vdsm
Version:        0.1.2
Release:        0%{?BUILD_NUMBER}%{?extra_release}%{?dist}
Source0:        %{name}-%{version}.tar.gz
License:        GPLv2+
Group:          Applications/System

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-buildroot
URL:            http://www.ovirt.org/
Requires:       ovirt-node >= 3.0.0
Requires:       python
Requires:       vdsm-reg >= 4.10.3
Requires:       ovirt-host-deploy-offline >= 1.1.0
%if ! 0%{?rhel}
Requires:       vdsm-hook-vhostmd
%endif
Requires:       vdsm-gluster
Requires(post): augeas

BuildArch:      noarch
BuildRequires:  python2-devel

%define app_root %{_datadir}/%{name}
%define recipe_root %{_datadir}/ovirt-node-recipe

%description
Provides UI and associated scripts for integrating oVirt Node and oVirt Engine

%package recipe
Summary:        Kickstarts for building oVirt Node isos including %{name}
Group:          Applications/System
Requires:       ovirt-node-recipe >= 2.6.0

%description recipe
Provides kickstart files for generating an oVirt Node ISO image containing
%{name}.

%prep
%setup -q


%build
%configure

%install
%{__rm} -rf %{buildroot}
make install DESTDIR=%{buildroot}

%post
# reserve vdsm port 54321
augtool << \EOF_sysctl
set /files/etc/sysctl.conf/net.ipv4.ip_local_reserved_ports 54321
save
EOF_sysctl

#SELinux Booleans
/usr/sbin/setsebool -P virt_use_nfs=1 \
                       virt_use_sanlock=1 \
                       sanlock_use_nfs=1

# ensure Network Manager is disabled
%if %{is_f19}
/usr/bin/systemctl mask NetworkManager.service
%endif

%preun

%files recipe
%{recipe_root}

%files
%{python_sitelib}/ovirt/node/setup/vdsm
%{_sysconfdir}/ovirt-plugins.d

%changelog
* Mon Apr 21 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.2-0
- spec: remove uneeded sed's (BZ#1088218)
- engine_page: add compatiblePort() to src
- engine_page: Display correctly proto for Manage by (BZ#1065401)
- engine_page: Remove Retrieve Certificate button (BZ#1081042)
- engine_page: network is required to register tab (BZ#1064206)

* Mon Feb 17 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.1-10
- engine_page: order imports
- engine_page: use vdsm to detect mgmt interface (BZ#1058257)
- engine_page: remove unused app from ovirt.node
- engine_page: remove unused import: exceptions
- engine_page: display url/port only on availble (BZ#1057453)

* Thu Jan 23 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.1-9
- engine_page: replace log import (BZ#1019859)

* Thu Jan 9 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.1-8
- Use Management class to pass informations (BZ#1048929)

* Fri Nov 22 2013 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.1-7
- engine_page: ovirt.node.config.defaults SSH (BZ#901497)

* Wed Nov 06 2013 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.1-6
- engine_page: replace != None to is not None
- engine_page: valid.Empty() handling None
- engine_page: fix logic to show fingerprint msg
- engine_page: replace TBD string

* Mon Oct 21 2013 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.1.1-5
- engine_page: Add validation for cert remove

* Fri May 17 2013 Mike Burns <mburns@redhat.com> 0.0.2
- Rename to ovirt-node-plugin-vdsm
- rebase onto ovirt-node 3.0.0 codebase
- add note about changing sshd when setting passwd
- fix password changing
- fix some requirements
- add minimization

* Fri Feb 15 2013 Mike Burns <mburns@redhat.com> 0.0.1
- initial commit
- engine_page from current ovirt-node
