#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2012-2015 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 002
%global	package_name ovirt-release35
%global	ovirt_version 3.5

Name:		%{package_name}
Version:	002
Release:	1%{?release_suffix}
Summary:	oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	http://resources.ovirt.org/pub/keys/RPM-GPG-ovirt

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:		system-release
Requires:		tar

%description
This package contains the yum configuration for oVirt repositories

%package snapshot
Summary:	oVirt snapshot repository configuration
Group:		System Environment/Base
Requires:	%{package_name}


%description snapshot
This package contains the yum configuration for oVirt snapshot repositories


%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
    DIST=el
fi

sed \
    -e "s/@DIST@/${DIST}/g" \
    <"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

if [ "${DISTVER}" == "el6" ] ; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-el6-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [ "${DISTVER/.*/}" == "el7" ] ; then
    # On CentOS 7 ${DISTVER} is "el7.centos"
    install -m 644 "%{_datadir}/%{package_name}/ovirt-el7-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [ "${DISTVER}" == "fc19" ]; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-f19-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [ "${DISTVER}" == "fc20" ]; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-f20-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

%post snapshot

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
    DIST=el
fi

sed \
    -e "s/@DIST@/${DIST}/g" \
    <"%{_datadir}/%{package_name}/ovirt-snapshot.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"


%files
%defattr(-,root,root,-)
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files snapshot
%defattr(-,root,root,-)
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo


%changelog
* Wed Jan 21 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-1
- Release 002

* Mon Nov 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 002-0.0.master
- provide EL7 dependencies

* Fri Sep 26 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-1
- Release 001

* Tue Aug 12 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.5.rc2
- provide ioprocess rpms from EPEL repositories for python-ioprocess
- provide rubygem-rgen rpms from EPEL repositories for puppet

* Fri Aug  1 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.4.rc1
- provide EL7 dependencies
- add python-ioprocess from EPEL repository for vdsm.

* Fri Jul 18 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.3.beta2
- provide snapshot repositories

* Wed Jul 16 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.2.beta2
- add python-IPy from EPEL repository for ovirt-node.

* Tue Jul  8 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.1.beta1
- Add PatternFly copr repositories

* Fri May 16 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.0.alpha1
- Provide oVirt 3.5.0 alpha1 repositories
