// ============================================================================
//
// Copyright (c) 2006-2014, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.parallelrun_3_6;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

//the import part of tJava_2
//import java.util.List;

//the import part of tJava_3
//import java.util.List;

//the import part of tJava_4
//import java.util.List;

//the import part of tJava_5
//import java.util.List;

@SuppressWarnings("unused")
/**
 * Job: ParallelRun Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 5.6.1.20141207_1530
 * @status 
 */
public class ParallelRun implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (hoursToKeepDaily != null) {

				this.setProperty("hoursToKeepDaily",
						hoursToKeepDaily.toString());

			}

			if (hoursToKeepHourly != null) {

				this.setProperty("hoursToKeepHourly",
						hoursToKeepHourly.toString());

			}

			if (hoursToKeepSamples != null) {

				this.setProperty("hoursToKeepSamples",
						hoursToKeepSamples.toString());

			}

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runDeleteTime != null) {

				this.setProperty("runDeleteTime", runDeleteTime.toString());

			}

			if (runInterleave != null) {

				this.setProperty("runInterleave", runInterleave.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

			if (timeBetweenErrorEvents != null) {

				this.setProperty("timeBetweenErrorEvents",
						timeBetweenErrorEvents.toString());

			}

		}

		public Integer hoursToKeepDaily;

		public Integer getHoursToKeepDaily() {
			return this.hoursToKeepDaily;
		}

		public Integer hoursToKeepHourly;

		public Integer getHoursToKeepHourly() {
			return this.hoursToKeepHourly;
		}

		public Integer hoursToKeepSamples;

		public Integer getHoursToKeepSamples() {
			return this.hoursToKeepSamples;
		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public Integer runDeleteTime;

		public Integer getRunDeleteTime() {
			return this.runDeleteTime;
		}

		public Integer runInterleave;

		public Integer getRunInterleave() {
			return this.runInterleave;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}

		public Long timeBetweenErrorEvents;

		public Long getTimeBetweenErrorEvents() {
			return this.timeBetweenErrorEvents;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "3.6";
	private final String jobName = "ParallelRun";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	public boolean isExportedAsOSGI = false;

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private java.lang.Exception exception = null;

	public java.lang.Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends java.lang.Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private java.lang.Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(java.lang.Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public java.lang.Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(java.lang.Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					ParallelRun.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(ParallelRun.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (java.lang.SecurityException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalArgumentException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalAccessException e) {
					this.e.printStackTrace();
				} catch (java.lang.reflect.InvocationTargetException e) {
					this.e.printStackTrace();
				} catch (TalendException e) {
					// do nothing
				}

			}
		}
	}

	public void tPrejob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tInfiniteLoop_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tInfiniteLoop_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tInfiniteLoop_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tInfiniteLoop_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tInfiniteLoop_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tInfiniteLoop_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tInfiniteLoop_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tInfiniteLoop_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tInfiniteLoop_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPrejob_1 begin ] start
				 */

				ok_Hash.put("tPrejob_1", false);
				start_Hash.put("tPrejob_1", System.currentTimeMillis());

				currentComponent = "tPrejob_1";

				int tos_count_tPrejob_1 = 0;

				/**
				 * [tPrejob_1 begin ] stop
				 */

				/**
				 * [tPrejob_1 main ] start
				 */

				currentComponent = "tPrejob_1";

				tos_count_tPrejob_1++;

				/**
				 * [tPrejob_1 main ] stop
				 */

				/**
				 * [tPrejob_1 end ] start
				 */

				currentComponent = "tPrejob_1";

				ok_Hash.put("tPrejob_1", true);
				end_Hash.put("tPrejob_1", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tPrejob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPrejob_1 finally ] start
				 */

				currentComponent = "tPrejob_1";

				/**
				 * [tPrejob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "engine";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				tJDBCConnection_2Process(globalMap);

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_2 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_2 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_2 = decryptedPassword_tJDBCConnection_2;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "sample_ovirt_engine_history";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_2, dbUser_tJDBCConnection_2,
						dbPwd_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// dbUser_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// dbPwd_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */

				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */

				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJDBCConnection_2:OnSubjobOk",
						"", Thread.currentThread().getId() + "", "", "", "",
						"", "");
			}

			tJDBCConnection_3Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_3 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_3", false);
				start_Hash.put("tJDBCConnection_3", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_3";

				int tos_count_tJDBCConnection_3 = 0;

				String url_tJDBCConnection_3 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_3 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_3 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_3 = decryptedPassword_tJDBCConnection_3;

				java.sql.Connection conn_tJDBCConnection_3 = null;

				String sharedConnectionName_tJDBCConnection_3 = "hourly_ovirt_engine_history";
				conn_tJDBCConnection_3 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_3, dbUser_tJDBCConnection_3,
						dbPwd_tJDBCConnection_3,
						sharedConnectionName_tJDBCConnection_3);
				if (null != conn_tJDBCConnection_3) {

					conn_tJDBCConnection_3.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_3", conn_tJDBCConnection_3);
				globalMap.put("url_tJDBCConnection_3", url_tJDBCConnection_3);
				// globalMap.put("user_tJDBCConnection_3",
				// dbUser_tJDBCConnection_3);
				// globalMap.put("pass_tJDBCConnection_3",
				// dbPwd_tJDBCConnection_3);

				/**
				 * [tJDBCConnection_3 begin ] stop
				 */

				/**
				 * [tJDBCConnection_3 main ] start
				 */

				currentComponent = "tJDBCConnection_3";

				tos_count_tJDBCConnection_3++;

				/**
				 * [tJDBCConnection_3 main ] stop
				 */

				/**
				 * [tJDBCConnection_3 end ] start
				 */

				currentComponent = "tJDBCConnection_3";

				ok_Hash.put("tJDBCConnection_3", true);
				end_Hash.put("tJDBCConnection_3", System.currentTimeMillis());

				tJDBCConnection_4Process(globalMap);

				/**
				 * [tJDBCConnection_3 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_3 finally ] start
				 */

				currentComponent = "tJDBCConnection_3";

				/**
				 * [tJDBCConnection_3 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_3_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_4 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_4", false);
				start_Hash.put("tJDBCConnection_4", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_4";

				int tos_count_tJDBCConnection_4 = 0;

				String url_tJDBCConnection_4 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_4 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_4 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_4 = decryptedPassword_tJDBCConnection_4;

				java.sql.Connection conn_tJDBCConnection_4 = null;

				String sharedConnectionName_tJDBCConnection_4 = "daily_ovirt_engine_history";
				conn_tJDBCConnection_4 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_4, dbUser_tJDBCConnection_4,
						dbPwd_tJDBCConnection_4,
						sharedConnectionName_tJDBCConnection_4);
				if (null != conn_tJDBCConnection_4) {

					conn_tJDBCConnection_4.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_4", conn_tJDBCConnection_4);
				globalMap.put("url_tJDBCConnection_4", url_tJDBCConnection_4);
				// globalMap.put("user_tJDBCConnection_4",
				// dbUser_tJDBCConnection_4);
				// globalMap.put("pass_tJDBCConnection_4",
				// dbPwd_tJDBCConnection_4);

				/**
				 * [tJDBCConnection_4 begin ] stop
				 */

				/**
				 * [tJDBCConnection_4 main ] start
				 */

				currentComponent = "tJDBCConnection_4";

				tos_count_tJDBCConnection_4++;

				/**
				 * [tJDBCConnection_4 main ] stop
				 */

				/**
				 * [tJDBCConnection_4 end ] start
				 */

				currentComponent = "tJDBCConnection_4";

				ok_Hash.put("tJDBCConnection_4", true);
				end_Hash.put("tJDBCConnection_4", System.currentTimeMillis());

				tJDBCConnection_5Process(globalMap);

				/**
				 * [tJDBCConnection_4 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_4 finally ] start
				 */

				currentComponent = "tJDBCConnection_4";

				/**
				 * [tJDBCConnection_4 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_4_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_5 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_5", false);
				start_Hash.put("tJDBCConnection_5", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_5";

				int tos_count_tJDBCConnection_5 = 0;

				String url_tJDBCConnection_5 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_5 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_5 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_5 = decryptedPassword_tJDBCConnection_5;

				java.sql.Connection conn_tJDBCConnection_5 = null;

				String sharedConnectionName_tJDBCConnection_5 = "delete_ovirt_engine_history";
				conn_tJDBCConnection_5 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_5, dbUser_tJDBCConnection_5,
						dbPwd_tJDBCConnection_5,
						sharedConnectionName_tJDBCConnection_5);
				if (null != conn_tJDBCConnection_5) {

					conn_tJDBCConnection_5.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_5", conn_tJDBCConnection_5);
				globalMap.put("url_tJDBCConnection_5", url_tJDBCConnection_5);
				// globalMap.put("user_tJDBCConnection_5",
				// dbUser_tJDBCConnection_5);
				// globalMap.put("pass_tJDBCConnection_5",
				// dbPwd_tJDBCConnection_5);

				/**
				 * [tJDBCConnection_5 begin ] stop
				 */

				/**
				 * [tJDBCConnection_5 main ] start
				 */

				currentComponent = "tJDBCConnection_5";

				tos_count_tJDBCConnection_5++;

				/**
				 * [tJDBCConnection_5 main ] stop
				 */

				/**
				 * [tJDBCConnection_5 end ] start
				 */

				currentComponent = "tJDBCConnection_5";

				ok_Hash.put("tJDBCConnection_5", true);
				end_Hash.put("tJDBCConnection_5", System.currentTimeMillis());

				tJDBCConnection_6Process(globalMap);

				/**
				 * [tJDBCConnection_5 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_5 finally ] start
				 */

				currentComponent = "tJDBCConnection_5";

				/**
				 * [tJDBCConnection_5 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_5_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_6 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_6", false);
				start_Hash.put("tJDBCConnection_6", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_6";

				int tos_count_tJDBCConnection_6 = 0;

				String url_tJDBCConnection_6 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_6 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_6 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_6 = decryptedPassword_tJDBCConnection_6;

				java.sql.Connection conn_tJDBCConnection_6 = null;

				String sharedConnectionName_tJDBCConnection_6 = "engine-events";
				conn_tJDBCConnection_6 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_6, dbUser_tJDBCConnection_6,
						dbPwd_tJDBCConnection_6,
						sharedConnectionName_tJDBCConnection_6);
				if (null != conn_tJDBCConnection_6) {

					conn_tJDBCConnection_6.setAutoCommit(true);
				}

				globalMap.put("conn_tJDBCConnection_6", conn_tJDBCConnection_6);
				globalMap.put("url_tJDBCConnection_6", url_tJDBCConnection_6);
				// globalMap.put("user_tJDBCConnection_6",
				// dbUser_tJDBCConnection_6);
				// globalMap.put("pass_tJDBCConnection_6",
				// dbPwd_tJDBCConnection_6);

				/**
				 * [tJDBCConnection_6 begin ] stop
				 */

				/**
				 * [tJDBCConnection_6 main ] start
				 */

				currentComponent = "tJDBCConnection_6";

				tos_count_tJDBCConnection_6++;

				/**
				 * [tJDBCConnection_6 main ] stop
				 */

				/**
				 * [tJDBCConnection_6 end ] start
				 */

				currentComponent = "tJDBCConnection_6";

				ok_Hash.put("tJDBCConnection_6", true);
				end_Hash.put("tJDBCConnection_6", System.currentTimeMillis());

				tJDBCInput_1Process(globalMap);

				/**
				 * [tJDBCConnection_6 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_6 finally ] start
				 */

				currentComponent = "tJDBCConnection_6";

				/**
				 * [tJDBCConnection_6 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_6_SUBPROCESS_STATE", 1);
	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ParallelRun = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ParallelRun = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public java.util.Date value;

		public java.util.Date getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ParallelRun.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ParallelRun.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ParallelRun = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ParallelRun = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_ParallelRun, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ParallelRun, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ParallelRun) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// java.util.Date

				writeDate(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + String.valueOf(value));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row1Struct row1 = new row1Struct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_6");

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "select distinct 'runTime', CURRENT_TIMESTAMP(6)";

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);
				java.sql.ResultSet rs_tJDBCInput_1 = null;
				try {
					rs_tJDBCInput_1 = stmt_tJDBCInput_1
							.executeQuery(dbquery_tJDBCInput_1);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
							.getMetaData();
					int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
							.getColumnCount();

					String tmpContent_tJDBCInput_1 = null;

					while (rs_tJDBCInput_1.next()) {
						nb_line_tJDBCInput_1++;

						if (colQtyInRs_tJDBCInput_1 < 1) {
							row1.key = null;
						} else {

							tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
									.getString(1);
							if (tmpContent_tJDBCInput_1 != null) {
								row1.key = tmpContent_tJDBCInput_1;
							} else {
								row1.key = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 2) {
							row1.value = null;
						} else {

							java.util.Date date_tJDBCInput_1 = null;
							try {
								date_tJDBCInput_1 = rs_tJDBCInput_1
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_1 = rs_tJDBCInput_1.getDate(2);
							}
							row1.value = date_tJDBCInput_1;
						}

						/**
						 * [tJDBCInput_1 begin ] stop
						 */

						/**
						 * [tJDBCInput_1 main ] start
						 */

						currentComponent = "tJDBCInput_1";

						tos_count_tJDBCInput_1++;

						/**
						 * [tJDBCInput_1 main ] stop
						 */

						/**
						 * [tContextLoad_1 main ] start
						 */

						currentComponent = "tContextLoad_1";

						// ////////////////////////
						String tmp_key_tContextLoad_1 = null;

						String key_tContextLoad_1 = null;
						if (row1.key != null) {
							tmp_key_tContextLoad_1 = row1.key.trim();
							if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
									.startsWith("!"))) {
								tmp_key_tContextLoad_1 = null;
							} else {
								row1.key = tmp_key_tContextLoad_1;
							}
						}
						if (row1.key != null) {

							key_tContextLoad_1 =

							row1.key;

						}

						String value_tContextLoad_1 = null;
						if (row1.value != null) {

							value_tContextLoad_1 =

							FormatterUtils.format_Date(row1.value,
									"yyyy-MM-dd HH:mm:ss.SSSSSS");

						}

						if (tmp_key_tContextLoad_1 != null) {
							try {
								if (key_tContextLoad_1 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_1)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "runInterleave"
												.equals(key_tContextLoad_1)) {

									context.runInterleave = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "runTime".equals(key_tContextLoad_1)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_1));

								}

								if (key_tContextLoad_1 != null
										&& "timeBetweenErrorEvents"
												.equals(key_tContextLoad_1)) {

									context.timeBetweenErrorEvents = Long
											.parseLong(value_tContextLoad_1);

								}

								if (context.getProperty(key_tContextLoad_1) != null) {
									assignList_tContextLoad_1
											.add(key_tContextLoad_1);
								} else {
									newPropertyList_tContextLoad_1
											.add(key_tContextLoad_1);
								}
								context.setProperty(key_tContextLoad_1,
										value_tContextLoad_1);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_1
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_1++;
						}
						// ////////////////////////

						tos_count_tContextLoad_1++;

						/**
						 * [tContextLoad_1 main ] stop
						 */

						/**
						 * [tJDBCInput_1 end ] start
						 */

						currentComponent = "tJDBCInput_1";

					}
				} finally {
					if (rs_tJDBCInput_1 != null) {
						rs_tJDBCInput_1.close();
					}
					stmt_tJDBCInput_1.close();

				}
				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				List<String> parametersToEncrypt_tContextLoad_1 = new java.util.ArrayList<String>();

				parametersToEncrypt_tContextLoad_1.add("ovirtEngineDbPassword");

				parametersToEncrypt_tContextLoad_1
						.add("ovirtEngineHistoryDbPassword");

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context,
								parametersToEncrypt_tContextLoad_1));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public void tJava_2Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_2 begin ] start
				 */

				ok_Hash.put("tJava_2", false);
				start_Hash.put("tJava_2", System.currentTimeMillis());

				currentComponent = "tJava_2";

				int tos_count_tJava_2 = 0;

				Thread.sleep(TalendDate.diffDate(TalendDate.addDate(
						RoutineHistoryETL.startOfMinute(context.runTime), 1,
						"mm"), context.runTime, "SSS"));

				/**
				 * [tJava_2 begin ] stop
				 */

				/**
				 * [tJava_2 main ] start
				 */

				currentComponent = "tJava_2";

				tos_count_tJava_2++;

				/**
				 * [tJava_2 main ] stop
				 */

				/**
				 * [tJava_2 end ] start
				 */

				currentComponent = "tJava_2";

				ok_Hash.put("tJava_2", true);
				end_Hash.put("tJava_2", System.currentTimeMillis());

				/**
				 * [tJava_2 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJava_2:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tInfiniteLoop_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_2 finally ] start
				 */

				currentComponent = "tJava_2";

				/**
				 * [tJava_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_2_SUBPROCESS_STATE", 1);
	}

	public void tInfiniteLoop_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tInfiniteLoop_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tInfiniteLoop_1 begin ] start
				 */

				int NB_ITERATE_tRunJob_1 = 0; // for statistics

				ok_Hash.put("tInfiniteLoop_1", false);
				start_Hash.put("tInfiniteLoop_1", System.currentTimeMillis());

				currentComponent = "tInfiniteLoop_1";

				int tos_count_tInfiniteLoop_1 = 0;

				int counter_tInfiniteLoop_1 = 0;
				globalMap.put("tInfiniteLoop_1_CURRENT_ITERATION",
						counter_tInfiniteLoop_1);

				while (counter_tInfiniteLoop_1 > -1) {
					counter_tInfiniteLoop_1++;
					globalMap.put("tInfiniteLoop_1_CURRENT_ITERATION",
							counter_tInfiniteLoop_1);

					/**
					 * [tInfiniteLoop_1 begin ] stop
					 */

					/**
					 * [tInfiniteLoop_1 main ] start
					 */

					currentComponent = "tInfiniteLoop_1";

					tos_count_tInfiniteLoop_1++;

					/**
					 * [tInfiniteLoop_1 main ] stop
					 */
					NB_ITERATE_tRunJob_1++;

					/**
					 * [tRunJob_1 begin ] start
					 */

					ok_Hash.put("tRunJob_1", false);
					start_Hash.put("tRunJob_1", System.currentTimeMillis());

					currentComponent = "tRunJob_1";

					int tos_count_tRunJob_1 = 0;

					/**
					 * [tRunJob_1 begin ] stop
					 */

					/**
					 * [tRunJob_1 main ] start
					 */

					currentComponent = "tRunJob_1";

					java.util.List<String> paraList_tRunJob_1 = new java.util.ArrayList<String>();

					paraList_tRunJob_1.add("--father_pid=" + pid);

					paraList_tRunJob_1.add("--root_pid=" + rootPid);

					paraList_tRunJob_1.add("--father_node=tRunJob_1");

					paraList_tRunJob_1.add("--context=Default");

					// for feature:10589

					paraList_tRunJob_1.add("--stat_port=" + portStats);

					if (resuming_logs_dir_path != null) {
						paraList_tRunJob_1.add("--resuming_logs_dir_path="
								+ resuming_logs_dir_path);
					}
					String childResumePath_tRunJob_1 = ResumeUtil
							.getChildJobCheckPointPath(resuming_checkpoint_path);
					String tRunJobName_tRunJob_1 = ResumeUtil
							.getRighttRunJob(resuming_checkpoint_path);
					if ("tRunJob_1".equals(tRunJobName_tRunJob_1)
							&& childResumePath_tRunJob_1 != null) {
						paraList_tRunJob_1
								.add("--resuming_checkpoint_path="
										+ ResumeUtil
												.getChildJobCheckPointPath(resuming_checkpoint_path));
					}
					paraList_tRunJob_1.add("--parent_part_launcher=JOB:"
							+ jobName + "/NODE:tRunJob_1");

					java.util.Map<String, Object> parentContextMap_tRunJob_1 = new java.util.HashMap<String, Object>();

					context.synchronizeContext();
					java.util.Enumeration<?> propertyNames_tRunJob_1 = context
							.propertyNames();
					while (propertyNames_tRunJob_1.hasMoreElements()) {
						String key_tRunJob_1 = (String) propertyNames_tRunJob_1
								.nextElement();
						Object value_tRunJob_1 = (Object) context
								.get(key_tRunJob_1);
						paraList_tRunJob_1.add("--context_param "
								+ key_tRunJob_1 + "=" + value_tRunJob_1);
					}

					parentContextMap_tRunJob_1.put("hoursToKeepDaily",
							context.hoursToKeepDaily);

					parentContextMap_tRunJob_1.put("hoursToKeepHourly",
							context.hoursToKeepHourly);

					parentContextMap_tRunJob_1.put("hoursToKeepSamples",
							context.hoursToKeepSamples);

					parentContextMap_tRunJob_1.put("ovirtEngineDbDriverClass",
							context.ovirtEngineDbDriverClass);

					parentContextMap_tRunJob_1.put(
							"ovirtEngineDbJdbcConnection",
							context.ovirtEngineDbJdbcConnection);

					parentContextMap_tRunJob_1.put("ovirtEngineDbPassword",
							context.ovirtEngineDbPassword);

					parentContextMap_tRunJob_1.put("ovirtEngineDbUser",
							context.ovirtEngineDbUser);

					parentContextMap_tRunJob_1.put(
							"ovirtEngineHistoryDbDriverClass",
							context.ovirtEngineHistoryDbDriverClass);

					parentContextMap_tRunJob_1.put(
							"ovirtEngineHistoryDbJdbcConnection",
							context.ovirtEngineHistoryDbJdbcConnection);

					parentContextMap_tRunJob_1.put(
							"ovirtEngineHistoryDbPassword",
							context.ovirtEngineHistoryDbPassword);

					parentContextMap_tRunJob_1.put("ovirtEngineHistoryDbUser",
							context.ovirtEngineHistoryDbUser);

					parentContextMap_tRunJob_1.put("runDeleteTime",
							context.runDeleteTime);

					parentContextMap_tRunJob_1.put("runInterleave",
							context.runInterleave);

					parentContextMap_tRunJob_1.put("runTime", context.runTime);

					parentContextMap_tRunJob_1.put("timeBetweenErrorEvents",
							context.timeBetweenErrorEvents);

					Object obj_tRunJob_1 = null;

					ovirt_engine_dwh.sampletimekeepingjob_3_6.SampleTimeKeepingJob childJob_tRunJob_1 = new ovirt_engine_dwh.sampletimekeepingjob_3_6.SampleTimeKeepingJob();
					// pass DataSources
					java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_1 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					if (null != talendDataSources_tRunJob_1) {
						java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_1 = new java.util.HashMap<String, javax.sql.DataSource>();
						for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_1 : talendDataSources_tRunJob_1
								.entrySet()) {
							dataSources_tRunJob_1.put(
									talendDataSourceEntry_tRunJob_1.getKey(),
									talendDataSourceEntry_tRunJob_1.getValue()
											.getRawDataSource());
						}
						childJob_tRunJob_1
								.setDataSources(dataSources_tRunJob_1);
					}

					childJob_tRunJob_1.parentContextMap = parentContextMap_tRunJob_1;

					String[][] childReturn_tRunJob_1 = childJob_tRunJob_1
							.runJob((String[]) paraList_tRunJob_1
									.toArray(new String[paraList_tRunJob_1
											.size()]));

					((java.util.Map) threadLocal.get()).put("errorCode",
							childJob_tRunJob_1.getErrorCode());

					if (childJob_tRunJob_1.getErrorCode() == null) {
						globalMap.put(
								"tRunJob_1_CHILD_RETURN_CODE",
								childJob_tRunJob_1.getStatus() != null
										&& ("failure")
												.equals(childJob_tRunJob_1
														.getStatus()) ? 1 : 0);
					} else {
						globalMap.put("tRunJob_1_CHILD_RETURN_CODE",
								childJob_tRunJob_1.getErrorCode());
					}
					if (childJob_tRunJob_1.getExceptionStackTrace() != null) {
						globalMap.put("tRunJob_1_CHILD_EXCEPTION_STACKTRACE",
								childJob_tRunJob_1.getExceptionStackTrace());
					}

					tos_count_tRunJob_1++;

					/**
					 * [tRunJob_1 main ] stop
					 */

					/**
					 * [tRunJob_1 end ] start
					 */

					currentComponent = "tRunJob_1";

					ok_Hash.put("tRunJob_1", true);
					end_Hash.put("tRunJob_1", System.currentTimeMillis());

					/**
					 * [tRunJob_1 end ] stop
					 */

					/**
					 * [tInfiniteLoop_1 end ] start
					 */

					currentComponent = "tInfiniteLoop_1";

					Thread.sleep(0);
				}

				ok_Hash.put("tInfiniteLoop_1", true);
				end_Hash.put("tInfiniteLoop_1", System.currentTimeMillis());

				/**
				 * [tInfiniteLoop_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tInfiniteLoop_1 finally ] start
				 */

				currentComponent = "tInfiniteLoop_1";

				/**
				 * [tInfiniteLoop_1 finally ] stop
				 */

				/**
				 * [tRunJob_1 finally ] start
				 */

				currentComponent = "tRunJob_1";

				/**
				 * [tRunJob_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tInfiniteLoop_1_SUBPROCESS_STATE", 1);
	}

	public void tJava_3Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_3 begin ] start
				 */

				ok_Hash.put("tJava_3", false);
				start_Hash.put("tJava_3", System.currentTimeMillis());

				currentComponent = "tJava_3";

				int tos_count_tJava_3 = 0;

				Thread.sleep(TalendDate.diffDate(
						TalendDate.addDate(
								RoutineHistoryETL.startOfHour(context.runTime),
								1, "HH"), context.runTime, "SSS"));

				/**
				 * [tJava_3 begin ] stop
				 */

				/**
				 * [tJava_3 main ] start
				 */

				currentComponent = "tJava_3";

				tos_count_tJava_3++;

				/**
				 * [tJava_3 main ] stop
				 */

				/**
				 * [tJava_3 end ] start
				 */

				currentComponent = "tJava_3";

				ok_Hash.put("tJava_3", true);
				end_Hash.put("tJava_3", System.currentTimeMillis());

				/**
				 * [tJava_3 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJava_3:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tInfiniteLoop_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_3 finally ] start
				 */

				currentComponent = "tJava_3";

				/**
				 * [tJava_3 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_3_SUBPROCESS_STATE", 1);
	}

	public void tInfiniteLoop_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tInfiniteLoop_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tInfiniteLoop_2 begin ] start
				 */

				int NB_ITERATE_tRunJob_2 = 0; // for statistics

				ok_Hash.put("tInfiniteLoop_2", false);
				start_Hash.put("tInfiniteLoop_2", System.currentTimeMillis());

				currentComponent = "tInfiniteLoop_2";

				int tos_count_tInfiniteLoop_2 = 0;

				int counter_tInfiniteLoop_2 = 0;
				globalMap.put("tInfiniteLoop_2_CURRENT_ITERATION",
						counter_tInfiniteLoop_2);

				while (counter_tInfiniteLoop_2 > -1) {
					counter_tInfiniteLoop_2++;
					globalMap.put("tInfiniteLoop_2_CURRENT_ITERATION",
							counter_tInfiniteLoop_2);

					/**
					 * [tInfiniteLoop_2 begin ] stop
					 */

					/**
					 * [tInfiniteLoop_2 main ] start
					 */

					currentComponent = "tInfiniteLoop_2";

					tos_count_tInfiniteLoop_2++;

					/**
					 * [tInfiniteLoop_2 main ] stop
					 */
					NB_ITERATE_tRunJob_2++;

					/**
					 * [tRunJob_2 begin ] start
					 */

					ok_Hash.put("tRunJob_2", false);
					start_Hash.put("tRunJob_2", System.currentTimeMillis());

					currentComponent = "tRunJob_2";

					int tos_count_tRunJob_2 = 0;

					/**
					 * [tRunJob_2 begin ] stop
					 */

					/**
					 * [tRunJob_2 main ] start
					 */

					currentComponent = "tRunJob_2";

					java.util.List<String> paraList_tRunJob_2 = new java.util.ArrayList<String>();

					paraList_tRunJob_2.add("--father_pid=" + pid);

					paraList_tRunJob_2.add("--root_pid=" + rootPid);

					paraList_tRunJob_2.add("--father_node=tRunJob_2");

					paraList_tRunJob_2.add("--context=Default");

					// for feature:10589

					paraList_tRunJob_2.add("--stat_port=" + portStats);

					if (resuming_logs_dir_path != null) {
						paraList_tRunJob_2.add("--resuming_logs_dir_path="
								+ resuming_logs_dir_path);
					}
					String childResumePath_tRunJob_2 = ResumeUtil
							.getChildJobCheckPointPath(resuming_checkpoint_path);
					String tRunJobName_tRunJob_2 = ResumeUtil
							.getRighttRunJob(resuming_checkpoint_path);
					if ("tRunJob_2".equals(tRunJobName_tRunJob_2)
							&& childResumePath_tRunJob_2 != null) {
						paraList_tRunJob_2
								.add("--resuming_checkpoint_path="
										+ ResumeUtil
												.getChildJobCheckPointPath(resuming_checkpoint_path));
					}
					paraList_tRunJob_2.add("--parent_part_launcher=JOB:"
							+ jobName + "/NODE:tRunJob_2");

					java.util.Map<String, Object> parentContextMap_tRunJob_2 = new java.util.HashMap<String, Object>();

					context.synchronizeContext();
					java.util.Enumeration<?> propertyNames_tRunJob_2 = context
							.propertyNames();
					while (propertyNames_tRunJob_2.hasMoreElements()) {
						String key_tRunJob_2 = (String) propertyNames_tRunJob_2
								.nextElement();
						Object value_tRunJob_2 = (Object) context
								.get(key_tRunJob_2);
						paraList_tRunJob_2.add("--context_param "
								+ key_tRunJob_2 + "=" + value_tRunJob_2);
					}

					parentContextMap_tRunJob_2.put("hoursToKeepDaily",
							context.hoursToKeepDaily);

					parentContextMap_tRunJob_2.put("hoursToKeepHourly",
							context.hoursToKeepHourly);

					parentContextMap_tRunJob_2.put("hoursToKeepSamples",
							context.hoursToKeepSamples);

					parentContextMap_tRunJob_2.put("ovirtEngineDbDriverClass",
							context.ovirtEngineDbDriverClass);

					parentContextMap_tRunJob_2.put(
							"ovirtEngineDbJdbcConnection",
							context.ovirtEngineDbJdbcConnection);

					parentContextMap_tRunJob_2.put("ovirtEngineDbPassword",
							context.ovirtEngineDbPassword);

					parentContextMap_tRunJob_2.put("ovirtEngineDbUser",
							context.ovirtEngineDbUser);

					parentContextMap_tRunJob_2.put(
							"ovirtEngineHistoryDbDriverClass",
							context.ovirtEngineHistoryDbDriverClass);

					parentContextMap_tRunJob_2.put(
							"ovirtEngineHistoryDbJdbcConnection",
							context.ovirtEngineHistoryDbJdbcConnection);

					parentContextMap_tRunJob_2.put(
							"ovirtEngineHistoryDbPassword",
							context.ovirtEngineHistoryDbPassword);

					parentContextMap_tRunJob_2.put("ovirtEngineHistoryDbUser",
							context.ovirtEngineHistoryDbUser);

					parentContextMap_tRunJob_2.put("runDeleteTime",
							context.runDeleteTime);

					parentContextMap_tRunJob_2.put("runInterleave",
							context.runInterleave);

					parentContextMap_tRunJob_2.put("runTime", context.runTime);

					parentContextMap_tRunJob_2.put("timeBetweenErrorEvents",
							context.timeBetweenErrorEvents);

					Object obj_tRunJob_2 = null;

					ovirt_engine_dwh.hourlytimekeepingjob_3_6.HourlyTimeKeepingJob childJob_tRunJob_2 = new ovirt_engine_dwh.hourlytimekeepingjob_3_6.HourlyTimeKeepingJob();
					// pass DataSources
					java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_2 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					if (null != talendDataSources_tRunJob_2) {
						java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_2 = new java.util.HashMap<String, javax.sql.DataSource>();
						for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_2 : talendDataSources_tRunJob_2
								.entrySet()) {
							dataSources_tRunJob_2.put(
									talendDataSourceEntry_tRunJob_2.getKey(),
									talendDataSourceEntry_tRunJob_2.getValue()
											.getRawDataSource());
						}
						childJob_tRunJob_2
								.setDataSources(dataSources_tRunJob_2);
					}

					childJob_tRunJob_2.parentContextMap = parentContextMap_tRunJob_2;

					String[][] childReturn_tRunJob_2 = childJob_tRunJob_2
							.runJob((String[]) paraList_tRunJob_2
									.toArray(new String[paraList_tRunJob_2
											.size()]));

					((java.util.Map) threadLocal.get()).put("errorCode",
							childJob_tRunJob_2.getErrorCode());

					if (childJob_tRunJob_2.getErrorCode() == null) {
						globalMap.put(
								"tRunJob_2_CHILD_RETURN_CODE",
								childJob_tRunJob_2.getStatus() != null
										&& ("failure")
												.equals(childJob_tRunJob_2
														.getStatus()) ? 1 : 0);
					} else {
						globalMap.put("tRunJob_2_CHILD_RETURN_CODE",
								childJob_tRunJob_2.getErrorCode());
					}
					if (childJob_tRunJob_2.getExceptionStackTrace() != null) {
						globalMap.put("tRunJob_2_CHILD_EXCEPTION_STACKTRACE",
								childJob_tRunJob_2.getExceptionStackTrace());
					}

					tos_count_tRunJob_2++;

					/**
					 * [tRunJob_2 main ] stop
					 */

					/**
					 * [tRunJob_2 end ] start
					 */

					currentComponent = "tRunJob_2";

					ok_Hash.put("tRunJob_2", true);
					end_Hash.put("tRunJob_2", System.currentTimeMillis());

					/**
					 * [tRunJob_2 end ] stop
					 */

					/**
					 * [tInfiniteLoop_2 end ] start
					 */

					currentComponent = "tInfiniteLoop_2";

					Thread.sleep(0);
				}

				ok_Hash.put("tInfiniteLoop_2", true);
				end_Hash.put("tInfiniteLoop_2", System.currentTimeMillis());

				/**
				 * [tInfiniteLoop_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tInfiniteLoop_2 finally ] start
				 */

				currentComponent = "tInfiniteLoop_2";

				/**
				 * [tInfiniteLoop_2 finally ] stop
				 */

				/**
				 * [tRunJob_2 finally ] start
				 */

				currentComponent = "tRunJob_2";

				/**
				 * [tRunJob_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tInfiniteLoop_2_SUBPROCESS_STATE", 1);
	}

	public void tJava_4Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_4 begin ] start
				 */

				ok_Hash.put("tJava_4", false);
				start_Hash.put("tJava_4", System.currentTimeMillis());

				currentComponent = "tJava_4";

				int tos_count_tJava_4 = 0;

				Thread.sleep(TalendDate.diffDate(
						TalendDate.addDate(
								RoutineHistoryETL.startOfDay(context.runTime),
								1, "dd"), context.runTime, "SSS"));

				/**
				 * [tJava_4 begin ] stop
				 */

				/**
				 * [tJava_4 main ] start
				 */

				currentComponent = "tJava_4";

				tos_count_tJava_4++;

				/**
				 * [tJava_4 main ] stop
				 */

				/**
				 * [tJava_4 end ] start
				 */

				currentComponent = "tJava_4";

				ok_Hash.put("tJava_4", true);
				end_Hash.put("tJava_4", System.currentTimeMillis());

				/**
				 * [tJava_4 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJava_4:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tInfiniteLoop_3Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_4 finally ] start
				 */

				currentComponent = "tJava_4";

				/**
				 * [tJava_4 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_4_SUBPROCESS_STATE", 1);
	}

	public void tInfiniteLoop_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tInfiniteLoop_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tInfiniteLoop_3 begin ] start
				 */

				int NB_ITERATE_tRunJob_3 = 0; // for statistics

				ok_Hash.put("tInfiniteLoop_3", false);
				start_Hash.put("tInfiniteLoop_3", System.currentTimeMillis());

				currentComponent = "tInfiniteLoop_3";

				int tos_count_tInfiniteLoop_3 = 0;

				int counter_tInfiniteLoop_3 = 0;
				globalMap.put("tInfiniteLoop_3_CURRENT_ITERATION",
						counter_tInfiniteLoop_3);

				while (counter_tInfiniteLoop_3 > -1) {
					counter_tInfiniteLoop_3++;
					globalMap.put("tInfiniteLoop_3_CURRENT_ITERATION",
							counter_tInfiniteLoop_3);

					/**
					 * [tInfiniteLoop_3 begin ] stop
					 */

					/**
					 * [tInfiniteLoop_3 main ] start
					 */

					currentComponent = "tInfiniteLoop_3";

					tos_count_tInfiniteLoop_3++;

					/**
					 * [tInfiniteLoop_3 main ] stop
					 */
					NB_ITERATE_tRunJob_3++;

					/**
					 * [tRunJob_3 begin ] start
					 */

					ok_Hash.put("tRunJob_3", false);
					start_Hash.put("tRunJob_3", System.currentTimeMillis());

					currentComponent = "tRunJob_3";

					int tos_count_tRunJob_3 = 0;

					/**
					 * [tRunJob_3 begin ] stop
					 */

					/**
					 * [tRunJob_3 main ] start
					 */

					currentComponent = "tRunJob_3";

					java.util.List<String> paraList_tRunJob_3 = new java.util.ArrayList<String>();

					paraList_tRunJob_3.add("--father_pid=" + pid);

					paraList_tRunJob_3.add("--root_pid=" + rootPid);

					paraList_tRunJob_3.add("--father_node=tRunJob_3");

					paraList_tRunJob_3.add("--context=Default");

					// for feature:10589

					paraList_tRunJob_3.add("--stat_port=" + portStats);

					if (resuming_logs_dir_path != null) {
						paraList_tRunJob_3.add("--resuming_logs_dir_path="
								+ resuming_logs_dir_path);
					}
					String childResumePath_tRunJob_3 = ResumeUtil
							.getChildJobCheckPointPath(resuming_checkpoint_path);
					String tRunJobName_tRunJob_3 = ResumeUtil
							.getRighttRunJob(resuming_checkpoint_path);
					if ("tRunJob_3".equals(tRunJobName_tRunJob_3)
							&& childResumePath_tRunJob_3 != null) {
						paraList_tRunJob_3
								.add("--resuming_checkpoint_path="
										+ ResumeUtil
												.getChildJobCheckPointPath(resuming_checkpoint_path));
					}
					paraList_tRunJob_3.add("--parent_part_launcher=JOB:"
							+ jobName + "/NODE:tRunJob_3");

					java.util.Map<String, Object> parentContextMap_tRunJob_3 = new java.util.HashMap<String, Object>();

					context.synchronizeContext();
					java.util.Enumeration<?> propertyNames_tRunJob_3 = context
							.propertyNames();
					while (propertyNames_tRunJob_3.hasMoreElements()) {
						String key_tRunJob_3 = (String) propertyNames_tRunJob_3
								.nextElement();
						Object value_tRunJob_3 = (Object) context
								.get(key_tRunJob_3);
						paraList_tRunJob_3.add("--context_param "
								+ key_tRunJob_3 + "=" + value_tRunJob_3);
					}

					parentContextMap_tRunJob_3.put("hoursToKeepDaily",
							context.hoursToKeepDaily);

					parentContextMap_tRunJob_3.put("hoursToKeepHourly",
							context.hoursToKeepHourly);

					parentContextMap_tRunJob_3.put("hoursToKeepSamples",
							context.hoursToKeepSamples);

					parentContextMap_tRunJob_3.put("ovirtEngineDbDriverClass",
							context.ovirtEngineDbDriverClass);

					parentContextMap_tRunJob_3.put(
							"ovirtEngineDbJdbcConnection",
							context.ovirtEngineDbJdbcConnection);

					parentContextMap_tRunJob_3.put("ovirtEngineDbPassword",
							context.ovirtEngineDbPassword);

					parentContextMap_tRunJob_3.put("ovirtEngineDbUser",
							context.ovirtEngineDbUser);

					parentContextMap_tRunJob_3.put(
							"ovirtEngineHistoryDbDriverClass",
							context.ovirtEngineHistoryDbDriverClass);

					parentContextMap_tRunJob_3.put(
							"ovirtEngineHistoryDbJdbcConnection",
							context.ovirtEngineHistoryDbJdbcConnection);

					parentContextMap_tRunJob_3.put(
							"ovirtEngineHistoryDbPassword",
							context.ovirtEngineHistoryDbPassword);

					parentContextMap_tRunJob_3.put("ovirtEngineHistoryDbUser",
							context.ovirtEngineHistoryDbUser);

					parentContextMap_tRunJob_3.put("runDeleteTime",
							context.runDeleteTime);

					parentContextMap_tRunJob_3.put("runInterleave",
							context.runInterleave);

					parentContextMap_tRunJob_3.put("runTime", context.runTime);

					parentContextMap_tRunJob_3.put("timeBetweenErrorEvents",
							context.timeBetweenErrorEvents);

					Object obj_tRunJob_3 = null;

					ovirt_engine_dwh.dailytimekeepingjob_3_6.DailyTimeKeepingJob childJob_tRunJob_3 = new ovirt_engine_dwh.dailytimekeepingjob_3_6.DailyTimeKeepingJob();
					// pass DataSources
					java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_3 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					if (null != talendDataSources_tRunJob_3) {
						java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_3 = new java.util.HashMap<String, javax.sql.DataSource>();
						for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_3 : talendDataSources_tRunJob_3
								.entrySet()) {
							dataSources_tRunJob_3.put(
									talendDataSourceEntry_tRunJob_3.getKey(),
									talendDataSourceEntry_tRunJob_3.getValue()
											.getRawDataSource());
						}
						childJob_tRunJob_3
								.setDataSources(dataSources_tRunJob_3);
					}

					childJob_tRunJob_3.parentContextMap = parentContextMap_tRunJob_3;

					String[][] childReturn_tRunJob_3 = childJob_tRunJob_3
							.runJob((String[]) paraList_tRunJob_3
									.toArray(new String[paraList_tRunJob_3
											.size()]));

					((java.util.Map) threadLocal.get()).put("errorCode",
							childJob_tRunJob_3.getErrorCode());

					if (childJob_tRunJob_3.getErrorCode() == null) {
						globalMap.put(
								"tRunJob_3_CHILD_RETURN_CODE",
								childJob_tRunJob_3.getStatus() != null
										&& ("failure")
												.equals(childJob_tRunJob_3
														.getStatus()) ? 1 : 0);
					} else {
						globalMap.put("tRunJob_3_CHILD_RETURN_CODE",
								childJob_tRunJob_3.getErrorCode());
					}
					if (childJob_tRunJob_3.getExceptionStackTrace() != null) {
						globalMap.put("tRunJob_3_CHILD_EXCEPTION_STACKTRACE",
								childJob_tRunJob_3.getExceptionStackTrace());
					}

					tos_count_tRunJob_3++;

					/**
					 * [tRunJob_3 main ] stop
					 */

					/**
					 * [tRunJob_3 end ] start
					 */

					currentComponent = "tRunJob_3";

					ok_Hash.put("tRunJob_3", true);
					end_Hash.put("tRunJob_3", System.currentTimeMillis());

					/**
					 * [tRunJob_3 end ] stop
					 */

					/**
					 * [tInfiniteLoop_3 end ] start
					 */

					currentComponent = "tInfiniteLoop_3";

					Thread.sleep(0);
				}

				ok_Hash.put("tInfiniteLoop_3", true);
				end_Hash.put("tInfiniteLoop_3", System.currentTimeMillis());

				/**
				 * [tInfiniteLoop_3 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tInfiniteLoop_3 finally ] start
				 */

				currentComponent = "tInfiniteLoop_3";

				/**
				 * [tInfiniteLoop_3 finally ] stop
				 */

				/**
				 * [tRunJob_3 finally ] start
				 */

				currentComponent = "tRunJob_3";

				/**
				 * [tRunJob_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tInfiniteLoop_3_SUBPROCESS_STATE", 1);
	}

	public void tJava_5Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_5 begin ] start
				 */

				ok_Hash.put("tJava_5", false);
				start_Hash.put("tJava_5", System.currentTimeMillis());

				currentComponent = "tJava_5";

				int tos_count_tJava_5 = 0;

				Thread.sleep(TalendDate.diffDate(TalendDate.addDate(TalendDate
						.addDate(RoutineHistoryETL.startOfDay(context.runTime),
								1, "dd"), context.runDeleteTime, "HH"),
						context.runTime, "SSS"));

				/**
				 * [tJava_5 begin ] stop
				 */

				/**
				 * [tJava_5 main ] start
				 */

				currentComponent = "tJava_5";

				tos_count_tJava_5++;

				/**
				 * [tJava_5 main ] stop
				 */

				/**
				 * [tJava_5 end ] start
				 */

				currentComponent = "tJava_5";

				ok_Hash.put("tJava_5", true);
				end_Hash.put("tJava_5", System.currentTimeMillis());

				/**
				 * [tJava_5 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJava_5:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tInfiniteLoop_6Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_5 finally ] start
				 */

				currentComponent = "tJava_5";

				/**
				 * [tJava_5 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_5_SUBPROCESS_STATE", 1);
	}

	public void tInfiniteLoop_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tInfiniteLoop_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tInfiniteLoop_6 begin ] start
				 */

				int NB_ITERATE_tRunJob_6 = 0; // for statistics

				ok_Hash.put("tInfiniteLoop_6", false);
				start_Hash.put("tInfiniteLoop_6", System.currentTimeMillis());

				currentComponent = "tInfiniteLoop_6";

				int tos_count_tInfiniteLoop_6 = 0;

				int counter_tInfiniteLoop_6 = 0;
				globalMap.put("tInfiniteLoop_6_CURRENT_ITERATION",
						counter_tInfiniteLoop_6);

				while (counter_tInfiniteLoop_6 > -1) {
					counter_tInfiniteLoop_6++;
					globalMap.put("tInfiniteLoop_6_CURRENT_ITERATION",
							counter_tInfiniteLoop_6);

					/**
					 * [tInfiniteLoop_6 begin ] stop
					 */

					/**
					 * [tInfiniteLoop_6 main ] start
					 */

					currentComponent = "tInfiniteLoop_6";

					tos_count_tInfiniteLoop_6++;

					/**
					 * [tInfiniteLoop_6 main ] stop
					 */
					NB_ITERATE_tRunJob_6++;

					/**
					 * [tRunJob_6 begin ] start
					 */

					ok_Hash.put("tRunJob_6", false);
					start_Hash.put("tRunJob_6", System.currentTimeMillis());

					currentComponent = "tRunJob_6";

					int tos_count_tRunJob_6 = 0;

					/**
					 * [tRunJob_6 begin ] stop
					 */

					/**
					 * [tRunJob_6 main ] start
					 */

					currentComponent = "tRunJob_6";

					java.util.List<String> paraList_tRunJob_6 = new java.util.ArrayList<String>();

					paraList_tRunJob_6.add("--father_pid=" + pid);

					paraList_tRunJob_6.add("--root_pid=" + rootPid);

					paraList_tRunJob_6.add("--father_node=tRunJob_6");

					paraList_tRunJob_6.add("--context=Default");

					// for feature:10589

					paraList_tRunJob_6.add("--stat_port=" + portStats);

					if (resuming_logs_dir_path != null) {
						paraList_tRunJob_6.add("--resuming_logs_dir_path="
								+ resuming_logs_dir_path);
					}
					String childResumePath_tRunJob_6 = ResumeUtil
							.getChildJobCheckPointPath(resuming_checkpoint_path);
					String tRunJobName_tRunJob_6 = ResumeUtil
							.getRighttRunJob(resuming_checkpoint_path);
					if ("tRunJob_6".equals(tRunJobName_tRunJob_6)
							&& childResumePath_tRunJob_6 != null) {
						paraList_tRunJob_6
								.add("--resuming_checkpoint_path="
										+ ResumeUtil
												.getChildJobCheckPointPath(resuming_checkpoint_path));
					}
					paraList_tRunJob_6.add("--parent_part_launcher=JOB:"
							+ jobName + "/NODE:tRunJob_6");

					java.util.Map<String, Object> parentContextMap_tRunJob_6 = new java.util.HashMap<String, Object>();

					context.synchronizeContext();
					java.util.Enumeration<?> propertyNames_tRunJob_6 = context
							.propertyNames();
					while (propertyNames_tRunJob_6.hasMoreElements()) {
						String key_tRunJob_6 = (String) propertyNames_tRunJob_6
								.nextElement();
						Object value_tRunJob_6 = (Object) context
								.get(key_tRunJob_6);
						paraList_tRunJob_6.add("--context_param "
								+ key_tRunJob_6 + "=" + value_tRunJob_6);
					}

					parentContextMap_tRunJob_6.put("hoursToKeepDaily",
							context.hoursToKeepDaily);

					parentContextMap_tRunJob_6.put("hoursToKeepHourly",
							context.hoursToKeepHourly);

					parentContextMap_tRunJob_6.put("hoursToKeepSamples",
							context.hoursToKeepSamples);

					parentContextMap_tRunJob_6.put("ovirtEngineDbDriverClass",
							context.ovirtEngineDbDriverClass);

					parentContextMap_tRunJob_6.put(
							"ovirtEngineDbJdbcConnection",
							context.ovirtEngineDbJdbcConnection);

					parentContextMap_tRunJob_6.put("ovirtEngineDbPassword",
							context.ovirtEngineDbPassword);

					parentContextMap_tRunJob_6.put("ovirtEngineDbUser",
							context.ovirtEngineDbUser);

					parentContextMap_tRunJob_6.put(
							"ovirtEngineHistoryDbDriverClass",
							context.ovirtEngineHistoryDbDriverClass);

					parentContextMap_tRunJob_6.put(
							"ovirtEngineHistoryDbJdbcConnection",
							context.ovirtEngineHistoryDbJdbcConnection);

					parentContextMap_tRunJob_6.put(
							"ovirtEngineHistoryDbPassword",
							context.ovirtEngineHistoryDbPassword);

					parentContextMap_tRunJob_6.put("ovirtEngineHistoryDbUser",
							context.ovirtEngineHistoryDbUser);

					parentContextMap_tRunJob_6.put("runDeleteTime",
							context.runDeleteTime);

					parentContextMap_tRunJob_6.put("runInterleave",
							context.runInterleave);

					parentContextMap_tRunJob_6.put("runTime", context.runTime);

					parentContextMap_tRunJob_6.put("timeBetweenErrorEvents",
							context.timeBetweenErrorEvents);

					Object obj_tRunJob_6 = null;

					ovirt_engine_dwh.deletetimekeepingjob_3_6.DeleteTimeKeepingJob childJob_tRunJob_6 = new ovirt_engine_dwh.deletetimekeepingjob_3_6.DeleteTimeKeepingJob();
					// pass DataSources
					java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_6 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
							.get(KEY_DB_DATASOURCES);
					if (null != talendDataSources_tRunJob_6) {
						java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_6 = new java.util.HashMap<String, javax.sql.DataSource>();
						for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_6 : talendDataSources_tRunJob_6
								.entrySet()) {
							dataSources_tRunJob_6.put(
									talendDataSourceEntry_tRunJob_6.getKey(),
									talendDataSourceEntry_tRunJob_6.getValue()
											.getRawDataSource());
						}
						childJob_tRunJob_6
								.setDataSources(dataSources_tRunJob_6);
					}

					childJob_tRunJob_6.parentContextMap = parentContextMap_tRunJob_6;

					String[][] childReturn_tRunJob_6 = childJob_tRunJob_6
							.runJob((String[]) paraList_tRunJob_6
									.toArray(new String[paraList_tRunJob_6
											.size()]));

					((java.util.Map) threadLocal.get()).put("errorCode",
							childJob_tRunJob_6.getErrorCode());

					if (childJob_tRunJob_6.getErrorCode() == null) {
						globalMap.put(
								"tRunJob_6_CHILD_RETURN_CODE",
								childJob_tRunJob_6.getStatus() != null
										&& ("failure")
												.equals(childJob_tRunJob_6
														.getStatus()) ? 1 : 0);
					} else {
						globalMap.put("tRunJob_6_CHILD_RETURN_CODE",
								childJob_tRunJob_6.getErrorCode());
					}
					if (childJob_tRunJob_6.getExceptionStackTrace() != null) {
						globalMap.put("tRunJob_6_CHILD_EXCEPTION_STACKTRACE",
								childJob_tRunJob_6.getExceptionStackTrace());
					}

					tos_count_tRunJob_6++;

					/**
					 * [tRunJob_6 main ] stop
					 */

					/**
					 * [tRunJob_6 end ] start
					 */

					currentComponent = "tRunJob_6";

					ok_Hash.put("tRunJob_6", true);
					end_Hash.put("tRunJob_6", System.currentTimeMillis());

					/**
					 * [tRunJob_6 end ] stop
					 */

					/**
					 * [tInfiniteLoop_6 end ] start
					 */

					currentComponent = "tInfiniteLoop_6";

					Thread.sleep(0);
				}

				ok_Hash.put("tInfiniteLoop_6", true);
				end_Hash.put("tInfiniteLoop_6", System.currentTimeMillis());

				/**
				 * [tInfiniteLoop_6 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tInfiniteLoop_6 finally ] start
				 */

				currentComponent = "tInfiniteLoop_6";

				/**
				 * [tInfiniteLoop_6 finally ] stop
				 */

				/**
				 * [tRunJob_6 finally ] start
				 */

				currentComponent = "tRunJob_6";

				/**
				 * [tRunJob_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tInfiniteLoop_6_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ParallelRun = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ParallelRun = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ParallelRun.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ParallelRun.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ParallelRun = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ParallelRun = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_ParallelRun, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ParallelRun, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ParallelRun) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */

					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}

					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private SyncInt runningThreadCount = new SyncInt();

	private class SyncInt {
		private int count = 0;

		public synchronized void add(int i) {
			count += i;
		}

		public synchronized int getCount() {
			return count;
		}
	}

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final ParallelRun ParallelRunClass = new ParallelRun();

		int exitCode = ParallelRunClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public boolean hastBufferOutputComponent() {
		boolean hastBufferOutput = false;

		return hastBufferOutput;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = ParallelRun.class.getClassLoader()
					.getResourceAsStream(
							"ovirt_engine_dwh/parallelrun_3_6/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			try {
				context.hoursToKeepDaily = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepDaily"));
			} catch (NumberFormatException e) {
				context.hoursToKeepDaily = null;
			}
			try {
				context.hoursToKeepHourly = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepHourly"));
			} catch (NumberFormatException e) {
				context.hoursToKeepHourly = null;
			}
			try {
				context.hoursToKeepSamples = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepSamples"));
			} catch (NumberFormatException e) {
				context.hoursToKeepSamples = null;
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			String pwd_ovirtEngineDbPassword_value = context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbPassword = null;
			if (pwd_ovirtEngineDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineDbPassword")) {// no
																			// need
																			// to
																			// decrypt
																			// if
																			// it
																			// come
																			// from
																			// program
																			// argument
																			// or
																			// parent
																			// job
																			// runtime
					context.ovirtEngineDbPassword = pwd_ovirtEngineDbPassword_value;
				} else if (!pwd_ovirtEngineDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineDbPassword_value);
						context.put("ovirtEngineDbPassword",
								context.ovirtEngineDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			String pwd_ovirtEngineHistoryDbPassword_value = context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbPassword = null;
			if (pwd_ovirtEngineHistoryDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineHistoryDbPassword")) {// no
																				// need
																				// to
																				// decrypt
																				// if
																				// it
																				// come
																				// from
																				// program
																				// argument
																				// or
																				// parent
																				// job
																				// runtime
					context.ovirtEngineHistoryDbPassword = pwd_ovirtEngineHistoryDbPassword_value;
				} else if (!pwd_ovirtEngineHistoryDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineHistoryDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineHistoryDbPassword_value);
						context.put("ovirtEngineHistoryDbPassword",
								context.ovirtEngineHistoryDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				context.runDeleteTime = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runDeleteTime"));
			} catch (NumberFormatException e) {
				context.runDeleteTime = null;
			}
			try {
				context.runInterleave = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runInterleave"));
			} catch (NumberFormatException e) {
				context.runInterleave = null;
			}
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
			try {
				context.timeBetweenErrorEvents = routines.system.ParserUtils
						.parseTo_Long(context
								.getProperty("timeBetweenErrorEvents"));
			} catch (NumberFormatException e) {
				context.timeBetweenErrorEvents = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("hoursToKeepDaily")) {
				context.hoursToKeepDaily = (Integer) parentContextMap
						.get("hoursToKeepDaily");
			}
			if (parentContextMap.containsKey("hoursToKeepHourly")) {
				context.hoursToKeepHourly = (Integer) parentContextMap
						.get("hoursToKeepHourly");
			}
			if (parentContextMap.containsKey("hoursToKeepSamples")) {
				context.hoursToKeepSamples = (Integer) parentContextMap
						.get("hoursToKeepSamples");
			}
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runDeleteTime")) {
				context.runDeleteTime = (Integer) parentContextMap
						.get("runDeleteTime");
			}
			if (parentContextMap.containsKey("runInterleave")) {
				context.runInterleave = (Integer) parentContextMap
						.get("runInterleave");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
			if (parentContextMap.containsKey("timeBetweenErrorEvents")) {
				context.timeBetweenErrorEvents = (Long) parentContextMap
						.get("timeBetweenErrorEvents");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		List<String> parametersToEncrypt = new java.util.ArrayList<String>();
		parametersToEncrypt.add("ovirtEngineDbPassword");
		parametersToEncrypt.add("ovirtEngineHistoryDbPassword");
		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "",
				resumeUtil.convertToJsonText(context, parametersToEncrypt));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		try {
			errorCode = null;
			tPrejob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPrejob_1) {
			globalMap.put("tPrejob_1_SUBPROCESS_STATE", -1);

			e_tPrejob_1.printStackTrace();

		}

		this.globalResumeTicket = false;// to run others jobs

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJava_2Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJava_2) {
					globalMap.put("tJava_2_SUBPROCESS_STATE", -1);

					e_tJava_2.printStackTrace();

				} catch (Error e_tJava_2) {
					globalMap.put("tJava_2_SUBPROCESS_STATE", -1);

					e_tJava_2.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJava_3Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJava_3) {
					globalMap.put("tJava_3_SUBPROCESS_STATE", -1);

					e_tJava_3.printStackTrace();

				} catch (Error e_tJava_3) {
					globalMap.put("tJava_3_SUBPROCESS_STATE", -1);

					e_tJava_3.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJava_4Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJava_4) {
					globalMap.put("tJava_4_SUBPROCESS_STATE", -1);

					e_tJava_4.printStackTrace();

				} catch (Error e_tJava_4) {
					globalMap.put("tJava_4_SUBPROCESS_STATE", -1);

					e_tJava_4.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJava_5Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJava_5) {
					globalMap.put("tJava_5_SUBPROCESS_STATE", -1);

					e_tJava_5.printStackTrace();

				} catch (Error e_tJava_5) {
					globalMap.put("tJava_5_SUBPROCESS_STATE", -1);

					e_tJava_5.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		while (runningThreadCount.getCount() > 0) {
			try {
				Thread.sleep(10);
			} catch (java.lang.Exception e) {
				e.printStackTrace();
			}
		}

		this.globalResumeTicket = true;// to run tPostJob

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out.println((endUsedMemory - startUsedMemory)
					+ " bytes memory increase when running : ParallelRun");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	// only for OSGi env
	public void destroy() {
		closeSqlDbConnections();
	}

	private void closeSqlDbConnections() {
		try {
			Object obj_conn;
			obj_conn = globalMap.remove("conn_tJDBCConnection_1");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_2");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_3");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_4");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_5");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_6");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
		} catch (java.lang.Exception e) {
		}
	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		connections.put("conn_tJDBCConnection_1",
				globalMap.get("conn_tJDBCConnection_1"));
		connections.put("conn_tJDBCConnection_2",
				globalMap.get("conn_tJDBCConnection_2"));
		connections.put("conn_tJDBCConnection_3",
				globalMap.get("conn_tJDBCConnection_3"));
		connections.put("conn_tJDBCConnection_4",
				globalMap.get("conn_tJDBCConnection_4"));
		connections.put("conn_tJDBCConnection_5",
				globalMap.get("conn_tJDBCConnection_5"));
		connections.put("conn_tJDBCConnection_6",
				globalMap.get("conn_tJDBCConnection_6"));
		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\\\", "\\" }, { "\\n", "\n" },
			{ "\\'", "\'" }, { "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" },
			{ "\\t", "\t" } };

	private String replaceEscapeChars(String keyValue) {

		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}

		StringBuilder result = new StringBuilder();
		int currIndex = 0;
		while (currIndex < keyValue.length()) {
			int index = -1;
			// judege if the left string includes escape chars
			for (String[] strArray : escapeChars) {
				index = keyValue.indexOf(strArray[0], currIndex);
				if (index >= 0) {

					result.append(keyValue.substring(currIndex,
							index + strArray[0].length()).replace(strArray[0],
							strArray[1]));
					currIndex = index + strArray[0].length();
					break;
				}
			}
			// if the left string doesn't include escape chars, append the left
			// into the result
			if (index < 0) {
				result.append(keyValue.substring(currIndex));
				currIndex = currIndex + keyValue.length();
			}
		}

		return result.toString();
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 146786 characters generated by Talend Open Studio for Data Integration on the
 * June 1, 2015 2:26:11 PM IDT
 ************************************************************************************************/
