%if 0%{?fedora}
%global java_devel java-devel >= 1.7.0
%global ovirt_install_systemd 1
%global ovirt_install_systemv 0
%if %{fedora} >= 20
%global ovirt_provides_jboss 1
%global jboss ovirt-engine-jboss-as >= 7.1.1
%else
%global ovirt_provides_jboss 0
%global jboss jboss-as >= 7.1.1-9.3
%endif
%endif

%if 0%{?rhel}
%if 0%{?rhel} >= 7
%global java_devel java-devel >= 1.7.0
%global ovirt_install_systemd 1
%global ovirt_install_systemv 0
%else
%global java_devel java7-devel
%global ovirt_install_systemd 0
%global ovirt_install_systemv 1
%endif
%global jboss ovirt-engine-jboss-as >= 7.1.1
%global ovirt_provides_jboss 1
%endif

%global product_name Reports package for oVirt Virtualization Management
%global product_description oVirt virtualization reports

%global engine_name ovirt-engine
%global reports_name ovirt-engine-reports
%global reports_jasper_suffix %{nil}
%global reports_java %{_javadir}/%{reports_name}
%global engine_group ovirt
%global engine_user ovirt
%global engine_gid 108
%global engine_uid 108

# Macro to create a user:
#
# %1 user name
# %2 user id
# %3 primary group name
# %4 primary group id
# %5 description
# %6 home directory
#
%global _ovirt_create_user() \
getent group %3 >/dev/null || groupadd -r -g %4 %3; \
getent passwd %1 >/dev/null || useradd -r -u %2 -g %3 -c %5 -s /sbin/nologin -d %6 %1

%global ovirt_create_user_engine \
%_ovirt_create_user %{engine_user} %{engine_uid} %{engine_group} %{engine_gid} "%{ovirt_user_description}" %{engine_state}

%global make_common_opts \\\
	-j1 \\\
	BUILD_VALIDATION=0 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE=%{release} \\\
	OVIRT_REPORTS_NAME=%{reports_name} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	ENGINE_SYSCONF_DIR=%{_sysconfdir} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	PYTHON=%{__python} \\\
	PYTHON_DIR=%{python_sitelib} \\\
	JAVA_DIR=%{_javadir} \\\
	PKG_JAVA_DIR=%{reports_java} \\\
	PKG_LOG_DIR=%{_localstatedir}/log/%{reports_name} \\\
	PKG_STATE_DIR=%{_localstatedir}/lib/%{reports_name} \\\
	%{?BUILD_FLAGS:BUILD_FLAGS="%{BUILD_FLAGS}"} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name:		ovirt-engine-reports
Version:	3.6.3
Release:	1%{?release_suffix}%{?dist}
License:	AGPLv3
Summary:	%{product_name}
Group:		Virtualization/Management
URL:		http://www.ovirt.org
BuildArch:	noarch
Source0:	http://resources.ovirt.org/pub/ovirt-master-snapshot/src/ovirt-engine-reports/ovirt-engine-reports-3.6.3.tar.gz

BuildRequires:	jasperreports-server%{reports_jasper_suffix} >= 6.0.1
BuildRequires:	%{java_devel}
BuildRequires:	jpackage-utils
BuildRequires:	make
BuildRequires:	ant

%if %{ovirt_install_systemd}
BuildRequires:	systemd
%endif

Requires:	%{jboss}
Requires:	%{name}-setup >= %{version}-%{release}
Requires:	jasperreports-server%{reports_jasper_suffix} < 6.1.0
Requires:	jasperreports-server%{reports_jasper_suffix} >= 6.0.1
Requires:	java-1.7.0-openjdk >= 1:1.7.0.9-2.3.3.2
Requires:	jpackage-utils
Requires:	logrotate
Requires:	m2crypto
Requires:	patch
Requires:	postgresql-server >= 8.4.7
Requires:	python-cheetah
Requires:	mod_ssl
Requires:	httpd

# On CentOS requires jpackage repo to be enabled
Requires:	postgresql-jdbc

# bug#862355
Requires:	liberation-mono-fonts

%if %{ovirt_install_systemd}
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd
%endif

%description
The %{product_description} package provides a suite of
pre-configured reports and dashboards that enable you to
monitor the system. The reports module is based on
JasperReports and JasperServer, and can also be used to create
ad-hoc reports.

%package setup
Summary:	%{product_name} setup
Group:		Virtualization/Management
Requires:	cracklib-python
Requires:	libxml2-python
Requires:	%{engine_name}-setup-plugin-ovirt-engine-common
Requires:	python
Requires:	%{name} >= 3.4.0
Requires:	java-1.7.0-openjdk >= 1:1.7.0.9-2.3.3.2
BuildRequires:	python

%description setup
%{product_description} setup package.

%prep
%setup -c -T -a 0 -n ovirt-reports

%build
make %{make_common_opts}

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install DESTDIR="%{buildroot}"

# Compile python files
%{__python} -m compileall -f -q -d / "%{buildroot}"
%{__python} -O -m compileall -f -q -d / "%{buildroot}"

#
# /var creation
#
install -dm 755 "%{buildroot}/%{_localstatedir}/lib/%{reports_name}"
install -dm 755 "%{buildroot}/%{_localstatedir}/log/%{reports_name}"
install -dm 755 "%{buildroot}/%{_localstatedir}/log/%{reports_name}/ovirt-engine-reports-tool"

#
# Packaging branding
#
%if "%{name}" != "%{reports_name}"
ln -s "%{reports_name}" "%{buildroot}%{_javadir}/%{name}"
%endif

#
# Register services
#
%if %{ovirt_install_systemd}
install -dm 755 "%{buildroot}%{_unitdir}"
for service in ovirt-engine-reportsd; do
	cp "%{buildroot}%{_datadir}/%{reports_name}/services/${service}/${service}.systemd" "%{buildroot}%{_unitdir}/${service}.service"
done
%endif

%if %{ovirt_install_systemv}
install -dm 755 "%{buildroot}%{_initddir}"
for service in ovirt-engine-reportsd; do
	cp "%{buildroot}%{_datadir}/%{reports_name}/services/${service}/${service}.sysv" "%{buildroot}%{_initddir}/${service}"
done
%endif

#
# Package customization
#
install -d "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d"
%if %{ovirt_provides_jboss}
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging-reports-jboss.conf" << __EOF__
[environment:default]
OVESETUP_REPORTS_CONFIG/jbossHome=str:/usr/share/ovirt-engine-jboss-as
__EOF__
%endif

%pre
%ovirt_create_user_engine

%post
%if %{ovirt_install_systemd}
%systemd_post ovirt-engine-reportsd.service
%endif
%if %{ovirt_install_systemv}
chkconfig --add ovirt-engine-reportsd
%endif

%preun
%if %{ovirt_install_systemd}
%systemd_preun ovirt-engine-reportsd.service
%endif

%if %{ovirt_install_systemv}
if [ $1 -eq 0 ]; then
	service ovirt-engine-reportsd stop > /dev/null 2>&1 || true
	chkconfig --del ovirt-engine-reportsd
fi
%endif

%postun
%if %{ovirt_install_systemd}
%systemd_postun ovirt-engine-reportsd.service
%endif
if [ "$1" -eq 0 ]; then
	rm -rf /var/lib/ovirt-engine-reports/%{reports_name}.war
fi

%files
%config(noreplace) %{_sysconfdir}/logrotate.d/ovirt-engine-reports
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/lib/%{reports_name}
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/log/%{reports_name}
%{_localstatedir}/lib/ovirt-engine-reports/backups/

%{reports_java}
%{_datadir}/%{reports_name}
%if "%{name}" != "%{reports_name}"
%{_javadir}/%{name}
%endif

%if %{ovirt_install_systemd}
%{_unitdir}/ovirt-engine-reportsd.service
%endif
%if %{ovirt_install_systemv}
%{_initddir}/ovirt-engine-reportsd
%endif

%files setup
%config %{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging-reports-jboss.conf
%{_datadir}/ovirt-engine/setup/ovirt_engine_setup/reports/
%{_datadir}/ovirt-engine/setup/plugins/*/ovirt-engine-reports/
%{_datadir}/ovirt-engine/firewalld/reports/
%{_datadir}/ovirt-engine/setup/bin/ovirt-engine-reports-tool.*
%{_bindir}/ovirt-engine-reports-tool
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/log/%{reports_name}/ovirt-engine-reports-tool

%changelog
* Wed Jan 27 2016 Shirly Radco <sradco@redhat.com> - 3.6.3
Fixed issues:
- Bug 1300240 - fixed typo in capacity planning report br48
- Bug 1257797 - fixed bug in br48 capacity planning

* Tue Jan 19 2016 Shirly Radco <sradco@redhat.com> - 3.6.2
Fixed issues:
- Bug 1299431 - rename: Do not fail if reports is not set up

* Tue Jan 12 2016 Shirly Radco <sradco@redhat.com> - 3.6.2
Fixed issues:
- Bug 1259363 - fixed visual flaws in br49 reports

* Tue Jan 5 2016 Shirly Radco <sradco@redhat.com> - 3.6.2
Fixed issues:
- Fixed issues with network interface usage in br2b and br2c
  and with number of active vms in br2a.

* Mon Dec 21 2015 Shirly Radco <sradco@redhat.com> - 3.6.2
Fixed issues:
- Bug 1286419 - recreate dashboards with new framwork
- Bug 1259356 - fix bug in heatmap report(br49)

* Mon Dec 7 2015 Shirly Radco <sradco@redhat.com> - 3.6.1
Fixed issues:
- Bug 1211052 - fix problem with chinese translations

* Tue Nov 24 2015 Shirly Radco <sradco@redhat.com> - 3.6.1
Fixed issues:
- Bug 1258789 - reports-tool: Absolute path on export/import

* Sun Oct 11 2015 Yaniv Dary <ydary@redhat.com> - 3.6.0
Refixed issues:
- Bug 1209999 - fixed issues with network interfaces chart
  in br2a. Also fixed disk/nics charts in br10a.

* Wed Sep 02 2015 Yaniv Dary <ydary@redhat.com> - 3.6.0
Fixed issues:
- Bug 1209999 - fixed issues with network interfaces chart
  in br2a. Also fixed disk/nics charts in br10a.

* Tue Aug 11 2015 Yaniv Dary <ydary@redhat.com> - 3.6.0
Fixed issues:
- Bug 1187502 - In Active Entities by OS (BR18A) report
  hours are not shown in the Date for Daily period
- Bug 1209022 - Handling new Wildfly application server
  in engine so it will not affect reports
- Bug 1209556 - Fix UI for the new jasperserver 6.0.1
  package
- Bug 1225045 - Heatmap Report BR49 title is incorrect -
  BR49 should be in capital letters - not "Heatmap Report
  (br49)"
- Bug 1234821 - Error after adding Virtual Machines to
  Statistics Daily domain in ad-hoc reports
- Bug 1231509 - Update reports 3.6 localizations
- Bug 1229725 - Update reports 3.6 Topics

* Sun Sep 07 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
-  provide reports.xml to engine over http (#1116851)

* Tue Aug 26 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- updated br7b legend (#1031757)

* Sun Aug 10 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- add reports to versionlock

* Mon Aug 04 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- remove war file for new db (#1072357)
- use own connection (#1080998)

* Mon Jul 28 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- removed default theme that caused input control to become unusable (#1112641)

* Tue Jul 22 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- fixed centos install with ovirt provided jboss

* Sun Jul 13 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- disable Spring integration in JRS pro (#1115569)
- deleted references to missing resources (#1114652)
- filter engine db password
- allow reports on separate host (#1080998)
- updated br45 report query (#1112612)
- fix logical loop in deps
- remove war file for new db (#1072357)
- fix bug in br44- redundant bracket
- added to bar tooltip series value (#1016353)
- reorg the per component directory
- split of engine-setup-plugin

* Thu Jun 5 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- require newer jasperreports (#1086003)
- Ask only during setup (#1080431)
- Removing build-conf files on failure (#1091700 / 1084749)
- added leading question mark to dist tag (#1091700)
- moved to using only ce edition dashboards in webadmin (#1096841)
- Fixed date range in reports queries (#1085820)
- Move JASPER_HOME init to common (#1098149)
- fixed system dashboard error on a clean system (#1073340)
- added a condition vms / hosts are active (#1085874)
- updated br18 title and subtitles (#1083636)
- Fixed empty legend in br18 (#1045103)
- removed unused import causing build failure

* Tue Apr 1 2014 Yaniv Dary <ydary@redhat.com> - 3.4.1
Fixed issues:
- Added strandard logrotate config file for JRS log.
- set legacy reports war from env (#1077775)

* Mon Mar 24 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
Fixed issues:
- 'Install' is now 'Configure' in DWH/Reports questions (#1064876)
- fix typo in manual instructions (#1067548)

* Tue Mar 11 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
oVirt 3.4.0 GA release.

Fixed issues:
1017183 - Wrong reference in error message
1031612 - BR18 - the numbers of OSs are incorrect

* Mon Feb 17 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
- Moved war customization to patches instead of overwrites
- Moved to otopi setup.
- Admin user name is now 'admin' in clean installations.
- A new folder called 'Saved Reports' is now saved between upgrades.

* Sun Nov 4 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
- Update
* Wed Feb 15 2012 Yaniv Dary <ydary@redhat.com> - 3.0.2
- Initial Commit
