Name:           ovirt-engine-sdk-python
Version:        3.6.5.0
Release:        1.el6
Summary:        oVirt Engine Software Development Kit (Python)
Group:          Development/Libraries
License:        ASL 2.0
URL:            http://ovirt.org
Source0:        http://ovirt.org/releases/stable/src/ovirt-engine-sdk-python-%{version}.tar.gz

BuildRequires: python2-devel
BuildRequires: python-setuptools
BuildArch: noarch

Requires: python
Requires: python-lxml
Requires: python-pycurl >= 7.19.0

Provides:  ovirt-engine-sdk = %{version}-%{release}
Obsoletes: ovirt-engine-sdk < 3.3.0.6

%description
This package contains The oVirt-Engine Software Development Kit.
With this package, custom software can be built for oVirt-Engine.

%prep
%setup -q -n %{name}

# Remove the shebang from the params.py file, as this file isn't intended as an
# executable script:
sed -i 1d src/ovirtsdk/xml/params.py

%build
%{__python} setup.py build

%install
%{__python} setup.py install -O1 --skip-build --root %{buildroot}

%files
%{python_sitelib}/ovirtsdk
%{python_sitelib}/ovirt_engine_sdk_python-*-info
%doc AUTHORS.md
%doc LICENSE.txt
%doc README.md

%changelog
* Wed Mar 30 2016 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.5.0-1
- Fix RSDL for updating cluster policy #1315657.
- Add support for URL parameters in actions #1311495.
- Add support to stop Gluster services #1303539.

* Thu Feb 11 2016 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.3.0-1
- Fix RSDL for adding cluster #1279159.
- Explicitly select version 3 of the API.

* Tue Jan 12 2016 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.2.1-1
- Add disk format and allocation policy to import VM #1296047.

* Tue Dec 22 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.2.0-1
- Fix RSDL metadata for provisioned_size #1290012.
- Document the use of All-Content in clusters #1287688.
- VM pools can use use_latest_template_version #1284596.

* Wed Nov 25 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.1.0-1
- Add support for matrix parameters to "add" methods #1282770.
- Add support for SR-IOV #1231507.

* Wed Oct 14 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.0.3-1
- Add support for VM pool type #1244841.

* Wed Sep 16 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.0.2-1
- Add support for user SSH public keys.

* Wed Sep 9 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.0.1-1
- Don't use deprecated DefaultHttpClient #1255078.
- Get provider certificates from user instead of from backend #1255862.
- Improvements of the host networking API #1136329.
- Report host network QoS also in host NIC and network #1249654.

* Fri Aug 21 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.6.0.0-1
- Added support for engine version 3.6.
- Add support for Kerberos authentication #1145234.
- Avoid clashes with the "export" method used by generateDS.py #1167851.

* Wed Jul 1 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.4.0-1
- The "isattached" action should return an action object #1234937.

* Wed Mar 18 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.2.1-1
- Add principal and namespace parameters to users and groups #1188176.

* Thu Feb 19 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.2.0-1
- Added All-Content support to hosts #1194185.
- Added isattached action to storage domain #1179246.

* Fri Jan 16 2015 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.1.0-1
- Added support for the operations to move, copy and export disks using
  the top level disks collection #1169376.
- Replaced storage_manager with spm #1146457.
- Added support for reconfigure firewall (override_iptables) to the host
  installation action #1179613.
- Added support for importing block storage domains #1181681.
- Fixed support for listing unregistered VMs #1148715.
- Added support for setting memory ballooning #1149188.
- Added support for specifying cluster during migration #1150191.
- Added snapshot id to documentation of preview action #1150071.
- Added custom_properties to templates #1166632.
- Added logical_name to disks #1063597.

* Tue Nov 11 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.8-1
- Apply filter by name/alias after get #1155678.

* Wed Sep 10 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.7-1
- Added support for watchdog action and model #1129840.

* Wed Sep 3 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.6-1
- Added support for network QoS.
- Added support to enable/disable sound card to VM, pool and template.

* Wed Aug 27 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.5-1
- Added support for QoS, including CPU and disk profiles.
- Added support for iSCSI bonds.
- Disconnect at constructor only if proxy found #996021.

* Tue Aug 12 2014 Ravi Nori<rnori@redhat.com> - 3.5.0.4-1
- Revert patch 0525e9d #1122546.
- Update API fails in SDK & CLI #1122546.

* Fri Jul 18 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.3-1
- Fix naming conflict #1120502.
- Fix parameters of add DataCenter #1104085.
- Fix update VM optional parameters #1082594.

* Wed Jul 9 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.2-1
- Calculate singulars correctly #1114655.

* Wed Jul 9 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.1-1
- Added NUMA support.
- Added actions to copy and move disks #1097681.
- Added file_transfer_enabled and copy_paste_enabled elements to Display.
- Added protocol element to Host.
- Added support for Gluster volume profiling.
- Added support for instance types.
- Added support for quota.id parameter for disks.
- Added support for random number generator device.
- Added support for scheduling policies.
- Added support storage domains disks sub-collection.
- Added support to register VMs and templates.
- Ignore errors when cleaning old connection #1116009.
- Replace decorators before marshal #1024696.
- Support X-Ovirt-Expect header #1093784.

* Thu May 22 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.5.0.0-1
- Update to version 2.12a of generateDS.py #1091688.
- Regenerate for version 3.5 of the engine.
- Added action to undelete events.
- Added base_interface to host_nic.
- Added boot_menu to VM and template.
- Added custom properties to host_nic.
- Added disksnapshots sub-collection to storagedomains.
- Added domain_entry_id to users and groups.
- Added sessions sub-collection to vms.
- Added support for Gluster volume statistics.
- Added support for VM and template custom serial numbers.
- Added support for bookmarks.
- Added support for deleting VM disk snapshots.
- Added support for reporting VM SELinux configuration.
- Added support for reporting VM kdump configuration.
- Added support for reporting architecture capabilities.
- Added tags sub-collection to templates.

* Wed May 7 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.1.1-1
- Added maintenance operation to VM.
- Added hosted_engine element to Host.
- Added labels to Network.
- Added labels to HostNIC.

* Wed Apr 23 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.1.0-1
- Added actions to preview, commit and undo snapshots.
- Added support for affinity groups.
- Added support to import a VM as template.
- Removed external_id from users and groups.
- Renamed cloud_init.hostname to cloud_init.host.address.

* Wed Apr 16 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.0.7-1
- Add support for filtering kwargs based on attributes.
- Add check of SSL server name.
- No new lines in basic auth token #1085837.

* Fri Feb 28 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.0.6-1
- Removed ip.mtu parameter from host NIC update operation #1049611.

* Thu Feb 27 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.0.5-1
- Added template versions support.

* Tue Feb 18 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.0.4-1
- Added all_content parameter to relevant methods.
- Added disks collection to Snapshot.
- Added external_id property to User and Group #1059894.
- Added ha_reservation property to Cluster #1059892.
- Added ksm.enabled property to Cluster #1059892.
- Added local property to DataCenter.
- Added migration_downtime property to VM and Template.
- Added network label support.
- Added power_management.automatic_pm_enabled property to Host.
- Added reboot method to VM.
- Added sso.methods property to VM and Template #1059893.
- Removed storage_type property from DataCenter.
- Use /api if the URL doesn't have a path #1066036.
- Remove trailing slashes from URL prefix #1063746.

* Tue Jan 28 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.0.3-1
- Use relative paths #1038952.

* Thu Jan 9 2014 Juan Hernandez <juan.hernandez@redhat.com> - 3.4.0.2-1
- Add "UsageMessage" class to represent detailed error messages
  returned by the engine #867794.
- Document "async" and "grace_period.exire" parameters of relevant
  actions #1047654.
- Add "stop_time" attribute to the VM class #1042854.

* Wed  Dec 25 2013 Michael Pasternak <mpastern@redhat.com> - 3.4.0.1-1
- to host.install() added ssh related details
- to template added virtio_scsi.enabled
- to vm added virtio_scsi.enabled
- to File class added 'content' field
- Payload class now reuses Files instead of own List of <PayloadFile> objects
- added ability to attach a disk snapshot to the virtual machine
- to vms.add() added [action.vm.initialization.cloud-init]
- to NIC added OnBoot/BootProtocol properties
- to VersionCaps added a list of supported payload-encodings
- to Step added externalType
- to NIC added vnicProfile and bootProtocol
- to CPU added architecture 
- to VnicProfilePermission added delete() method
- to Disk added readOnly
- to VMs.add() added [vm.cpu.architecture], [action.vm.initialization.cloud_init.*] arguments
- to Templates.add() added [template.cpu.architecture], [action.template.initialization.cloud_init.*] arguments
- to UserRoles.add() added permit.id|name arguments
- at VMSnapshot removed preview/undo/commit methods
- to DataCenterClusterGlusterVolumeGlusterBricks added activate/stopmigrate/migrate actions
- to NetworkVnicProfile added Permissions sub-collection
- to Cluster added [cluster.cpu.architecture]
- to DataCenter added Networks sub-collection
- to ClusterGlusterVolumeGlusterBricks added activate method
- to ClusterGlusterVolume added stoprebalance method
- to entry-point API added Permissions collection (for managing system-permissions)
- to host.install() added ssh related arguments
- to template added virtio_scsi.enabled
- to vm added virtio_scsi.enabled
- added ability to attach a disk snapshot to the virtual machine
- to File class added 'content' field
- Payload class now reuses Files instead of own PayloadFile collection
- to Cluster added [cluster.display.proxy]
- to VmPool added [vmpool.display.proxy]
- sdk ignores url attribute and hardcode /api #1038952
- support automatic auth session invalidation #1018559

* Wed  Oct 9 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.7-1
 - added fqdn property to GuestInfo
 - to DataCenterStorageDomainDisk added export() action
 - to StorageDomainDisk added export() action
 - to TemplateDisk added export() action
 - to VMDisk added export() action
 - to Disk added export() action
 - refine host add()/update() documentation
 - VCpuPin parameter rename

* Tue  Sep 3 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.6-1
 - added StorageDomainStorageConnection.delete(async) signature
 - added StorageDomainStorageConnections.add(storageconnection, expect, correlationId) signature
 - implement support for with-resources statement
 - in Cluster added glusterhooks (ClusterGlusterHooks) sub-collection
 - in DataCenterCluster added glusterhooks (DataCenterClusterGlusterhooks) sub-collection
 - in StorageDomain added images (StorageDomainImages) sub-collection

* Wed  Aug 14 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.5-1
 - implicitly disconnect and perform cleanup
 - encapsulate context removal

* Tue Aug  13 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.4-1
- added VnicProfiles root-collection
- to network added VnicProfiles sub-collection
- to storagedomain added StorageConnections sub-collection
- to VnicProfile added Permission sub-collection
- to network.add()/.updated added [network.profile_required]
- to NICs.add() added new overload with [nic.vnic_profile.id]
- to NIC.update() added new overload with [nic.vnic_profile.id]
- to VMSnapshots.list()/.get() added [String allContent] parameter
- to VMs.add() added new overload based on [vm.initialization.configuration.type|data]
- added root collection StorageConnections
- added [host.override_iptables]
- added [template.cpu_shares]
- added [template.display.single_qxl_pci]
- added [vm.display.single_qxl_pci]
- added [vm.cpu_shares]
- to template added:
 * [@param template.console.enabled: boolean]
- to vm added:
 * [@param vm.console.enabled: boolean]
- to Cluster added:
 * [@param cluster.comment: string]
 * [@param cluster.ballooning_enabled: boolean]
 * [@param cluster.tunnel_migration: boolean]
- to Host added:
 * [@param host.comment: string]
 * [@param host.ssh.port: int]
 * [@param host.ssh.fingerprint: string]
 * [@param host.ssh.authentication_type: string]
 * [@param host.ssh.password: string]
 * forceselectspm() action
- to Network added:
 * [@param host.ssh.fingerprint: string]
 * [@param host.ssh.authentication_type: string]
 * [@param host.ssh.password: string]
 * forceselectspm() action
- to Network added:
 * [@param network.comment: string]
- to StorageDomain
 * [@param storagedomain.comment: string]
- to Template added:
 * [@param template.comment: string]
 * [@param template.permissions.clone: boolean]
- to VM added:
 * [@param vm.comment: string]
 * [@param vm.permissions.clone: boolean]

* Tue Jul  16 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.3-1
- rename package to ovirt-engine-sdk-python
- added "watchdog" feature #947977
- added "external tasks" feature #872719
- snapshot can persist/restore memory state now #960931
- sdk expose datetime elements as strings while schema defines them as xs:dateTime #960747
- removed DataCenterQuota.delete() (not supported in this version)
- removed DataCenterQuota.add() (not supported in this version)
- to cluster.add()/update() added [trusted_service: boolean] property
- to datacenter added new field [comment]
- to disk added [sgio] field to enable|disable filtering for the ScsiGenericIo
- to VmPools.add() added new property [@param vmpool.max_user_vms: int]
- to NIC added new property [custom_properties]
- to cluster.update() added new doc [@param cluster.data_center.id: string]
- to host.fence() added parameter action.fence_type
- to StorageDomain.delete() added doc host.id|name
- to StorageDomains.add() added doc [@param storagedomain.storage_format: string]
- to VM added new sub-collection VMApplications

* Wed May  1 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.2-1
 - in ClusterGlusterVolumeBricks fixed add() parameters
 - to StorageDomainVM.delete() added async parameter
 - fixed parent tag parameter in the tags.add()/.update() methods
 - nic.network is no longer mandatory parameter for vnic creation
 - Implement Session-TTL header support #928313
 - refactor invocation flow #949189, #949187
 - user should not see admin permissions the DC #924357

* Tue Apr  2 2013 Michael Pasternak <mpastern@redhat.com> - 3.3.0.1-1
 - added new collection ClusterGlusterVolumeBrickStatistics
 - added NetUp 'cloned disk' importing capabilities
 - to ClusterGlusterVolumeBricks.list() added new argument "all_content"
 - to ClusterGlusterVolumeBricks.get() added new argument "all_content"
 - to host install method added new parameter "image"
 - to host add method added new parameter "display.address"
 - to vm add method added new parameter "vm.cpu.mode"
 - to vm add method added new overload for creating vm from snapshot
 - to cluster added tunnel_migration
 - to display added keyboard_layout
 - to display added smartcard_enabled
 - to DataCenter added Clusters sub-collection
 - to StorageDomain added Disks sub-collection
 - to Disks.list() added 'unregistered' argument
 - to Host added display.address
 - to Snapshot added commit/preview/undo actions
 - to vms.add() added overload for creating vm from snapshot
 - to hosts.add() added [@param host.display.address: string]
 - to vm.ticket() added [@param action.ticket.value: string]
 - return error if amount of fetched objects in X.get() is > 1 #890327
 - session based authentication for /localhost is broken #916285
 - explicitly ask for reply in xml
 - Add constructor parameter validate_cert_chain=True #915225
 - defend against malformed server reply

* Sun Jan  13 2013 Michael Pasternak <mpastern@redhat.com> - 3.2.0.8-1
 - fix date in ovirt-engine-sdk.spec.in

* Sun Jan  13 2013 Michael Pasternak <mpastern@redhat.com> - 3.2.0.7-1
 - events can be added now (user defined events)
 - events can be removed now
 - vm can be removed now, but it's disk/s kept (added disks.detach_only property to VMDisks)
 - to host add/update added power_management.agents parameter
 - host can be added now by using cluster.name (not only id)
 - to disk added permissions sub-collection
 - to NIC added "linked" property that can be changed to reach desired link state
 - to NIC added "plugged" property that can be changed to reach desired NIC state
 - to VM added ReportedDevices sub-collection (holds data reported by the guest agent)
 - to VMNIC added ReportedDevices sub-collection (holds data reported by the guest agent)
 - to PowerManagement added Agents collection
 - to VMDisk added move() action
 - to cluster added threads_as_cores property
 - to CpuTopology added "threads" property indicating amount of available threads
 - to Host added "libvirt_version" property
 - to Host added "hardware_information" property

* Thu Dec  27 2012 Michael Pasternak <mpastern@redhat.com> - 3.2.0.6-1
- to host added hooks sub-collection
- added force flag the host.delete()
- added host.power_management.pm_proxy collection
- added permissions sub-collection to network
- added search capabilities to api.networks collection
- added deletion protection to the template/vm via .delete_protected
- add print of the whole response body in debug mode #887808

* Wed Nov  21 2012 Michael Pasternak <mpastern@redhat.com> - 3.2.0.5-1
- httpsconnection.source_address is not supported on python26 #877897

* Sun Nov  18 2012 Michael Pasternak <mpastern@redhat.com> - 3.2.0.4-1
- cannot create simultaneous connections to multiple servers #853947
- to StorageDomainVM.import() added action.exclusive parameter
- to StorageDomainTemplate.import() added action.exclusive parameter
- added /current argument to VmCdRom.update() acorrding to #869257
- implemented support for #869257
- added /async argument to VmCdRom.update()
- added /async argument to ClusterNetworks.update()
- removed Disk.update() method
- added parameters overload for adding direct-lun disk
- added vm/template.display.smartcard_enabled
- added correlation_id to VMDisk.activate()/deactivate()
- added correlation_id to VMNic.activate()/deactivate()
- added certificate property to vm
- Disk.lunStorage renamed to Disk.lun_storage

* Thu Nov  1 2012 Michael Pasternak <mpastern@redhat.com> - 3.2.0.3-1
- do not send /max header on name-based search
- cannot fetch the disk using /alias #865407
- restrict .get() methods to id/name
- defend against disconnected mode when no proxy cached
- allow persistent_auth via localhost
- rebase to latest api
  - gluster action refactored to lowercase
  - added StorageDomainTemplate.delete()
  - added StorageDomainVM.delete()
  - template/vm.display.allow_reconnect renamed to template/vm.display.allow_override
  - added TemplateDisk.copy()
  - added template.cpu.cpu_tune.vcpu_pin: at Templates.add()/VMs.add()
  - added VmPool.allocatevm()
  - added size property to VmPools.add()
  - from ClusterGlusterVolumes.add() params removed
    access_protocols/access_control_list

* Thu Sep  20 2012 Michael Pasternak <mpastern@redhat.com> - 3.2.0.2-1
- make /filter header global rather than method driven #857018
- to host added max_scheduling_memory property
- throw error when connecting to ssl site using http protocol

* Sun Sep  9 2012 Michael Pasternak <mpastern@redhat.com> - 3.2.0.1-1
- to Disks.add() added /name arg
- to disk.install() added r/oot_password arg
- to Template.delete() added async/correlation_id args
- to Template.update added documentation
- to HostTags.add() added expect/correlation_id args
- to VM.start added /filter header
- raise NoCertificatesError only when no ca_file
- use cached /filter argument rather than demanding it in methods
- added correlation_id to:
  - restore snapshot
  - detach HostNIC
  - added create/update/delete methods to template.nics
- clean context on disconnect
- add filter parameter to proxy ctr.
- support app. server errors

* Tue Aug  21 2012 Michael Pasternak <mpastern@redhat.com> - 3.1.0.6-1
- make request error being capable to handle any type of response
- verify credentials before storing proxy in cache
- implement insecure flag #848046
- implement server identity check
- do not require optional params

* Sun Aug  5 2012 Michael Pasternak <mpastern@redhat.com> - 3.1.0.5-1
- implemented http header support
- added custom_configuration flag to host NIC
- added override_configuration flag for setupnetworks action
- added Correlation-Id header params
- do not allow sending empty headers
- refactor url params documentation
- removed disk.allow_snapshot param documentation
- to network.update() added [@param network.name: string]
- fixed vm/template os.boot documentation

* Mon Jul 9 2012 Michael Pasternak <mpastern@redhat.com> - 3.1.0.4-1
- fix typo in 'storage' based args documentation
- make 'name' optional in storagedomains.add() to allow importing existent SD
- make api.storagedomains collection searchable
- Host object doesnt expose storage collection #838269
- to DC.delete() method added [@param action.force: boolean]
- api.networks no longer searchable collection
- to create SD added [@param storagdomain.storage.override_luns: boolean]
- VM.delete() no longer requires Action() parameter as mandatory
- SDK should expose api root resource /api #830513
- perform get() request on proxy construction to validate user credentials #827878
- extract error body <h1>xxx</h1> from detail produced by application server #827881
- do not show brackets in error.detail
- fix api.capabilities get/list methods

* Mon Jun 25 2012 Michael Pasternak <mpastern@redhat.com> - 3.1.0.3-1
- to all collection added optional /max/ param. which is signals engine
  to override default amount of returned objects with user defined value
- to Disk type added provisioned_size property and removed /type/ (not supported in 3.1)
- to StorageDomainTemplate/VM import candidates params added clone, name
  properties for clonging imported object.
- to StorageDomainTemplate/VM import candidates params added 
  collapse_snapshots property
- to VM added vcpu_pin collection for vm cpu pinning

* Thu Jun 7 2012 Michael Pasternak <mpastern@redhat.com> - 3.1.0.2-1alpha
- prevent stack overflow caused by comparisons creating infinite loops
- fix error handling regression
- implement support for 3+ period based URLs, new capabilities:    
    - vm.snapshot.disks/nics collections support
    - host/vm.nics.statistics collections support
    - collection/resource.permits support
- rebase to latest api, new capabilities:
    - gluster collections/resources
    - quota support
    - remove template disk (by storage domain)
    - vm.payload support
    - floating disk support
- add __eqals__ to business entities #782891

* Wed May 16 2012 Michael Pasternak <mpastern@redhat.com> - 3.1.0.1-1alpha
- Version format refactoring to align with oVirt version schema 
- Alpha release

* Thu May 10 2012 Michael Pasternak <mpastern@redhat.com> - 1.6.5
- Added session based auth. support
- Infinite recursion when calling non-existent method #808124
- at Network/.add() added [@param network.usages: collection]
- at HostNIC/.add() added [@param hostnic.ip.mtu: int]
- at StorageDomainTemplate/StorageDomainVM.import() added:
  [@param action.storagedomain.id|name: string]
  [@param action.vm.disks.disk: collection]
- at StorageDomains.add() method added:
  Overload 4:
    @param storagdomain.name: string
    @param storagdomain.host.id|name: string
    @param storagdomain.type: string
    @param storagdomain.storage.type: string
    @param storagdomain.format: boolean
    @param storagdomain.storage.path: string
    @param storagedomain.storage.vfs_type: string
    [@param storagdomain.storage.address: string]
    [@param storagdomain.storage.mount_options: string]
- at Template/VM added:
  [@param template/vm.display.allow_reconnect: boolean]
-at Template/VM.add() added:
  [@param template/vm.display.allow_reconnect: boolean]
  [@param template/vm.vm.disks.disk: collection]
-added VMDisk.activate() method
-added VMDisk.deactivate() method
-added VMNic.activate() method
-added VMNic.deactivate() method

* Wed Mar 28 2012 Michael Pasternak <mpastern@redhat.com> - 1.6.4
- get rid of papyon dep.
- implement ordereddict
- lower lxml dep.

* Wed Mar 21 2012 Michael Pasternak <mpastern@redhat.com> - 1.6.3
- few methods argumets documentation fixes

* Wed Mar 14 2012 Michael Pasternak <mpastern@redhat.com> - 1.6.2
- add papyon dependency (needed for odict)

* Tue Mar 13 2012 Michael Pasternak <mpastern@redhat.com> - 1.6.1
- rebase to latest api
  - refactored storage.create() parameters sets
  - added documentation for UPDATE methods arguments
  - implemented ars-doc support for collection based arguments
  - added vm.delete(Action) signature, to force vm removal
  - implemented support for collection based actions
  - added setupnetworks action on collection of HostNics
  - added prestarted_vms property to vmpool
  - added support for new rsdl section describing url parameters
  - added 'reboot' property in host (used to disable reboot after installation)
  - added 'plugged' property in vm disk (to plug/unplug the disk at runtime)
- implement support for documentation of netsed collection based args
- support actions on collection
- refactor documentation for collection based arguments
- implement support for collection based parameters
- implement url matrix parameters support
- Cluster with NULL DC cannot be attached to DC #782828
- use secured connection if no protocol specified
- add documentation for api proxy arguments
- add debugging capabilities

* Wed Feb 15 2012 Michael Pasternak <mpastern@redhat.com> - 1.5
- several minor improvements

* Fri Feb 10 2012 Michael Pasternak <mpastern@redhat.com> - 1.4
- added get_product_info() method to entry point

* Tue Feb 7 2012 Michael Pasternak <mpastern@redhat.com> - 1.3
- rebased to latest ovirt-engine-api:
  - added update() for role resource
  - various parameter wrapping improvements

* Thu Jan 19 2012 Michael Pasternak <mpastern@redhat.com> - 1.2-1
- use direct URI on get(id=x) rather than search pattern
- extention for #782707

* Mon Jan 16 2012 Michael Pasternak <mpastern@redhat.com> - 1.1-1
- add connectivity check and disconnect methods for #781820
  https://bugzilla.redhat.com/show_bug.cgi?id=781820

* Thu Dec 15 2011 Ofer Schreiber <oschreib@redhat.com> - 1.0-1
- Initial build
