package org.ovirt.engine.api.restapi.resource.validation;

import static org.ovirt.engine.api.common.util.EnumValidator.validateEnum;

import org.ovirt.engine.api.model.InheritableBoolean;
import org.ovirt.engine.api.model.MigrationOptions;

@ValidatedClass(clazz = MigrationOptions.class)
public class MigrationOptionsValidator implements Validator<MigrationOptions> {
    @Override
    public void validateEnums(MigrationOptions options) {
        if (options != null) {
            if (options.isSetAutoConverge()) {
                validateEnum(InheritableBoolean.class, options.getAutoConverge(), true);
            }
            if (options.isSetCompressed()) {
                validateEnum(InheritableBoolean.class, options.getCompressed(), true);
            }
        }
    }
}
