#
# ovirt-hosted-engine-ha -- ovirt hosted engine high availability
# Copyright (C) 2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

"""Constants."""

METADATA_FEATURE_VERSION = 1
METADATA_PARSE_VERSION = 1

MAX_HOST_ID_SCAN = 64
HOST_SEGMENT_BYTES = 4096
METADATA_BLOCK_BYTES = 512
SERVICE_TYPE = 'hosted-engine'
HOST_ALIVE_TIMEOUT_SECS = 60
MESSAGE_READ_TIMEOUT_SEC = 30.0

# See http://www.gnu.org/software/automake/manual/html_node/Scripts.html
BROKER_SOCKET_FILE = '/var/run/ovirt-hosted-engine-ha/broker.socket'

ENGINE_SETUP_CONF_FILE = '/etc/ovirt-hosted-engine/hosted-engine.conf'
NOTIFY_CONF_FILE_35 = '/etc/ovirt-hosted-engine-ha/broker.conf'
NOTIFY_CONF_FILE = '/var/lib/ovirt-hosted-engine-ha/broker.conf'
ANSWER_FILE_35 = '/etc/ovirt-hosted-engine/answers.conf'
VM_CONF_FILE_35 = '/etc/ovirt-hosted-engine/vm.conf'

LOCAL_VM_CONF_PATH = '/var/run/ovirt-hosted-engine-ha/vm.conf'

HA_AGENT_CONF_FILE = '/var/lib/ovirt-hosted-engine-ha/ha.conf'

OVIRT_HOSTED_ENGINE_LB_DIR = '/var/lib/ovirt-hosted-engine-ha'

SD_MOUNT_PARENT = '/rhev/data-center/mnt'
SD_METADATA_DIR = 'ha_agent'

VDS_CLIENT_DIR = '/usr/share/vdsm'
VDS_CLIENT_SSL = True
VDS_CLIENT_MAX_RETRY = 3
VDSCLI_SSL_TIMEOUT = 900

DOMAIN_TYPE_NFS3 = 'nfs3'
DOMAIN_TYPE_NFS4 = 'nfs4'
DOMAIN_TYPE_GLUSTERFS = 'glusterfs'
DOMAIN_TYPE_ISCSI = 'iscsi'
DOMAIN_TYPE_FC = 'fc'
STORAGE_TYPE_NFS = 1
STORAGE_TYPE_FC = 2
STORAGE_TYPE_ISCSI = 3
STORAGE_TYPE_GLUSTERFS = 7

CONF_IMAGE_DESC = 'HostedEngineConfigurationImage'
DEFAULT_CONF_IMAGE_SIZE_GB = 1

BLANK_UUID = '00000000-0000-0000-0000-000000000000'


class HEConfFiles(object):
    HECONFD_VERSION = 'version'
    HECONFD_ANSWERFILE = 'fhanswers.conf'
    HECONFD_HECONF = 'hosted-engine.conf'
    HECONFD_BROKER_CONF = 'broker.conf'
    HECONFD_VM_CONF = 'vm.conf'


class VolumeFormat(object):
    UNKNOWN_FORMAT = 3
    COW_FORMAT = 4
    RAW_FORMAT = 5


class VolumeTypes(object):
    UNKNOWN_VOL = 0
    PREALLOCATED_VOL = 1
    SPARSE_VOL = 2


class VDSMEnv(object):
    VDSM_UID = 36
    KVM_GID = 36


class VDSMConstants(object):
    NFS_DOMAIN = 1
    FC_DOMAIN = 2
    ISCSI_DOMAIN = 3
    POSIXFS_DOMAIN = 6
    GLUSTERFS_DOMAIN = 7
    DATA_DOMAIN = 1
