%global         package_version 1.0.0_master

%if 0%{?fedora} || 0%{?rhel} >= 7
%global with_systemd 1
%endif

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%else
%global with_python2 1
%endif

%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib2: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}

# Skips check since rhel default repos lack pep8 and pyflakes
%if ! 0%{?rhel}
%{!?with_check:%global with_check 1}
%else
%{!?with_check:%global with_check 0}
%endif

# Default to skipping autoreconf.  Distros can change just this one line
# (or provide a command-line override) if they backport any patches that
# touch configure.ac or Makefile.am.
%{!?enable_autotools:%define enable_autotools 0}

%global modname ovirt_register

Name:           python-ovirt-register
Version:        1.0.0
Release:        6%{?release_suffix}%{?dist}
Summary:        A python module and tool for registering nodes to oVirt Engine
License:        GPLv2+
Group:          System Environment/Libraries
URL:            http://www.ovirt.org
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz

BuildArch:      noarch

BuildRequires: python2-devel
BuildRequires: python-setuptools

%if 0%{?with_check}
BuildRequires: python-tools
BuildRequires: python-pep8
BuildRequires: pyflakes
%endif

# Autotools BuildRequires
%if 0%{?enable_autotools}
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel
BuildRequires: libtool
%endif

%if 0%{?with_python3} && 0%{?with_check}
BuildRequires: python3-devel
BuildRequires: python3-setuptools
BuildRequires: python3-pyflakes
BuildRequires: python3-pep8
BuildRequires: python-tools
%endif

Requires: pyOpenSSL
Requires: dmidecode
Requires: python-requests
Requires: libselinux-python
%if 0%{?with_systemd}
Requires: systemd-python
%endif

%{!?_licensedir:%global license %%doc}

%description
python ovirt register is a python 2 library for registering hosts
to oVirt Engine via HTTPs protocol. It supports Engine 3.3 or superior.
This package also contains the command line tool ovirt-register to
trigger the registration.

%if 0%{?with_python3}
%package -n python3-ovirt-register
Summary: A python 3 module and tool for registering nodes to oVirt Engine
Requires: dmidecode
Requires: python3-pyOpenSSL
Requires: python3-requests
Requires: systemd-python3
Requires: libselinux-python3

%description -n python3-ovirt-register
python ovirt register is a python 3 library for registering hosts
to oVirt Engine via HTTPs protocol. It supports Engine 3.3 or superior.
This package also contains the command line tool ovirt-register to
trigger the registration.
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if 0%{?enable_autotools}
autoreconf -if
%endif

%if 0%{?with_python3}
%configure
%endif

%if 0%{?with_python2}
%configure --without-python3
%endif

make %{?_smp_mflags}

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%check
%if 0%{?with_check}
make check-local
%endif

%if 0%{?with_python2}
%files
%{_bindir}/ovirt-register
%{_mandir}/man1/ovirt-register.1.gz
%doc AUTHORS docs/PROTOCOL README
%license COPYING
%dir %{python2_sitelib}/%{modname}
%{python2_sitelib}/%{modname}/*
%endif

%if 0%{?with_python3}
%files -n python3-ovirt-register
%{_bindir}/ovirt-register
%{_mandir}/man1/ovirt-register.1.gz
%doc AUTHORS docs/PROTOCOL README
%license COPYING
%dir %{python3_sitelib}/%{modname}
%{python3_sitelib}/%{modname}/*
%endif

%changelog
* Sun Jul 05 2015 Douglas Schilling Landgraf <dougsland@redhat.com> 1.0-5
- Replace distutils packing for autotools

* Fri Jul 03 2015 Douglas Schilling Landgraf <dougsland@redhat.com> 1.0-4
- chmod/chown should be outside of with

* Thu Jul 02 2015 Douglas Schilling Landgraf <dougsland@redhat.com> 1.0-3
- Improve uuid API handling
- improve spec
- try/except to syslog

* Thu Jul 02 2015 Douglas Schilling Landgraf <dougsland@redhat.com> 1.0-2
- Improvements in docstring, persist_uuid and pki module

* Wed Jun 24 2015 Douglas Schilling Landgraf <dougsland@redhat.com> 1.0-1
- Support registration for Engine 3.3 or higher
- Split package for python2 and python3
- Improve persist/unpersist handling
- Improve uuid handling
- Improve logging

* Thu May 07 2015 Douglas Schilling Landgraf <dougsland@redhat.com> 1.0-0
- Initial take
