# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%define use_vdsm %( test -z  && echo 1 || echo 0)
%global _plugindir %{_datarootdir}/cockpit/
%global _ovirtenginedir %{_datarootdir}/ovirt-engine
%global _uipluginsdir %{_ovirtenginedir}/ui-plugins
%global product oVirt
# TODO: add autogen.sh --with-rhev
%global use_rhev %( test -z @RHEV@ && echo 1 || echo 0)
%define debug_package %{nil}

# git ls-remote http://gerrit.ovirt.org/cockpit-ovirt.git | grep $tag"
%global commit a4af01a61a4351a07353cde7414eb72fa350dc4e
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global source_basename cockpit-ovirt-0.10.6-1.4.1

Name:           cockpit-ovirt
Version:        0.10.6
Release:        1.4.1%{?release_suffix}%{?checkout}%{?dist}
Summary:        Dashboard for Cockpit based on %{product}.
License:        ASL 2
URL:            https://gerrit.ovirt.org/cockpit-ovirt
Source0:        %{source_basename}.tar.gz
BuildArch:      x86_64
ExclusiveArch:  x86_64

#This is a hack for copr, but why is it needed?
BuildRequires: python
BuildRequires: ovirt-engine-nodejs
BuildRequires: ovirt-engine-nodejs-modules

%package dashboard
Summary:        Dashboard for Cockpit based on %{product}.
BuildArch:      noarch

%if 0%{?rhel}
#FIXME: don't pull in base cockpit until rhbz#1349375 is fixed
Requires:       cockpit-bridge
Requires:       cockpit-ws
Requires:       cockpit-shell
Requires:       cockpit-storaged
%else
Requires:       cockpit
%endif

Requires:       ovirt-hosted-engine-setup
Requires:       otopi >= 1.5.2-1
%if 0%{?use_vdsm}
Requires: vdsm >= 4.17.999-610
%else
%endif

%description
This package provides a Cockpit dashboard for use with %{product}.

%description dashboard
This package provides a Cockpit dashboard for use with %{product}.

%prep
%setup -q -n"%{source_basename}"

# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"

# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./dashboard/node_modules
%if 0%{?use_vdsm}
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./vdsm/node_modules
%endif


%build
%if 0%{?use_vdsm}
%configure --with-vdsm
%else
%configure
%endif

export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}
%if 0%{?use_vdsm}
chmod a+x %{buildroot}/%{_plugindir}/ovirt-dashboard/vdsm/vdsm/vdsm
%endif

%files dashboard
%if 0%{?use_vdsm}
%doc vdsm/README.md 
%endif
%license LICENSE
%{_plugindir}/ovirt-dashboard

%package uiplugin
Summary: UI Plugin embedding Cockpit in oVirt's Administration Portal
%if 0%{?use_rhev}
Requires: rhev-engine-webadmin-portal
%else
Requires: ovirt-engine-webadmin-portal
%endif
BuildArch: noarch

%description uiplugin
Optional UI plugin embedding Cockpit in oVirt's Administration Portal for low-level host management.

%files uiplugin
%{_uipluginsdir}/cockpit.json
%{_uipluginsdir}/cockpit-resources

%changelog
* Mon Oct 24 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.1
- Be smarter about the password check in hosted-engine setup
* Wed Aug 10 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.6
- Don't include the cockpit metapackage on RHEL
* Wed Jul 27 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.2
- UX improvements
* Fri Jul 1 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6
- Run hosted-engine setup as a superuser if sudo is available
- Rename the dashboard so branding isn't needed
- UX improvements
* Thu Jun 16 2016 Marek Libra <mlibra@redhat.com> - 0.10.5
- UI improvements
* Wed Jun 08 2016 Marek Libra <mlibra@redhat.com> - 0.10.4
- UI bugfixes and minor usability improvements
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10.3
- Update the otopi parser
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10
- Add a hosted engine status pae
- Add cancellation buttons for hosted engine
- Catch abnormal exits
* Wed May 18 2016 Ryan Barry <rbarry@redhat.com> - 0.9
- Add links to other parts of cockpit on the dashboard
- Add the ability to show the host SSH key to the dashboard
- Terminate hosted engine setup when the page is exited
- Mask some fields in hosted engine setup
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Thu Apr 28 2016 Marek Libra <mlibra@redhat.com> - 0.7
- Add Webadmin Cockpit UI Plugin
* Mon Apr 25 2016 Marek Libra <mlibra@redhat.com> - 0.6
- Add vdsm VM Management
* Fri Apr 08 2016 Ryan Barry <rbarry@redhat.com> - 0.5
- Add node-dashboard
* Tue Mar 22 2016 Ryan Barry <rbarry@redhat.com> - 0.4
- Add node-dashboard
* Fri Mar 18 2016 Marek Libra <rbarry@redhat.com> - 0.3
- Update packaging to match upstream standards
- Convert to autotools
* Fri Mar 11 2016 Marek Libra <mlibra@redhat.com> - 0.2
* Thu Mar 03 2016 Marek Libra <mlibra@redhat.com> - 0.1
- Initial packaging

