#python2_sitelib is declared as python_sitelib in EL6
%if 0%{?rhel} && 0%{?rhel} <= 6
%global python2_sitelib %{python_sitelib}
%endif

Name:		ioprocess
Version:	0.16.1
Release:	1%{?release_suffix}%{?dist}
Summary:	Slave process to perform risky IO

Group:		System Environment/Base
License:	GPLv2+
URL:		https://github.com/oVirt/ioprocess

# Note: the url fragment satisfies the build system, assuming that the source
# url ends with name-version.tar.gz. This part is ignored by the server.
# See https://fedoraproject.org/wiki/Packaging:SourceURL?rd=Packaging/SourceURL#Git_Tags
Source:		https://github.com/oVirt/ioprocess/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz


BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	python2-devel
BuildRequires:	glib2-devel
BuildRequires:	yajl-devel
Requires:	yajl
#EL7 is able to autodetect library dependencies
%if 0%{?rhel} && 0%{?rhel} <= 6
Requires:	glib2 >= 2.28
%endif

%description
Slave process to perform risky IO.


%prep
%setup -q %{name}-%{version}


%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}


%files
%{!?_licensedir:%global license %doc}
%{_libexecdir}/ioprocess
%doc README.md AUTHORS
%license COPYING

%package -n python-ioprocess
Summary:	Python bindings for ioprocess
BuildArch:	noarch
BuildRequires:	python
BuildRequires:	python-cpopen
BuildRequires:	python-six
BuildRequires:	util-linux
Requires:	python
Requires:	python-cpopen
Requires:	python-six
Requires:	%{name} = %{version}-%{release}

%description -n python-ioprocess
Python bindings for ioprocess

%files -n python-ioprocess
%{!?_licensedir:%global license %doc}
%{python2_sitelib}/ioprocess-*.egg-info
%{python2_sitelib}/ioprocess/
%doc README.md AUTHORS
%license COPYING

%changelog

* Thu Jun 16 2016 Nir Soffer <nsoffer@redhat.com> 0.16.1-1
- ioprocess: Fix logging of file descriptor path
- ioprocess: Fix logger initialization
- binding: Fix race between _run and close
- binding: Add optional ioprocess name
- ioprocess: Fix fd leak in truncate and touch (Resolves BZ#1339777)
- python3: Initial port
- build: Switch to pytest and tox
- bindings: Use only daemon threads
- use LDADD instead of LDFLAGS to fix failure to build with ld
  --as-needed (Logan Rosen)

* Fri Dec 11 2015 Sandro Bonazzola <sbonazzo@redhat.com> 0.15.1-1
- Resolves: BZ#1287946
- Fixed URL and Source0
- Use license for license files

* Sun Nov 29 2015 Yeela Kaplan <ykaplan@redhat.com> - 0.15.0-4
- Fix string formatting for 32bit architecture
* Thu Nov 26 2015 Yaniv Bronhaim <ybronhei@redhat.com> - 0.15.0-3
- Rebuild for ovirt 3.6.1
- Add debug logging
- Fix memory and cpu leak
- Set cpu affinity to run ioprocess on any cpu
* Sun Apr 5 2015 Yaniv Bronhaim <ybronhei@redhat.com> - 0.15.0-2
- Rebuild for ppc64le arch
* Tue Feb 17 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 0.15.0-1
- Fix rpmlint E: explicit-lib-dependency
- Fix rpmlint W: no-documentation
* Mon Oct 20 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.14.0-1
- Fix poll timeout
- Add support for zombiereaper where available
- Fix IOProcesses being referenced by commincation thread
- build: update INSTALL
- specfile: Add missing dependency to glib2
* Wed Sep 3 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.12.0-1
- Fixed memory leak due to forgetting to clear the pending requests queue in
  the python bindings
* Mon Aug 4 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.10.0-1
- Fixed unsefe strerror usage
- Fixed cases logging lines get mangled
* Tue Jul 29 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.8.1-1
- Fixed unsafe use of strerror
- Fixed races in queue limiting
* Sun Jul 20 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.6.1-1
- Reduced logging even for debug level
- Added support for block sizes other than 512
- Added the --max-queued-requests argument
* Sun Jun 15 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.5.0-1
- Fixed missing error check in readfile()
- Added flags arg to fetch()
- Added st_blocks to stat()
* Thu Jun 05 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.4.1-1
- Fixed missing dependcy for python bindings
* Mon Jun 02 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.4-1
- Added touch command
- Changed truncate to include setting file mode and creating a file only when
  one doesn't exist
* Sun Jan 05 2014 Saggi Mizrahi <smizrahi@redhat.com> 0.3-1
Inital RPM release
