/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;

public interface TemplateService extends Service {
    public interface ExportRequest extends Request<ExportRequest, ExportResponse> {
        ExportRequest exclussive(Boolean exclussive);
        ExportRequest storageDomain(StorageDomain storageDomain);
        ExportRequest storageDomain(StorageDomainBuilder storageDomain);
    }
    
    public interface ExportResponse extends Response {
    }
    
    ExportRequest export();
    
    public interface GetRequest extends Request<GetRequest, GetResponse> {
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        GetRequest filter(Boolean filter);
    }
    
    public interface GetResponse extends Response {
        Template template();
    }
    
    GetRequest get();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest template(Template template);
        UpdateRequest template(TemplateBuilder template);
    }
    
    public interface UpdateResponse extends Response {
        Template template();
    }
    
    UpdateRequest update();
    
    TemplateCdromsService cdromsService();
    /**
     * Reference to the service that manages a specific
     * disk attachment of the template.
     */
    TemplateDiskAttachmentsService diskAttachmentsService();
    GraphicsConsolesService graphicsConsolesService();
    TemplateNicsService nicsService();
    AssignedPermissionsService permissionsService();
    AssignedTagsService tagsService();
    TemplateWatchdogsService watchdogsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

