/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.ovirt.engine.sdk4.ConnectionBuilder;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.HttpClient;
import org.ovirt.engine.sdk4.internal.HttpClient45;

public class ConnectionBuilder45
extends ConnectionBuilder {
    @Override
    protected HttpClient createHttpClient() {
        int port = this.getPort();
        Registry authSchemeProvider = null;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(this.getHost(), port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        if (this.user != null && this.user.length() > 0) {
            credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        } else if (this.kerberos) {
            authSchemeProvider = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
            credsProvider.setCredentials(authScope, new Credentials(){

                public Principal getUserPrincipal() {
                    return null;
                }

                public String getPassword() {
                    return null;
                }
            });
        }
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setConnectTimeout(this.timeout).build();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)this.createConnectionSocketFactoryRegistry())).setDefaultRequestConfig(globalConfig).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultAuthSchemeRegistry((Lookup)authSchemeProvider);
        if (!this.compress) {
            clientBuilder.disableContentCompression();
        }
        return new HttpClient45(clientBuilder.build());
    }

    private Registry createConnectionSocketFactoryRegistry() {
        String protocol = this.getProtocol();
        Registry registry = null;
        if (HTTP_PROTOCOL.equals(protocol)) {
            PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
            registry = RegistryBuilder.create().register(HTTP_PROTOCOL, (Object)plainsf).build();
        } else if (HTTPS_PROTOCOL.equals(protocol)) {
            try {
                SSLConnectionSocketFactory sslsf = null;
                if (this.insecure) {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, new TrustManager[]{this.noCaTrustManager}, null);
                    sslsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                } else {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                    if (this.trustStoreFile != null) {
                        sslContextBuilder.loadTrustMaterial(new File(this.trustStoreFile), this.trustStorePassword != null ? this.trustStorePassword.toCharArray() : null);
                    }
                    SSLContext sslContext = sslContextBuilder.build();
                    sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
                }
                registry = RegistryBuilder.create().register(HTTPS_PROTOCOL, (Object)sslsf).build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("SSL context initiation has failed locating TLS algorithm.", e);
            }
            catch (KeyManagementException e) {
                throw new Error("SSL context initiation has failed because of key error.", e);
            }
            catch (KeyStoreException e) {
                throw new Error("CA certificate keystore initiation has failed.", e);
            }
            catch (FileNotFoundException e) {
                throw new Error("CA certificate keystore was not found.", e);
            }
            catch (CertificateException e) {
                throw new Error("CA certificate error.", e);
            }
            catch (IOException e) {
                throw new Error("I/O error occurred, is your keystore password correct?", e);
            }
        } else {
            throw new Error("Unsupported protocol " + protocol);
        }
        return registry;
    }
}

