/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.GraphicsConsole;

public interface GraphicsConsoleService extends Service {
    /**
     * Gets the configuration of the graphics console.
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
        /**
         * Use the following query to obtain the current run-time configuration of the graphics console.
         * 
         * [source]
         * ----
         * GET /ovit-engine/api/vms/{vm:id}/graphicsconsoles/{console:id}?current=true
         * ----
         * 
         * The default value is `false`.
         */
        GetRequest current(Boolean current);
    }
    
    /**
     * Gets the configuration of the graphics console.
     */
    public interface GetResponse extends Response {
        GraphicsConsole console();
    }
    
    /**
     * Gets the configuration of the graphics console.
     */
    GetRequest get();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

