/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.FileContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.types.File;

public class XmlFileReader {
    public static File readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        FileContainer object = new FileContainer();
        block26: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block26;
                }
                case "id": {
                    object.id(image);
                    continue block26;
                }
            }
        }
        reader.next();
        block27: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block27;
                }
                case "content": {
                    object.content(reader.readString());
                    continue block27;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block27;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block27;
                }
                case "storage_domain": {
                    object.storageDomain(XmlStorageDomainReader.readOne(reader));
                    continue block27;
                }
                case "type": {
                    object.type(reader.readString());
                    continue block27;
                }
                case "link": {
                    XmlFileReader.readLink(reader, object);
                    continue block27;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<File> iterateMany(final XmlReader reader) {
        return new Iterator<File>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public File next() {
                File next = XmlFileReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<File> readMany(XmlReader reader) {
        ArrayList<File> list = new ArrayList<File>();
        Iterator<File> iterator = XmlFileReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, FileContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

