/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.Api;

public interface SystemService extends Service {
    /**
     * Returns basic information describing the API, like the product name, the version number and a summary of the
     * number of relevant objects.
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Returns basic information describing the API, like the product name, the version number and a summary of the
     * number of relevant objects.
     */
    public interface GetResponse extends Response {
        Api api();
    }
    
    /**
     * Returns basic information describing the API, like the product name, the version number and a summary of the
     * number of relevant objects.
     */
    GetRequest get();
    
    public interface ReloadConfigurationsRequest extends Request<ReloadConfigurationsRequest, ReloadConfigurationsResponse> {
        /**
         * Indicates if the reload should be performed asynchronously.
         */
        ReloadConfigurationsRequest async(Boolean async);
    }
    
    public interface ReloadConfigurationsResponse extends Response {
    }
    
    ReloadConfigurationsRequest reloadConfigurations();
    
    /**
     * List all known affinity labels.
     */
    AffinityLabelsService affinityLabelsService();
    BookmarksService bookmarksService();
    /**
     * Reference to the service that provides information about the cluster levels supported by the system.
     */
    ClusterLevelsService clusterLevelsService();
    ClustersService clustersService();
    CpuProfilesService cpuProfilesService();
    DataCentersService dataCentersService();
    DiskProfilesService diskProfilesService();
    DisksService disksService();
    DomainsService domainsService();
    EventsService eventsService();
    ExternalHostProvidersService externalHostProvidersService();
    /**
     * Reference to service facilitating import of external virtual machines.
     */
    ExternalVmImportsService externalVmImportsService();
    GroupsService groupsService();
    HostsService hostsService();
    IconsService iconsService();
    /**
     * List of all image transfers being performed for image I/O in oVirt.
     */
    ImageTransfersService imageTransfersService();
    InstanceTypesService instanceTypesService();
    JobsService jobsService();
    EngineKatelloErrataService katelloErrataService();
    MacPoolsService macPoolsService();
    /**
     * Network filters will enhance the admin ability to manage the network packets traffic from/to the participated
     * VMs.
     */
    NetworkFiltersService networkFiltersService();
    NetworksService networksService();
    OpenstackImageProvidersService openstackImageProvidersService();
    OpenstackNetworkProvidersService openstackNetworkProvidersService();
    OpenstackVolumeProvidersService openstackVolumeProvidersService();
    OperatingSystemsService operatingSystemsService();
    SystemPermissionsService permissionsService();
    RolesService rolesService();
    SchedulingPoliciesService schedulingPoliciesService();
    SchedulingPolicyUnitsService schedulingPolicyUnitsService();
    StorageServerConnectionsService storageConnectionsService();
    StorageDomainsService storageDomainsService();
    TagsService tagsService();
    TemplatesService templatesService();
    UsersService usersService();
    VmPoolsService vmPoolsService();
    VmsService vmsService();
    VnicProfilesService vnicProfilesService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

