/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;

public interface HostNic extends Identified {
    BigInteger adAggregatorId();
    
    boolean adAggregatorIdPresent();
    
    String baseInterface();
    
    boolean baseInterfacePresent();
    
    Bonding bonding();
    
    boolean bondingPresent();
    
    BootProtocol bootProtocol();
    
    boolean bootProtocolPresent();
    
    boolean bridged();
    
    boolean bridgedPresent();
    
    boolean checkConnectivity();
    
    boolean checkConnectivityPresent();
    
    boolean customConfiguration();
    
    boolean customConfigurationPresent();
    
    Ip ip();
    
    boolean ipPresent();
    
    Ip ipv6();
    
    boolean ipv6Present();
    
    BootProtocol ipv6BootProtocol();
    
    boolean ipv6BootProtocolPresent();
    
    Mac mac();
    
    boolean macPresent();
    
    BigInteger mtu();
    
    boolean mtuPresent();
    
    List<NetworkLabel> networkLabels();
    
    boolean networkLabelsPresent();
    
    boolean overrideConfiguration();
    
    boolean overrideConfigurationPresent();
    
    List<Property> properties();
    
    boolean propertiesPresent();
    
    BigInteger speed();
    
    boolean speedPresent();
    
    List<Statistic> statistics();
    
    boolean statisticsPresent();
    
    NicStatus status();
    
    boolean statusPresent();
    
    HostNicVirtualFunctionsConfiguration virtualFunctionsConfiguration();
    
    boolean virtualFunctionsConfigurationPresent();
    
    Vlan vlan();
    
    boolean vlanPresent();
    
    Host host();
    
    boolean hostPresent();
    
    Network network();
    
    boolean networkPresent();
    
    HostNic physicalFunction();
    
    boolean physicalFunctionPresent();
    
    Qos qos();
    
    boolean qosPresent();
    
}
