/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.util.List;

public interface Cluster extends Identified {
    boolean ballooningEnabled();
    
    boolean ballooningEnabledPresent();
    
    Cpu cpu();
    
    boolean cpuPresent();
    
    List<Property> customSchedulingPolicyProperties();
    
    boolean customSchedulingPolicyPropertiesPresent();
    
    Display display();
    
    boolean displayPresent();
    
    ErrorHandling errorHandling();
    
    boolean errorHandlingPresent();
    
    FencingPolicy fencingPolicy();
    
    boolean fencingPolicyPresent();
    
    boolean glusterService();
    
    boolean glusterServicePresent();
    
    boolean haReservation();
    
    boolean haReservationPresent();
    
    Ksm ksm();
    
    boolean ksmPresent();
    
    boolean maintenanceReasonRequired();
    
    boolean maintenanceReasonRequiredPresent();
    
    MemoryPolicy memoryPolicy();
    
    boolean memoryPolicyPresent();
    
    MigrationOptions migration();
    
    boolean migrationPresent();
    
    boolean optionalReason();
    
    boolean optionalReasonPresent();
    
    List<RngSource> requiredRngSources();
    
    boolean requiredRngSourcesPresent();
    
    SerialNumber serialNumber();
    
    boolean serialNumberPresent();
    
    List<Version> supportedVersions();
    
    boolean supportedVersionsPresent();
    
    SwitchType switchType();
    
    boolean switchTypePresent();
    
    boolean threadsAsCores();
    
    boolean threadsAsCoresPresent();
    
    boolean trustedService();
    
    boolean trustedServicePresent();
    
    boolean tunnelMigration();
    
    boolean tunnelMigrationPresent();
    
    Version version();
    
    boolean versionPresent();
    
    boolean virtService();
    
    boolean virtServicePresent();
    
    List<AffinityGroup> affinityGroups();
    
    boolean affinityGroupsPresent();
    
    List<CpuProfile> cpuProfiles();
    
    boolean cpuProfilesPresent();
    
    DataCenter dataCenter();
    
    boolean dataCenterPresent();
    
    List<GlusterHook> glusterHooks();
    
    boolean glusterHooksPresent();
    
    List<GlusterVolume> glusterVolumes();
    
    boolean glusterVolumesPresent();
    
    MacPool macPool();
    
    boolean macPoolPresent();
    
    Network managementNetwork();
    
    boolean managementNetworkPresent();
    
    List<NetworkFilter> networkFilters();
    
    boolean networkFiltersPresent();
    
    List<Network> networks();
    
    boolean networksPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    SchedulingPolicy schedulingPolicy();
    
    boolean schedulingPolicyPresent();
    
}
