/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import org.ovirt.engine.sdk4.internal.containers.SpecialObjectsContainer;
import org.ovirt.engine.sdk4.types.SpecialObjects;
import org.ovirt.engine.sdk4.types.Tag;
import org.ovirt.engine.sdk4.types.Template;

public class SpecialObjectsBuilder {
    private Template blankTemplate;
    private Tag rootTag;
    
    public SpecialObjectsBuilder blankTemplate(Template newBlankTemplate) {
        blankTemplate = newBlankTemplate;
        return this;
    }
    
    public SpecialObjectsBuilder blankTemplate(TemplateBuilder newBlankTemplate) {
        if (newBlankTemplate == null) {
            blankTemplate = null;
        }
        else {
            blankTemplate = newBlankTemplate.build();
        }
        return this;
    }
    
    
    public SpecialObjectsBuilder rootTag(Tag newRootTag) {
        rootTag = newRootTag;
        return this;
    }
    
    public SpecialObjectsBuilder rootTag(TagBuilder newRootTag) {
        if (newRootTag == null) {
            rootTag = null;
        }
        else {
            rootTag = newRootTag.build();
        }
        return this;
    }
    
    
    public SpecialObjects build() {
        SpecialObjectsContainer container = new SpecialObjectsContainer();
        container.blankTemplate(blankTemplate);
        container.rootTag(rootTag);
        return container;
    }
}
