/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.ImageTransfer;
import org.ovirt.engine.sdk4.types.ImageTransferPhase;

public class ImageTransferContainer extends IdentifiedContainer implements ImageTransfer {
    private ImageTransferPhase phase;
    private String proxyUrl;
    private String signedTicket;
    private Host host;
    private Image image;
    
    public ImageTransferPhase phase() {
        return phase;
    }
    
    public void phase(ImageTransferPhase newPhase) {
        phase = newPhase;
    }
    
    public boolean phasePresent() {
        return phase != null;
    }
    
    public String proxyUrl() {
        return proxyUrl;
    }
    
    public void proxyUrl(String newProxyUrl) {
        proxyUrl = newProxyUrl;
    }
    
    public boolean proxyUrlPresent() {
        return proxyUrl != null;
    }
    
    public String signedTicket() {
        return signedTicket;
    }
    
    public void signedTicket(String newSignedTicket) {
        signedTicket = newSignedTicket;
    }
    
    public boolean signedTicketPresent() {
        return signedTicket != null;
    }
    
    public Host host() {
        return host;
    }
    
    public void host(Host newHost) {
        host = newHost;
    }
    
    public boolean hostPresent() {
        return host != null;
    }
    
    public Image image() {
        return image;
    }
    
    public void image(Image newImage) {
        image = newImage;
    }
    
    public boolean imagePresent() {
        return image != null;
    }
    
}
