%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	DATA_DIR=%{_datadir} \\\
	PKG_DATA_DIR=%{_datadir}/%{name} \\\
	%{nil}
Name:		ovirt-engine-extension-aaa-jdbc
Version:	1.1.0
Release:	1%{?dist}
License:	ASL 2.0
Summary:	oVirt Engine Local Users Extension
Group:		Virtualization/Management
URL:		http://www.ovirt.org
BuildArch:	noarch
Source:		http://resources.ovirt.org/pub/src/%{name}/%{name}-1.1.0.tar.gz

BuildRequires: java-devel >= 1.7.0

BuildRequires: apache-commons-codec
BuildRequires: apache-commons-lang
BuildRequires: ant
BuildRequires: jackson
BuildRequires: jpackage-utils
BuildRequires: ovirt-engine-extensions-api
BuildRequires: postgresql-jdbc
BuildRequires: slf4j >= 1.7

%if 0%{?fedora}
BuildRequires: slf4j-jdk14 >= 1.7
%endif

Requires: ovirt-engine-extensions-api-impl >= 3.5

%description
Local JDBC user management for oVirt engine.

%prep
%setup -c -q

%build
cat > build.properties << __EOF__
jar.commons-codec=$(build-classpath commons-codec)
jar.commons-lang=$(build-classpath commons-lang)
jar.jackson-core-asl=$(build-classpath jackson/jackson-core-asl)
jar.jackson-mapper-asl=$(build-classpath jackson/jackson-mapper-asl)
jar.ovirt-engine-extensions-api=$(build-classpath ovirt-engine/ovirt-engine-extensions-api)
jar.jdbc=$(build-classpath postgresql-jdbc)
jar.slf4j-api=$(build-classpath slf4j/slf4j-api)
package.display.name=%{name}-%{version}-%{release}

__EOF__

make %{make_common_opts} all

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install-no-build DESTDIR="%{buildroot}"

%files
%doc README.admin
%doc README.developer
%{_datadir}/%{name}/
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-%{name}.conf
%{_bindir}/ovirt-aaa-jdbc-tool

%changelog
* Thu May 26 2016 Martin Perina <mperina@redhat.com> 1.1.0-1
- Removes EL6 support
- Fixed classloading issue in WildFly 10

* Fri Apr 15 2016 Martin Perina <mperina@redhat.com> 1.0.7-1
- Fixed bug 1304368

* Thu Jan 28 2016 Martin Perina <mperina@redhat.com> 1.0.6-1
- Fixed bugs 1299773, 1299793

* Tue Jan 05 2016 Martin Perina <mperina@redhat.com> 1.0.5-1
- Fixes documentation about upgrading aaa-jdbc (bug 1293338)

* Fri Nov 27 2015 Martin Perina <mperina@redhat.com> 1.0.4-1
- Finally fixed bug 1241879

* Mon Nov 23 2015 Martin Perina <mperina@redhat.com> 1.0.3-1
- Fixed bug 1283936

* Fri Nov 06 2015 Martin Perina <mperina@redhat.com> 1.0.2-1
- Fixed bugs 1277398, 1241883, 1241879, 1275667

* Mon Oct 19 2015 Martin Perina <mperina@redhat.com> 1.0.1-1
- Fixed bugs 1269870, 1270821, 1241851

* Tue Oct 06 2015 Martin Perina <mperina@redhat.com> 1.0.0-1
- Initial release

