%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	BIN_DIR=%{_bindir} \\\
	DATA_DIR=%{_datadir} \\\
	PKG_DATA_DIR=%{_datadir}/%{name} \\\
	%{nil}
Name:		ovirt-engine-extension-aaa-ldap
Version:	1.2.1
Release:	1%{?dist}
License:	ASL 2.0
Summary:	oVirt Script Engine Gateway Extension
Group:		Virtualization/Management
URL:		http://www.ovirt.org
BuildArch:	noarch
Source:		http://resources.ovirt.org/pub/src/%{name}/%{name}-1.2.1.tar.gz

BuildRequires:	java-devel >= 1.7.0
BuildRequires:	slf4j >= 1.7
BuildRequires:	ant
BuildRequires:	jpackage-utils
BuildRequires:	ovirt-engine-extensions-api
BuildRequires:	unboundid-ldapsdk


Requires:	ovirt-engine >= 3.5
Requires:	unboundid-ldapsdk >= 2.3.7

%description
Generic LDAP implementation for oVirt engine.

%package setup
Summary:	%{name} setup
Requires:	%{name} = %{version}-%{release}
Requires:	bind-utils
Requires:	otopi >= 1.4.0
Requires:	ovirt-engine >= 3.6
Requires:	python-ldap

%description setup
Setup package for Generic LDAP.

%prep
%setup -c -q

%build
cat > build.properties << __EOF__
package.display.name=%{name}-%{version}-%{release}
build.checks.statics.enable=false
jar.slf4j-api=$(build-classpath slf4j/slf4j-api)
jar.ovirt-engine-extensions-api=$(build-classpath ovirt-engine/ovirt-engine-extensions-api)
jar.unboundid-ldapsdk=$(build-classpath unboundid-ldapsdk)
__EOF__

make %{make_common_opts} all

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install-no-build DESTDIR="%{buildroot}"

rm -f "%{buildroot}/usr/share/ovirt-engine-extension-aaa-ldap/modules/org/ovirt/engine-extensions/aaa/ldap/main/unboundid-ldapsdk.jar"
ln -s \
	"$(build-classpath unboundid-ldapsdk)" \
	"%{buildroot}/usr/share/ovirt-engine-extension-aaa-ldap/modules/org/ovirt/engine-extensions/aaa/ldap/main/unboundid-ldapsdk.jar"

install -d "%{buildroot}%{_sysconfdir}/ovirt-engine-extension-aaa-ldap-setup.conf.d"
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-extension-aaa-ldap-setup.conf.d/10-packaging.conf" << __EOF__
[environment:default]
OVAAALDAP_LDAP/systemCACerts=str:/etc/pki/tls/certs/ca-bundle.crt
__EOF__

%files
%dir %{_datadir}/%{name}
%dir %{_sysconfdir}/ovirt-engine-extension-aaa-ldap-setup.conf.d
%doc README*
%{_datadir}/%{name}/examples/
%{_datadir}/%{name}/modules/
%{_datadir}/%{name}/profiles/
%{_sysconfdir}/ovirt-engine-extension-aaa-ldap-setup.conf.d/10-packaging.conf
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-%{name}.conf

%files setup
%{_bindir}/ovirt-engine-extension-aaa-ldap-setup
%{_datadir}/%{name}/setup/

%changelog
* Fri Jun 30 2016 Martin Perina <mperina@redhat.com> 1.2.1-1
- Fixed bugs: BZ1349178, BZ1349305, BZ1340380

* Thu May 26 2016 Martin Perina <mperina@redhat.com> 1.2.0-1
- Fixed bug: BZ1333878
- Removed EL6 build support

* Mon Apr 18 2016 Martin Perina <mperina@redhat.com> 1.1.4-1
- Fixed bug: BZ1323361

* Thu Mar 31 2016 Martin Perina <mperina@redhat.com> 1.1.3-1
- Fixed bugs: BZ1313516, BZ1313583

* Fri Dec 11 2015 Alon Bar-Lev <alonbl@redhat.com> 1.1.2-1
- Release.

* Thu Dec 10 2015 Alon Bar-Lev <alonbl@redhat.com> 1.1.1-1
- Release.

* Thu Oct 22 2015 Alon Bar-Lev <alonbl@redhat.com> 1.1.0-1
- Release.

* Thu Jan 15 2015 Alon Bar-Lev <alonbl@redhat.com> 1.0.2-1
- Release.

* Wed Dec 24 2014 Alon Bar-Lev <alonbl@redhat.com> 1.0.1-1
- Release.

* Mon Dec 1 2014 Alon Bar-Lev <alonbl@redhat.com> 1.0.0-1
- Initial.
