#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

%if 0%{?fedora} && 0%{?fedora} >= 23
%global		with_python3 1
%global		__python_bin %{__python3}
%global		__python_sitelib %{python3_sitelib}
%else
%global		__python_bin %{__python2}
%global		__python_sitelib %{python2_sitelib}
%endif

%global		package_version 4.0.1
%global		package_name ovirt-log-collector

Summary:	Log Collector for oVirt Engine
Name:		%{package_name}
Version:	4.0.1
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-4.0/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch

Requires:	logrotate
Requires:	openssh-clients
Requires:	sos >= 3.2

Requires:	ovirt-engine-lib

BuildRequires:	gettext

%if 0%{?with_python3}
Requires:	python3
Requires:	python3-dateutil
Requires:	python3-lxml
Requires:	python3-ovirt-engine-sdk4 >= 4.0.0
BuildRequires:	python3-devel
%else
Requires:	python
Requires:	python-dateutil
Requires:	python-lxml
Requires:	python-ovirt-engine-sdk4 >= 4.0.0
BuildRequires:	python2-devel
%endif

%description
Log Collector tool for oVirt Engine

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check \
	PYTHON="%{__python_bin}"
make %{?_smp_mflags}

%check
make check

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc AUTHORS
%license COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/logcollector.conf.d
%config(noreplace) %{_sysconfdir}/ovirt-engine/logcollector.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{__python_sitelib}/ovirt_log_collector/
%{_bindir}/ovirt-log-collector
%{_mandir}/man8/*

%changelog
* Tue Aug 30 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.1-1
- 4.0.1-1

* Tue May 31 2016 Rafael Martins <rmartins@redhat.com> - 4.0.0-1
- 4.0.0-1

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.master
- 4.0.0-0.0.master
