#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 4.0.6
%global	package_name ovirt-release40
%global	ovirt_version 4.0
%global	ovirt_yum_repo http://resources.ovirt.org
%global	ovirt_repo_path_normal /pub/yum-repo/mirrorlist-ovirt-4.0-snapshot-
%global	ovirt_repo_path_static /pub/yum-repo/mirrorlist-ovirt-4.0-snapshot-static-
%global	repo_url_key mirrorlist


Name:		%{package_name}
Version:	4.0.6
Release:	2%{?release_suffix}%{?dist}
Summary:	The oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-4.0/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	http://resources.ovirt.org/pub/keys/RPM-GPG-ovirt-v2

BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:	system-release
Requires:	tar

%description
This package contains the yum configuration for oVirt repositories

%global	host_node_release_file ovirt-release-host-node
%package -n ovirt-release-host-node
Summary:	The oVirt Node release file
Version:	4.0.6
Release:	2%{?release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

BuildRequires:	systemd

Requires(post):	systemd
Requires(postun):	systemd

Requires:	cockpit
Requires:	cockpit-ovirt-dashboard
%if 0%{?rhel}
# We don't build ovirt-node for Fedora yet
Requires:	ovirt-node-ng-nodectl
%endif
Requires:	firewalld
Requires:	imgbased
Requires:	vdsm
Requires:	vdsm-gluster
Requires:	vdsm-hook-fcoe
%if ! 0%{?rhel}
Requires:   vdsm-hook-vhostmd
%endif
Requires:   vdsm-hook-openstacknet
Requires:   vdsm-hook-ethtool-options
Requires:   vdsm-hook-vmfex-dev
Requires:	glusterfs-rdma
Requires:	ovirt-hosted-engine-setup
Requires:	postfix
Requires:	sysstat
Requires:	mailx
Requires:   dracut-fips

# Hack to incldue the passive NM config: https://bugzilla.redhat.com/1326798
Requires:	NetworkManager-config-server

# Additional packages for EFI support
# https://www.brianlane.com/creating-live-isos-with-livemedia-creator.html
# http://lorax.readthedocs.org/en/latest/livemedia-creator.html#kickstarts
Requires:	efibootmgr
Requires:	grub2-efi
Requires:	memtest86+
Requires:	syslinux
Requires:	shim

%description -n ovirt-release-host-node
oVirt Node distribution dependencies, presets and required settings.

%package -n ovirt-node-ng-image-update-placeholder
Summary:	The oVirt Node Image Update Placeholder
Version:	4.0.6
Release:	2%{?release_suffix}%{?placeholder_release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

%description -n ovirt-node-ng-image-update-placeholder
A sub-package to be included into oVirt Node Next squashfs
image to allow upgrading itself


%package snapshot
Summary:	oVirt snapshot repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description snapshot
This package contains the yum configuration for oVirt snapshot repositories


%package pre
Summary:	oVirt pre-release repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description pre
This package contains the yum configuration for oVirt pre-release repositories


%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure \
	--with-ovirt-yum-repo=%{ovirt_yum_repo} \
	--with-repo-url-key=%{repo_url_key} \
	--with-repo-path-normal=%{ovirt_repo_path_normal} \
	--with-repo-path-static=%{ovirt_repo_path_static}
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-snapshot"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-pre"

install -d 755 "%{buildroot}/data/images/rhev"

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}/ovirt-el7-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f23-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

%post snapshot

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-el7-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-f23-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-snapshot/ovirt-snapshot.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"

%post pre

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el7-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f23-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-pre/ovirt-pre.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"

%files
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files snapshot
%{_datadir}/%{package_name}-snapshot/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo


%files pre
%{_datadir}/%{package_name}-pre/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%post -n ovirt-release-host-node
%define __default_units_wanted cockpit.socket sshd.service NetworkManager.service imgbase-clean-grub.service imgbase-motd.service imgbase-config-vdsm.service rsyslog.service auditd.service
# Make the defualt services default requirements of the target
for UNIT in %{__default_units_wanted} ; do
	ln -fs ../$UNIT %{_unitdir}/multi-user.target.wants/$UNIT
done

#
# Create the common os-release file

# Import os-release to get some fields
# NAME, VERSION, ID, VERSION_ID, CPE_NAME
. /etc/os-release || :

install -d /usr/lib/os.release.d/
cat << EOF >> /usr/lib/os.release.d/%{host_node_release_file}
NAME="$NAME"
VERSION="$VERSION"
ID="$ID"
ID_LIKE="$ID_LIKE"
VERSION_ID="$VERSION_ID"
VARIANT="oVirt Node %{package_version}"
VARIANT_ID="ovirt-node"
PRETTY_NAME="oVirt Node %{package_version}"
ANSI_COLOR="$ANSI_COLOR"
CPE_NAME="$CPE_NAME"
HOME_URL="https://www.ovirt.org/"
BUG_REPORT_URL="https://bugzilla.redhat.com/"
EOF

# Only on installation
if [ $1 = 1 ]; then
	cp -p /etc/os-release /usr/lib/os.release.d/.host-node-previous-os-release
	ln -sf os.release.d/%{host_node_release_file} /usr/lib/os-release
	ln -sf ../usr/lib/os-release /etc/os-release
	source /etc/os-release
	ln -sf %{_prefix}/share/ovirt-release-host-node/branding %{_prefix}/share/cockpit/branding/$ID-ovirt-node
fi

# Firewalld - add all services required for host
firewall-offline-cmd --add-service=cockpit >/dev/null 2>&1
firewall-offline-cmd --add-service=vdsm >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt >/dev/null 2>&1
firewall-offline-cmd --add-service=ssh >/dev/null 2>&1
systemctl restart firewalld.service >/dev/null 2>&1

# Restarting cockpit to load the new branding data
systemctl restart cockpit.service >/dev/null 2>&1

# Only whitelist ovirt-node-ng-image-update and ovirt-engine-appliance
# set-enabled is needed to keep the repo enabled when post-processing
# the image
# The loop is required because sed -i does not work with multiple files
for REPO in %{_sysconfdir}/yum.repos.d/ovirt-*.repo;
do
	sed -i \
		-e "/name=/ a includepkgs=ovirt-node-ng-image-update ovirt-node-ng-image ovirt-engine-appliance" \
		-e "1 i # imgbased: set-enabled" \
	"$REPO"
done

#
# NGN TEMPORARY HACKS
# For each hack there must be a bug, and they must be removed at
# some point in time
# ===================

# Really ensure that myhostname is added
# https://bugzilla.redhat.com/show_bug.cgi?id=132994
sed -i.bak_ngn \
	-e '/^hosts:/ s/myhostname//' \
	-e '/^hosts:/ s/[[:blank:]]*$/ myhostname/' \
	/etc/nsswitch.conf

# Enable NM support on NGN
# Disable host-deploy NM check
# https://bugzilla.redhat.com/show_bug.cgi?id=1330144
mkdir -p %{_sysconfdir}/ovirt-host-deploy.conf.d
cat <<EOF > %{_sysconfdir}/ovirt-host-deploy.conf.d/90-ngn-keep-networkmanager.conf
[environment:init]
VDSM/disableNetworkManager=bool:False
EOF


# Hack out NM check in he-setup
# https://bugzilla.redhat.com/show_bug.cgi?id=1326798
sed -i -e "/def _check_NM/ s/$/\n        return/" \
	/usr/share/ovirt-hosted-engine-setup/plugins/ovirt-hosted-engine-setup/network/bridge.py

# =======================
# NGN TEMPORARY HACKS END
#

%postun -n ovirt-release-host-node
for UNIT in %{__default_units_wanted} ; do
	rm -f %{_unitdir}/multi-user.target.wants/$UNIT
done

# In case of uninstall the host-node pkg, return the previous os-release
if [ $1 = 0 ]; then
	rm -f %{_prefix}/share/cockpit/branding/*-ovirt-node
	rm -f /usr/lib/os-release /etc/os-release
	cp -pf /usr/lib/os.release.d/.host-node-previous-os-release /usr/lib/os-release
	ln -sf /usr/lib/os-release /etc/os-release
	rm -f /usr/lib/os.release.d/.host-node-previous-os-release
	firewall-offline-cmd --remove-service=cockpit >/dev/null 2>&1
	firewall-offline-cmd --remove-service=vdsm >/dev/null 2>&1
	firewall-offline-cmd --remove-service=libvirt >/dev/null 2>&1
	firewall-offline-cmd --remove-service=ssh >/dev/null 2>&1
	systemctl restart firewalld.service >/dev/null 2>&1
fi
# Restarting cockpit to reload the branding data
systemctl restart cockpit.service >/dev/null 2>&1

%files -n ovirt-node-ng-image-update-placeholder

%files -n ovirt-release-host-node
%ghost %attr(0644, root, root) %{_prefix}/lib/os.release.d/%{host_node_release_file}
%dir %{_prefix}/share/ovirt-release-host-node
%dir %{_prefix}/share/ovirt-release-host-node/branding
%{_presetdir}/98-ovirt-host-node.preset
%{_prefix}/share/ovirt-release-host-node/branding/logo.png
%{_prefix}/share/ovirt-release-host-node/branding/bg-login.png
%{_prefix}/share/ovirt-release-host-node/branding/favicon.ico
%{_prefix}/share/ovirt-release-host-node/branding/branding.css

# Add a folder for local datastores
%dir %attr(0755, 36, 36) /data/images/rhev

%changelog
* Fri Sep 15 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.6-2
- Fixed CentOS Virt SIG URL for 4.0 (supported only until CentOS 7.3.1611)
- added dist tag to release
- updated gpg key with current one

* Wed Nov 16 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.6-1
- Bump to 4.0.6

* Wed Sep 28 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.5-1
- Bump to 4.0.5

* Tue Aug 30 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.4-1
- Bump to 4.0.4

* Wed Aug 24 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.3-1
- Bump to 4.0.3

* Wed Jul 20 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.2-2
- Move from CentOS Virt SIG candidate to release

* Wed Jul 20 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.2-1
- Stretched the background image of Node's login page.
- RPM linting

* Tue Jul 12 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.1-1
- Fix python-paramiko renaming in EPEL, Bug #1354336

* Sun Jun 19 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-5
- Fix repo enablement

* Fri Jun 17 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-4
- Enable repos on Node

* Wed Jun 15 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-3
- Preset imgbase-motd to enabled

* Tue Jun 14 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-2
- node: Enable oVirt repos after whitelisting

* Thu Jun  2 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-1
- 4.0.0-1

* Wed May 18 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.3.beta1
- 4.0.0-0.3.beta1

* Tue Apr  5 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.2.alpha1
- 4.0.0-0.2.alpha1

* Fri Mar 11 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.1.prealpha2
- Use ovirt-release-host-node

* Thu Mar 10 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.prealpha2
- 4.0.0-0.0.master
