/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectFieldsStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSelectBaseNode;

public class SVNWCDbSelectBaseNodeWithLock
extends SVNWCDbSelectBaseNode {
    private LockStatement lockStatement;

    public SVNWCDbSelectBaseNodeWithLock(SVNSqlJetDb sDb) throws SVNException {
        super(sDb);
        this.lockStatement = new LockStatement(sDb);
    }

    public boolean next() throws SVNException {
        this.lockStatement.reset();
        boolean next = super.next();
        if (next) {
            this.lockStatement.bindLong(1, this.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id.toString()));
            this.lockStatement.bindString(2, this.getColumnString(SVNWCDbSchema.NODES__Fields.repos_path.toString()));
            this.lockStatement.next();
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SVNException {
        try {
            this.lockStatement.reset();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.reset();
            throw throwable;
        }
        super.reset();
    }

    public SVNSqlJetStatement getJoinedStatement(String joinedTable) throws SVNException {
        if (SVNWCDbSchema.LOCK.toString().equalsIgnoreCase(joinedTable)) {
            return this.lockStatement;
        }
        return super.getJoinedStatement(joinedTable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockStatement
    extends SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.LOCK__Fields> {
        public LockStatement(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.LOCK);
        }

        @Override
        protected void defineFields() {
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_token);
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_owner);
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_comment);
            this.fields.add(SVNWCDbSchema.LOCK__Fields.lock_date);
        }

        @Override
        public boolean isColumnNull(String f) throws SVNException {
            return super.isColumnNull(f);
        }
    }
}

