/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.DiskProfileBuilder;
import org.ovirt.engine.sdk4.builders.HostStorageBuilder;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.OpenStackVolumeTypeBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.builders.SnapshotBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.DiskSnapshotContainer;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskFormat;
import org.ovirt.engine.sdk4.types.DiskInterface;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.DiskSnapshot;
import org.ovirt.engine.sdk4.types.DiskStatus;
import org.ovirt.engine.sdk4.types.DiskStorageType;
import org.ovirt.engine.sdk4.types.HostStorage;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.OpenStackVolumeType;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.QcowVersion;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.ScsiGenericIO;
import org.ovirt.engine.sdk4.types.Snapshot;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class DiskSnapshotBuilder {
    private Boolean active;
    private BigInteger actualSize;
    private String alias;
    private Boolean bootable;
    private String comment;
    private String description;
    private Disk disk;
    private DiskProfile diskProfile;
    private DiskFormat format;
    private String href;
    private String id;
    private String imageId;
    private InstanceType instanceType;
    private DiskInterface interface_;
    private String logicalName;
    private HostStorage lunStorage;
    private String name;
    private OpenStackVolumeType openstackVolumeType;
    private List<Permission> permissions;
    private Boolean propagateErrors;
    private BigInteger provisionedSize;
    private QcowVersion qcowVersion;
    private Quota quota;
    private Boolean readOnly;
    private ScsiGenericIO sgio;
    private Boolean shareable;
    private Snapshot snapshot;
    private Boolean sparse;
    private List<Statistic> statistics;
    private DiskStatus status;
    private StorageDomain storageDomain;
    private List<StorageDomain> storageDomains;
    private DiskStorageType storageType;
    private Template template;
    private Boolean usesScsiReservation;
    private Vm vm;
    private List<Vm> vms;
    private Boolean wipeAfterDelete;

    public DiskSnapshotBuilder active(boolean newActive) {
        this.active = newActive;
        return this;
    }

    public DiskSnapshotBuilder active(Boolean newActive) {
        this.active = newActive;
        return this;
    }

    public DiskSnapshotBuilder actualSize(int newActualSize) {
        this.actualSize = BigInteger.valueOf(newActualSize);
        return this;
    }

    public DiskSnapshotBuilder actualSize(Integer newActualSize) {
        this.actualSize = newActualSize == null ? null : BigInteger.valueOf(newActualSize.longValue());
        return this;
    }

    public DiskSnapshotBuilder actualSize(long newActualSize) {
        this.actualSize = BigInteger.valueOf(newActualSize);
        return this;
    }

    public DiskSnapshotBuilder actualSize(Long newActualSize) {
        this.actualSize = newActualSize == null ? null : BigInteger.valueOf(newActualSize);
        return this;
    }

    public DiskSnapshotBuilder actualSize(BigInteger newActualSize) {
        this.actualSize = newActualSize;
        return this;
    }

    public DiskSnapshotBuilder alias(String newAlias) {
        this.alias = newAlias;
        return this;
    }

    public DiskSnapshotBuilder bootable(boolean newBootable) {
        this.bootable = newBootable;
        return this;
    }

    public DiskSnapshotBuilder bootable(Boolean newBootable) {
        this.bootable = newBootable;
        return this;
    }

    public DiskSnapshotBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public DiskSnapshotBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DiskSnapshotBuilder disk(Disk newDisk) {
        this.disk = newDisk;
        return this;
    }

    public DiskSnapshotBuilder disk(DiskBuilder newDisk) {
        this.disk = newDisk == null ? null : newDisk.build();
        return this;
    }

    public DiskSnapshotBuilder diskProfile(DiskProfile newDiskProfile) {
        this.diskProfile = newDiskProfile;
        return this;
    }

    public DiskSnapshotBuilder diskProfile(DiskProfileBuilder newDiskProfile) {
        this.diskProfile = newDiskProfile == null ? null : newDiskProfile.build();
        return this;
    }

    public DiskSnapshotBuilder format(DiskFormat newFormat) {
        this.format = newFormat;
        return this;
    }

    public DiskSnapshotBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public DiskSnapshotBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public DiskSnapshotBuilder imageId(String newImageId) {
        this.imageId = newImageId;
        return this;
    }

    public DiskSnapshotBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public DiskSnapshotBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public DiskSnapshotBuilder interface_(DiskInterface newInterface) {
        this.interface_ = newInterface;
        return this;
    }

    public DiskSnapshotBuilder logicalName(String newLogicalName) {
        this.logicalName = newLogicalName;
        return this;
    }

    public DiskSnapshotBuilder lunStorage(HostStorage newLunStorage) {
        this.lunStorage = newLunStorage;
        return this;
    }

    public DiskSnapshotBuilder lunStorage(HostStorageBuilder newLunStorage) {
        this.lunStorage = newLunStorage == null ? null : newLunStorage.build();
        return this;
    }

    public DiskSnapshotBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public DiskSnapshotBuilder openstackVolumeType(OpenStackVolumeType newOpenstackVolumeType) {
        this.openstackVolumeType = newOpenstackVolumeType;
        return this;
    }

    public DiskSnapshotBuilder openstackVolumeType(OpenStackVolumeTypeBuilder newOpenstackVolumeType) {
        this.openstackVolumeType = newOpenstackVolumeType == null ? null : newOpenstackVolumeType.build();
        return this;
    }

    public DiskSnapshotBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public DiskSnapshotBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public DiskSnapshotBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public DiskSnapshotBuilder propagateErrors(boolean newPropagateErrors) {
        this.propagateErrors = newPropagateErrors;
        return this;
    }

    public DiskSnapshotBuilder propagateErrors(Boolean newPropagateErrors) {
        this.propagateErrors = newPropagateErrors;
        return this;
    }

    public DiskSnapshotBuilder provisionedSize(int newProvisionedSize) {
        this.provisionedSize = BigInteger.valueOf(newProvisionedSize);
        return this;
    }

    public DiskSnapshotBuilder provisionedSize(Integer newProvisionedSize) {
        this.provisionedSize = newProvisionedSize == null ? null : BigInteger.valueOf(newProvisionedSize.longValue());
        return this;
    }

    public DiskSnapshotBuilder provisionedSize(long newProvisionedSize) {
        this.provisionedSize = BigInteger.valueOf(newProvisionedSize);
        return this;
    }

    public DiskSnapshotBuilder provisionedSize(Long newProvisionedSize) {
        this.provisionedSize = newProvisionedSize == null ? null : BigInteger.valueOf(newProvisionedSize);
        return this;
    }

    public DiskSnapshotBuilder provisionedSize(BigInteger newProvisionedSize) {
        this.provisionedSize = newProvisionedSize;
        return this;
    }

    public DiskSnapshotBuilder qcowVersion(QcowVersion newQcowVersion) {
        this.qcowVersion = newQcowVersion;
        return this;
    }

    public DiskSnapshotBuilder quota(Quota newQuota) {
        this.quota = newQuota;
        return this;
    }

    public DiskSnapshotBuilder quota(QuotaBuilder newQuota) {
        this.quota = newQuota == null ? null : newQuota.build();
        return this;
    }

    public DiskSnapshotBuilder readOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public DiskSnapshotBuilder readOnly(Boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public DiskSnapshotBuilder sgio(ScsiGenericIO newSgio) {
        this.sgio = newSgio;
        return this;
    }

    public DiskSnapshotBuilder shareable(boolean newShareable) {
        this.shareable = newShareable;
        return this;
    }

    public DiskSnapshotBuilder shareable(Boolean newShareable) {
        this.shareable = newShareable;
        return this;
    }

    public DiskSnapshotBuilder snapshot(Snapshot newSnapshot) {
        this.snapshot = newSnapshot;
        return this;
    }

    public DiskSnapshotBuilder snapshot(SnapshotBuilder newSnapshot) {
        this.snapshot = newSnapshot == null ? null : newSnapshot.build();
        return this;
    }

    public DiskSnapshotBuilder sparse(boolean newSparse) {
        this.sparse = newSparse;
        return this;
    }

    public DiskSnapshotBuilder sparse(Boolean newSparse) {
        this.sparse = newSparse;
        return this;
    }

    public DiskSnapshotBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public DiskSnapshotBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public DiskSnapshotBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public DiskSnapshotBuilder status(DiskStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public DiskSnapshotBuilder storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
        return this;
    }

    public DiskSnapshotBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        this.storageDomain = newStorageDomain == null ? null : newStorageDomain.build();
        return this;
    }

    public DiskSnapshotBuilder storageDomains(List<StorageDomain> newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains);
            } else {
                this.storageDomains.addAll(newStorageDomains);
            }
        }
        return this;
    }

    public DiskSnapshotBuilder storageDomains(StorageDomain ... newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains.length);
            }
            Collections.addAll(this.storageDomains, newStorageDomains);
        }
        return this;
    }

    public DiskSnapshotBuilder storageDomains(StorageDomainBuilder ... newStorageDomains) {
        if (newStorageDomains != null) {
            if (this.storageDomains == null) {
                this.storageDomains = new ArrayList<StorageDomain>(newStorageDomains.length);
            }
            for (StorageDomainBuilder builder : newStorageDomains) {
                this.storageDomains.add(builder.build());
            }
        }
        return this;
    }

    public DiskSnapshotBuilder storageType(DiskStorageType newStorageType) {
        this.storageType = newStorageType;
        return this;
    }

    public DiskSnapshotBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public DiskSnapshotBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public DiskSnapshotBuilder usesScsiReservation(boolean newUsesScsiReservation) {
        this.usesScsiReservation = newUsesScsiReservation;
        return this;
    }

    public DiskSnapshotBuilder usesScsiReservation(Boolean newUsesScsiReservation) {
        this.usesScsiReservation = newUsesScsiReservation;
        return this;
    }

    public DiskSnapshotBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public DiskSnapshotBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public DiskSnapshotBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public DiskSnapshotBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public DiskSnapshotBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public DiskSnapshotBuilder wipeAfterDelete(boolean newWipeAfterDelete) {
        this.wipeAfterDelete = newWipeAfterDelete;
        return this;
    }

    public DiskSnapshotBuilder wipeAfterDelete(Boolean newWipeAfterDelete) {
        this.wipeAfterDelete = newWipeAfterDelete;
        return this;
    }

    public DiskSnapshot build() {
        DiskSnapshotContainer container = new DiskSnapshotContainer();
        container.active(this.active);
        container.actualSize(this.actualSize);
        container.alias(this.alias);
        container.bootable(this.bootable);
        container.comment(this.comment);
        container.description(this.description);
        container.disk(this.disk);
        container.diskProfile(this.diskProfile);
        container.format(this.format);
        container.href(this.href);
        container.id(this.id);
        container.imageId(this.imageId);
        container.instanceType(this.instanceType);
        container.interface_(this.interface_);
        container.logicalName(this.logicalName);
        container.lunStorage(this.lunStorage);
        container.name(this.name);
        container.openstackVolumeType(this.openstackVolumeType);
        container.permissions(this.permissions);
        container.propagateErrors(this.propagateErrors);
        container.provisionedSize(this.provisionedSize);
        container.qcowVersion(this.qcowVersion);
        container.quota(this.quota);
        container.readOnly(this.readOnly);
        container.sgio(this.sgio);
        container.shareable(this.shareable);
        container.snapshot(this.snapshot);
        container.sparse(this.sparse);
        container.statistics(this.statistics);
        container.status(this.status);
        container.storageDomain(this.storageDomain);
        container.storageDomains(this.storageDomains);
        container.storageType(this.storageType);
        container.template(this.template);
        container.usesScsiReservation(this.usesScsiReservation);
        container.vm(this.vm);
        container.vms(this.vms);
        container.wipeAfterDelete(this.wipeAfterDelete);
        return container;
    }
}

