/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.OpenStackNetworkBuilder;
import org.ovirt.engine.sdk4.internal.containers.OpenStackSubnetContainer;
import org.ovirt.engine.sdk4.types.OpenStackNetwork;
import org.ovirt.engine.sdk4.types.OpenStackSubnet;

public class OpenStackSubnetBuilder {
    private String cidr;
    private String comment;
    private String description;
    private List<String> dnsServers;
    private String gateway;
    private String href;
    private String id;
    private String ipVersion;
    private String name;
    private OpenStackNetwork openstackNetwork;

    public OpenStackSubnetBuilder cidr(String newCidr) {
        this.cidr = newCidr;
        return this;
    }

    public OpenStackSubnetBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public OpenStackSubnetBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public OpenStackSubnetBuilder dnsServers(List<String> newDnsServers) {
        if (newDnsServers != null) {
            if (this.dnsServers == null) {
                this.dnsServers = new ArrayList<String>(newDnsServers);
            } else {
                this.dnsServers.addAll(newDnsServers);
            }
        }
        return this;
    }

    public OpenStackSubnetBuilder dnsServers(String ... newDnsServers) {
        if (newDnsServers != null) {
            if (this.dnsServers == null) {
                this.dnsServers = new ArrayList<String>(newDnsServers.length);
            }
            Collections.addAll(this.dnsServers, newDnsServers);
        }
        return this;
    }

    public OpenStackSubnetBuilder gateway(String newGateway) {
        this.gateway = newGateway;
        return this;
    }

    public OpenStackSubnetBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public OpenStackSubnetBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public OpenStackSubnetBuilder ipVersion(String newIpVersion) {
        this.ipVersion = newIpVersion;
        return this;
    }

    public OpenStackSubnetBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public OpenStackSubnetBuilder openstackNetwork(OpenStackNetwork newOpenstackNetwork) {
        this.openstackNetwork = newOpenstackNetwork;
        return this;
    }

    public OpenStackSubnetBuilder openstackNetwork(OpenStackNetworkBuilder newOpenstackNetwork) {
        this.openstackNetwork = newOpenstackNetwork == null ? null : newOpenstackNetwork.build();
        return this;
    }

    public OpenStackSubnet build() {
        OpenStackSubnetContainer container = new OpenStackSubnetContainer();
        container.cidr(this.cidr);
        container.comment(this.comment);
        container.description(this.description);
        container.dnsServers(this.dnsServers);
        container.gateway(this.gateway);
        container.href(this.href);
        container.id(this.id);
        container.ipVersion(this.ipVersion);
        container.name(this.name);
        container.openstackNetwork(this.openstackNetwork);
        return container;
    }
}

