/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.GlusterMemoryPool;

public class GlusterMemoryPoolContainer extends IdentifiedContainer implements GlusterMemoryPool {
    private BigInteger allocCount;
    private BigInteger coldCount;
    private BigInteger hotCount;
    private BigInteger maxAlloc;
    private BigInteger maxStdalloc;
    private BigInteger paddedSize;
    private BigInteger poolMisses;
    private String type;
    
    public BigInteger allocCount() {
        return allocCount;
    }
    
    public void allocCount(BigInteger newAllocCount) {
        allocCount = newAllocCount;
    }
    
    public boolean allocCountPresent() {
        return allocCount != null;
    }
    
    public BigInteger coldCount() {
        return coldCount;
    }
    
    public void coldCount(BigInteger newColdCount) {
        coldCount = newColdCount;
    }
    
    public boolean coldCountPresent() {
        return coldCount != null;
    }
    
    public BigInteger hotCount() {
        return hotCount;
    }
    
    public void hotCount(BigInteger newHotCount) {
        hotCount = newHotCount;
    }
    
    public boolean hotCountPresent() {
        return hotCount != null;
    }
    
    public BigInteger maxAlloc() {
        return maxAlloc;
    }
    
    public void maxAlloc(BigInteger newMaxAlloc) {
        maxAlloc = newMaxAlloc;
    }
    
    public boolean maxAllocPresent() {
        return maxAlloc != null;
    }
    
    public BigInteger maxStdalloc() {
        return maxStdalloc;
    }
    
    public void maxStdalloc(BigInteger newMaxStdalloc) {
        maxStdalloc = newMaxStdalloc;
    }
    
    public boolean maxStdallocPresent() {
        return maxStdalloc != null;
    }
    
    public BigInteger paddedSize() {
        return paddedSize;
    }
    
    public void paddedSize(BigInteger newPaddedSize) {
        paddedSize = newPaddedSize;
    }
    
    public boolean paddedSizePresent() {
        return paddedSize != null;
    }
    
    public BigInteger poolMisses() {
        return poolMisses;
    }
    
    public void poolMisses(BigInteger newPoolMisses) {
        poolMisses = newPoolMisses;
    }
    
    public boolean poolMissesPresent() {
        return poolMisses != null;
    }
    
    public String type() {
        return type;
    }
    
    public void type(String newType) {
        type = newType;
    }
    
    public boolean typePresent() {
        return type != null;
    }
    
}
