/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.IconContainer;
import org.ovirt.engine.sdk4.types.Icon;

public class XmlIconReader {
    public static Icon readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        IconContainer object = new IconContainer();
        block24: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block24;
                }
                case "id": {
                    object.id(image);
                    continue block24;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block25: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block25;
                }
                case "data": {
                    object.data(reader.readString());
                    continue block25;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block25;
                }
                case "media_type": {
                    object.mediaType(reader.readString());
                    continue block25;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block25;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block25;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlIconReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Icon> iterateMany(final XmlReader reader) {
        return new Iterator<Icon>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Icon next() {
                Icon next = XmlIconReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Icon> readMany(XmlReader reader) {
        ArrayList<Icon> list = new ArrayList<Icon>();
        Iterator<Icon> iterator = XmlIconReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(IconContainer object, String[] link) {
    }
}

