# Copyright (C) 2017 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%global         package_version 1.0.4.2

%global metrics_data %{_datadir}/ovirt-engine-metrics
%global metrics_etc %{_sysconfdir}/ovirt-engine-metrics

%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	BUILD_VALIDATION=0

Summary:        oVirt Engine Metrics
Name:           ovirt-engine-metrics
Version:        1.0.4.2
Release:        1%{?release_suffix}%{?dist}
Source0:        http://resources.ovirt.org/pub/src/ovirt-engine-metrics/ovirt-engine-metrics-1.0.4.2.tar.gz
License:        ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires:       ovirt-engine
Requires:	ovirt-engine-setup-plugin-ovirt-engine-common >= 4.1
Requires:	ovirt-engine-setup-plugin-ovirt-engine >= 4.1
Requires:	ansible >= 2.2.0

# In oVirt 4.1.0, content of this package was in a different one, which was
# built from the engine sources.
Obsoletes:	ovirt-engine-hosts-ansible-inventory
Provides:	ovirt-engine-hosts-ansible-inventory

%description
ovirt-engine-metrics allows configuring an oVirt installation to send metrics
data to a remote fluentd/elasticsearch store.

%prep
%setup -c -q

%build
make %{make_common_opts}

%install
make %{make_common_opts} install DESTDIR="%{buildroot}"

%clean
rm -rf %{buildroot}

%files
%license LICENSE
%{metrics_data}/setup/bin
%{metrics_data}/setup/ansible
%{metrics_etc}
%doc README.md

%changelog
* Wed Jun 07 2017 Shirly Radco <sradco@redhat.com> - 1.0.4.2
Fixed issues:
- Bug 1459425 - fluentd: parse engine.log time as iso8601

* Tue Jun 06 2017 Shirly Radco <sradco@redhat.com> - 1.0.4.1
Fixed issues:
- Bug 1459015 - fluentd: added keep_time_key to the logs parser

* Mon Jun 05 2017 Shirly Radco <sradco@redhat.com> - 1.0.4
Fixed issues:
- Bug 1429861 - Pass engine db credentials to collectd-postgresql
- Bug 1429861 - create_collectd_pg_pass.sh: Fix path for selinux fcontext
- Bug 1456238 - fluentd: added ipv4 and ipv6 to records
- Bug 1434575 - fluentd:update hosts and engine to use nest plugin
- Bug 1434315 - fluentd: added post processing for all records
- Bug 1458682 - Exit and notify the user config.yml is missing
- Bug 1418659 - fluentd:added engine.log to the fluentd configuration

* Tue Apr 25 2017 Shirly Radco <sradco@redhat.com> - 1.0.3
Fixed issues:
- Bug 1439536 - fluentd:fixed hosts.elapsed_time type_instance
- Bug 1439544 - fluentd:fixed parsing of statsd hosts nics and storage
- fluentd: added prefix to the statsd value field
- Bug 1438863 - collectd: Fixed processes plugin configurations
- Bug 1435993 - collectd: updated engine processes plugin


* Tue Apr 04 2017 Shirly Radco <sradco@redhat.com> - 1.0.2
Fixed issues:
- Bug 1434836 - fixed bug in statsd parsing
- Bug 1436087 - update the postgresql plugin queries
- Bug 1436001 - move postgresql plugin to a separate file
- Bug 1429875 - move apache plugin to a separate file

* Tue Mar 21 2017 Shirly Radco <sradco@redhat.com> - 1.0.1
Fixed issues:
- Bug 1410044 - Support configuring collectd/fluentd on the engine
- Bug 1424997 - fluentd:update hosts and engine ovirt-processing.conf
- Bug 1434570 - collectd: load postgresql plugin on engine machine
- Bug 1434573 - collectd: load apache plugin

* Sun Feb 12 2017 Shirly Radco <sradco@redhat.com> - 1.0.0-0.0.master
- initial packaging

