#
# ovirt-hosted-engine-ha -- ovirt hosted engine high availability
# Copyright (C) 2013-2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%define enable_tests 1

%global         package_version 2.1.4
%global         package_name ovirt-hosted-engine-ha
%global         engine_ha_bindir  /usr/share/ovirt-hosted-engine-ha
%global         engine_ha_confdir /etc/ovirt-hosted-engine-ha
%global         engine_ha_libdir  %{python_sitelib}/ovirt_hosted_engine_ha
%global         engine_ha_logdir  /var/log/ovirt-hosted-engine-ha
%global         engine_ha_rundir  /var/run/ovirt-hosted-engine-ha
%global         engine_ha_statedir /var/lib/ovirt-hosted-engine-ha

%global         vdsm_user vdsm
%global         vdsm_group kvm
%global         vdsm_version 4.19.6

Summary:        oVirt Hosted Engine High Availability Manager
Name:           ovirt-hosted-engine-ha
Version:        2.1.4
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildArch:      noarch

Requires:       python
Requires:       python-daemon
Requires:       sanlock >= 2.8
Requires:       sanlock-python >= 2.8
Requires:       sudo
Requires(pre):  vdsm >= %{vdsm_version}
Requires(post): vdsm >= %{vdsm_version}
Requires:       vdsm >= %{vdsm_version}
Requires:       vdsm-client >= %{vdsm_version}
Requires:       vdsm-python >= %{vdsm_version}

# Otopi is needed for the cli client
Requires:       otopi >= 1.6.0

BuildRequires:  python
BuildRequires:  python2-devel
BuildRequires:  python-mock

%if 0%{?enable_tests}
BuildRequires:  python-nose
BuildRequires:  vdsm >= %{vdsm_version}
BuildRequires:  vdsm-client >= %{vdsm_version}
BuildRequires:  vdsm-python >= %{vdsm_version}
%endif

%{?systemd_requires}
BuildRequires:  systemd

%description
Hosted engine manager for oVirt project.


%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%if 0%{?enable_tests}
%check
make test
%endif

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

install -dDm 0700 %{buildroot}%{engine_ha_logdir}

#FIXME: ovirt-hosted-engine-ha.noarch:
# E: dir-or-file-in-var-run /var/run/ovirt-hosted-engine-ha
# A file in the package is located in /var/run. It's not permitted for packages
# to install files in this directory.
# See http://fedoraproject.org/wiki/Packaging:Tmpfiles.d

install -dDm 0700 %{buildroot}%{engine_ha_rundir}
install -dDm 0700 %{buildroot}%{engine_ha_statedir}
# Install the systemd scripts
install -Dm 0644 initscripts/ovirt-ha-agent.service %{buildroot}%{_unitdir}/ovirt-ha-agent.service
install -Dm 0644 initscripts/ovirt-ha-broker.service %{buildroot}%{_unitdir}/ovirt-ha-broker.service

install -dDm 0750 %{buildroot}%{_sysconfdir}/sudoers.d
install -Dm 0440 sudoers/sudoers %{buildroot}%{_sysconfdir}/sudoers.d/60_ovirt-ha

%files
%license COPYING
%doc README
%doc doc/*.html doc/*.js

%dir %{engine_ha_confdir}
%config(noreplace) %{engine_ha_confdir}/agent-log.conf
%config(noreplace) %{engine_ha_confdir}/agent.conf
%config(noreplace) %{engine_ha_confdir}/broker-log.conf

%dir %{engine_ha_confdir}/notifications
%config(noreplace) %{engine_ha_confdir}/notifications/*

%dir %{engine_ha_bindir}
%{engine_ha_bindir}/ovirt-ha-agent
%{engine_ha_bindir}/ovirt-ha-broker

%dir %{engine_ha_libdir}
%{engine_ha_libdir}/*
%{_unitdir}/ovirt-ha-agent.service
%{_unitdir}/ovirt-ha-broker.service

%config(noreplace) %{_sysconfdir}/sudoers.d/60_ovirt-ha


%defattr(-, %{vdsm_user}, %{vdsm_group}, -)
%dir %{engine_ha_logdir}
%ghost %dir %{engine_ha_rundir}

%dir %{engine_ha_statedir}
%config(noreplace) %{engine_ha_statedir}/ha.conf
%config(noreplace) %{engine_ha_statedir}/broker.conf

%post
# Fix answerfile ownership for upgrade purposes: if the configuration volume
# is still not on the shared storage (upgrading from 3.5 time), ovirt-ha-agent
# is going to create it uploading local files.
# ovirt-ha-agent runs as vdsm user so we have to be sure it could read the
# initial answerfile.
if [ -e %{_sysconfdir}/ovirt-hosted-engine/answers.conf ] ; then
    chown root:kvm %{_sysconfdir}/ovirt-hosted-engine/answers.conf
fi
# Copy previous broker.conf on upgrade path
if [ $1 -gt 1 ] ; then
    if [ -e "%{engine_ha_confdir}/broker.conf" ]; then
            cp "%{engine_ha_confdir}/broker.conf" "%{engine_ha_statedir}/broker.conf"
            chown %{vdsm_user}:%{vdsm_group}  "%{engine_ha_statedir}/broker.conf"
    fi
fi
%systemd_post ovirt-ha-agent.service
%systemd_post ovirt-ha-broker.service
if [ "$1" -eq 1 ] ; then
#We don't want the service to be started by default before the system
#is configured and Hosted Engine VM deployed
    /usr/bin/systemctl --no-reload disable ovirt-ha-agent.service
    /usr/bin/systemctl --no-reload disable ovirt-ha-broker.service
fi


%preun
%systemd_preun ovirt-ha-agent.service
%systemd_preun ovirt-ha-broker.service



%postun
%systemd_postun_with_restart ovirt-ha-agent.service
%systemd_postun_with_restart ovirt-ha-broker.service


%changelog
* Wed Jun 21 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.1.4-1
- 2.1.4-1

* Wed Jun 14 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.1.4-0.0.master
- 2.1.4-0.0.master

* Wed Jun 14 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.1.3-1
- 2.1.3-1

* Wed Jun  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.1.3-0.0.master
- 2.1.3-0.0.master

* Wed Jun  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 2.1.2-1
- 2.1.2-1

* Thu May 25 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.2-0.0.master
- 2.1.2-0.0.master

* Thu May 25 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.1-1
- 2.1.1-1

* Fri Apr 21 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.1-0.0.master
- 2.1.1-0.0.master

* Fri Apr 21 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.6-1
- 2.1.0.6-1

* Tue Mar 21 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.6-0.0.master
- 2.1.0.6-0.0.master

* Tue Mar 21 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.5-1
- 2.1.0.5-1

* Wed Mar  1 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.5-0.0.master
- 2.1.0.5-0.0.master

* Wed Mar  1 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.4-1
- 2.1.0.4-1

* Wed Feb 15 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.4-0.0.master
- 2.1.0.4-0.0.master

* Wed Feb 15 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.3-1
- 2.1.0.3-1

* Thu Feb 09 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.3-0.0.master
- 2.1.0.3-0.0.master

* Thu Feb 09 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.2-1
- 2.1.0.2-1

* Wed Jan 25 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.2-0.0.master
- 2.1.0.2-0.0.master

* Wed Jan 25 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.1-1
- 2.1.0.1-1

* Fri Jan 13 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0.1-0.0.master
- 2.1.0.1-0.0.master

* Fri Jan 13 2017 Simone Tiraboschi <stirabos@redhat.com> - 2.1.0-1
- 2.1.0-1

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-1
- 2.0.0-1

* Wed May 18 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0-0.2.master
- 2.0.0-0.2.master

* Wed May 18 2016 Simone Tiraboschi <stirabos@redhat.com> - 2.0.0-0.1.beta1
- 2.0.0-0.1.beta1

* Thu Sep 24 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 2.0.0-0.0.master
- 2.0.0-0.0.master
