/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNDiffStatusEditor
implements ISVNEditor {
    private SVNSummarize myCurrentDirSummarize;
    private SVNSummarize myCurrentFileSummarize;
    private SVNRepository myRepository;
    private ISVNDiffStatusHandler myHandler;
    private long myRevision;
    private SVNURL myRootURL;
    private File myAnchor;
    private String myTarget;

    public SVNDiffStatusEditor(File anchor, String target, SVNRepository repos, long revision, ISVNDiffStatusHandler handler) {
        this.myRepository = repos;
        this.myHandler = handler;
        this.myRevision = revision;
        this.myRootURL = repos.getLocation();
        this.myAnchor = anchor;
        this.myTarget = target;
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirSummarize = new SVNSummarize(null, "", SVNNodeKind.DIR);
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNNodeKind kind = this.myRepository.checkPath(path, this.myRevision);
        String statusPath = this.getStatusPath(path);
        SVNDiffStatus status = new SVNDiffStatus(this.myAnchor != null ? new File(this.myAnchor, path) : null, this.myRootURL.appendPath(path, false), statusPath, SVNStatusType.STATUS_DELETED, false, kind);
        this.myHandler.handleDiffStatus(status);
        if (kind == SVNNodeKind.DIR) {
            this.diffDeletedDir(path);
        }
    }

    private void diffDeletedDir(String path) throws SVNException {
        Collection<SVNDirEntry> entries = this.myRepository.getDir(path, this.myRevision, null, 1, (Collection)null);
        for (SVNDirEntry entry : entries) {
            String name = entry.getName();
            if ("".equals(name)) continue;
            String entryPath = SVNPathUtil.append(path, name);
            String statusPath = this.getStatusPath(entryPath);
            SVNDiffStatus status = new SVNDiffStatus(this.myAnchor != null ? new File(this.myAnchor, entryPath) : null, this.myRootURL.appendPath(entryPath, false), statusPath, SVNStatusType.STATUS_DELETED, false, entry.getKind());
            this.myHandler.handleDiffStatus(status);
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            this.diffDeletedDir(entryPath);
        }
    }

    private String getStatusPath(String path) {
        String statusPath = path;
        if (this.myTarget != null && (path.equals(this.myTarget) || path.startsWith(this.myTarget + "/"))) {
            statusPath = SVNPathUtil.removeHead(path);
        }
        if (statusPath.startsWith("/")) {
            statusPath = statusPath.substring(1);
        }
        return statusPath;
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirSummarize = new SVNSummarize(this.myCurrentDirSummarize, path, SVNNodeKind.DIR);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentDirSummarize = new SVNSummarize(this.myCurrentDirSummarize, path, SVNNodeKind.DIR);
        this.myCurrentDirSummarize.myType = SVNStatusType.STATUS_ADDED;
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isRegularProperty(name) && this.myCurrentDirSummarize.myType != SVNStatusType.STATUS_ADDED) {
            this.myCurrentDirSummarize.myPropChanged = true;
        }
    }

    public void closeDir() throws SVNException {
        this.myHandler.handleDiffStatus(this.myCurrentDirSummarize.toStatus());
        this.myCurrentDirSummarize = this.myCurrentDirSummarize.myParent;
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFileSummarize = new SVNSummarize(this.myCurrentDirSummarize, path, SVNNodeKind.FILE);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFileSummarize = new SVNSummarize(this.myCurrentDirSummarize, path, SVNNodeKind.FILE);
        this.myCurrentFileSummarize.myType = SVNStatusType.STATUS_ADDED;
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isRegularProperty(name) && this.myCurrentFileSummarize.myType != SVNStatusType.STATUS_ADDED) {
            this.myCurrentFileSummarize.myPropChanged = true;
        }
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (this.myCurrentFileSummarize.myType != SVNStatusType.STATUS_ADDED) {
            this.myCurrentFileSummarize.myType = SVNStatusType.STATUS_MODIFIED;
        }
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return null;
    }

    public void textDeltaEnd(String path) throws SVNException {
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.myHandler.handleDiffStatus(this.myCurrentFileSummarize.toStatus());
        this.myCurrentFileSummarize = null;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myCurrentDirSummarize != null) {
            this.myHandler.handleDiffStatus(this.myCurrentDirSummarize.toStatus());
        }
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    private class SVNSummarize {
        private File myFile;
        private String myPath;
        private SVNNodeKind myKind;
        private SVNStatusType myType;
        private boolean myPropChanged;
        private SVNSummarize myParent;

        public SVNSummarize(SVNSummarize parent, String path, SVNNodeKind kind) {
            this.myKind = kind;
            this.myType = SVNStatusType.STATUS_NONE;
            this.myParent = parent;
            this.myFile = SVNDiffStatusEditor.this.myAnchor != null ? new File(SVNDiffStatusEditor.this.myAnchor, path) : null;
            this.myPath = SVNDiffStatusEditor.this.getStatusPath(path);
        }

        public SVNDiffStatus toStatus() throws SVNException {
            return new SVNDiffStatus(this.myFile, SVNDiffStatusEditor.this.myRootURL.appendPath(this.myPath, false), this.myPath, this.myType, this.myPropChanged, this.myKind);
        }
    }
}

