/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageConnectionExtensionBuilder;
import org.ovirt.engine.sdk4.types.StorageConnectionExtension;

public interface StorageServerConnectionExtensionsService extends Service {
    /**
     * Creates a new storage server connection extension for the given host.
     * 
     * The extension lets the user define credentials for an iSCSI target for a specific host. For example to use
     * `myuser` and `mypassword` as the credentials when connecting to the iSCSI target from host `123` send a request
     * like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/hosts/123/storageconnectionextensions
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <storage_connection_extension>
     *   <target>iqn.2016-01.com.example:mytarget</target>
     *   <username>myuser</username>
     *   <password>mypassword</password>
     * </storage_connection_extension>
     * ----
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest extension(StorageConnectionExtension extension);
        AddRequest extension(StorageConnectionExtensionBuilder extension);
    }
    
    /**
     * Creates a new storage server connection extension for the given host.
     * 
     * The extension lets the user define credentials for an iSCSI target for a specific host. For example to use
     * `myuser` and `mypassword` as the credentials when connecting to the iSCSI target from host `123` send a request
     * like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/hosts/123/storageconnectionextensions
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <storage_connection_extension>
     *   <target>iqn.2016-01.com.example:mytarget</target>
     *   <username>myuser</username>
     *   <password>mypassword</password>
     * </storage_connection_extension>
     * ----
     */
    public interface AddResponse extends Response {
        StorageConnectionExtension extension();
    }
    
    /**
     * Creates a new storage server connection extension for the given host.
     * 
     * The extension lets the user define credentials for an iSCSI target for a specific host. For example to use
     * `myuser` and `mypassword` as the credentials when connecting to the iSCSI target from host `123` send a request
     * like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/hosts/123/storageconnectionextensions
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <storage_connection_extension>
     *   <target>iqn.2016-01.com.example:mytarget</target>
     *   <username>myuser</username>
     *   <password>mypassword</password>
     * </storage_connection_extension>
     * ----
     */
    AddRequest add();
    
    /**
     * Returns the list os storage connection extensions.
     * 
     * The order of the returned list of storage connections isn't guaranteed.
     */
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Sets the maximum number of extensions to return. If not specified all the extensions are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of extensions to return. If not specified all the extensions are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of extensions to return. If not specified all the extensions are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    /**
     * Returns the list os storage connection extensions.
     * 
     * The order of the returned list of storage connections isn't guaranteed.
     */
    public interface ListResponse extends Response {
        List<StorageConnectionExtension> extensions();
    }
    
    /**
     * Returns the list os storage connection extensions.
     * 
     * The order of the returned list of storage connections isn't guaranteed.
     */
    ListRequest list();
    
    StorageServerConnectionExtensionService storageConnectionExtensionService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

