%global rolename cluster-upgrade
%global roleprefix oVirt.
%global roleprefix_legacy ovirt-
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-cluster-upgrade
Summary: Ansible role to upgrade cluster of hosts in oVirt
Version: 1.1.5
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-cluster-upgrade/ovirt-ansible-cluster-upgrade-1.1.5.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.4

%description
This Ansible role provide funtionality to upgrade cluster of hosts in oVirt engine,
using oVirt engine API.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}"
st = posix.stat(path)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Wed Feb 14 2018 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Add use_maintenance_policy parameter rhbz#1539761.
- Add new reboot_after_upgrade parameter rhbz#1539774.
- Fail the role if any host fail to upgrade rhbz#1539776.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Support ovirt_auth with env params.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Add %pretrans scriplet to remove legacy role name.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Rename ovirt. to oVirt. to sync with galaxy.

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.0-1
- Initial release
