oVirt Disaster Recovery
=========

The `oVirt.disaster-recovery` role responsible to manage the disaster recovery scenarios in oVirt.

Requirements
------------

 * Ansible version 2.5 or higher
 * Python SDK version 4.2.4 or higher

Role Variables
--------------

| Name                    | Default value         |                                                     |
|-------------------------|-----------------------|-----------------------------------------------------|
| dr_ignore_error_clean   | False                 | Specify whether to ignore errors on clean engine setup.<br/>This is mainly being used to avoid failures when trying to move a storage domain to maintenance/detach it.      |
| dr_ignore_error_recover | True                  | Specify whether to ignore errors on recover.      |
| dr_partial_import       | True                  | Specify whether to use the partial import flag on VM/Template register.<br/>If True, VMs and Templates will be registered without any missing disks, if false VMs/Templates will fail to be registered in case some of their disks will be missing from any of the storage domains.      |
| dr_target_host          | secondary             | Specify the default target host to be used in the ansible play.<br/> This host indicates the target site which the recover process will bedone.      |
| dr_source_map           | primary               | Specify the default source map to be used in the play.</br/> The source map indicates the key which is used to get the target value for each attribute which we want to register with the VM/Template.       |
| dr_reset_mac_pool       | True                  | If true, then once a VM will be registered, it will automatically reset the mac pool, if configured in the VM.        |
| dr_cleanup_retries_maintenance       | 3                  | Specify the number of retries of moving a storage domain to maintenace VM as part of a fail back scenario.       |
| dr_cleanup_delay_maintenance       | 120                  | Specify the number of seconds between each retry as part of a fail back scenario.       |
| dr_clean_orphaned_vms:       | True                  | Specify whether to remove any VMs which have no disks from the setup as part of cleanup.       |
| dr_clean_orphaned_disks:       | True                  | Specify whether to remove lun disks from the setup as part of engine setup.       |


Dependencies
------------

No.

Example Playbook
----------------

```yaml
---
- name: Setup oVirt environment
  hosts: localhost
  connection: local
  vars_files:
     - ovirt_passwords.yml
     - disaster_recovery_vars.yml
  roles:
     - {role: oVirt.disaster-recovery}
```

Generate var file mapping [demo](https://youtu.be/s1-Hq_Mk1w8)<br/>
Fail over scenario [demo](https://youtu.be/mEOgH-Tk09c)

Scripts
-------
The ovirt-dr script should provide the user a more convinient way to run
disaster recovery actions as a way to avoid using ansible playbooks directly.
There are four actions which the user can execute:
  validate	validate the var file mapping which is used for failover and failback
  generate	Generate the mapping var file based on the primary and secondary setup, to be used for failover and failback
  failover	Start a failover process to the target setup
  failback	Start a failback process from the target setup to the source setup

Each of those actions is using a configuration file which its default location is oVirt.disaster-recovery/files/dr.conf

Example Script
--------------
For mapping file generation:
  ./ovirt-dr generate
For mapping file validation:
  ./ovirt-dr validate
For fail-over operation:
  ./ovirt-dr failover
For fail-back operation:
  ./ovirt-dr failback

License
-------

Apache License 2.0

