/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TransportType {
    RDMA("rdma"),
    TCP("tcp");

    private static final Logger log;
    private String image;

    private TransportType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static TransportType fromValue(String value) {
        try {
            return TransportType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'TransportType' enumerated type. Valid values are 'rdma' and 'tcp'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(TransportType.class);
    }
}

