/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1CloudInitConfigDriveSource;
import kubevirt.io.V1CloudInitNoCloudSource;
import kubevirt.io.V1ConfigMapVolumeSource;
import kubevirt.io.V1ContainerDiskSource;
import kubevirt.io.V1DataVolumeSource;
import kubevirt.io.V1EmptyDiskSource;
import kubevirt.io.V1EphemeralVolumeSource;
import kubevirt.io.V1HostDisk;
import kubevirt.io.V1PersistentVolumeClaimVolumeSource;
import kubevirt.io.V1SecretVolumeSource;
import kubevirt.io.V1ServiceAccountVolumeSource;

/**
 * Volume represents a named volume in a vmi.
 */
@ApiModel(description = "Volume represents a named volume in a vmi.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Volume {
  @SerializedName("cloudInitConfigDrive")
  private V1CloudInitConfigDriveSource cloudInitConfigDrive = null;

  @SerializedName("cloudInitNoCloud")
  private V1CloudInitNoCloudSource cloudInitNoCloud = null;

  @SerializedName("configMap")
  private V1ConfigMapVolumeSource configMap = null;

  @SerializedName("containerDisk")
  private V1ContainerDiskSource containerDisk = null;

  @SerializedName("dataVolume")
  private V1DataVolumeSource dataVolume = null;

  @SerializedName("emptyDisk")
  private V1EmptyDiskSource emptyDisk = null;

  @SerializedName("ephemeral")
  private V1EphemeralVolumeSource ephemeral = null;

  @SerializedName("hostDisk")
  private V1HostDisk hostDisk = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("persistentVolumeClaim")
  private V1PersistentVolumeClaimVolumeSource persistentVolumeClaim = null;

  @SerializedName("secret")
  private V1SecretVolumeSource secret = null;

  @SerializedName("serviceAccount")
  private V1ServiceAccountVolumeSource serviceAccount = null;

  public V1Volume cloudInitConfigDrive(V1CloudInitConfigDriveSource cloudInitConfigDrive) {
    this.cloudInitConfigDrive = cloudInitConfigDrive;
    return this;
  }

   /**
   * CloudInitConfigDrive represents a cloud-init Config Drive user-data source. The Config Drive data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html +optional
   * @return cloudInitConfigDrive
  **/
  @ApiModelProperty(value = "CloudInitConfigDrive represents a cloud-init Config Drive user-data source. The Config Drive data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html +optional")
  public V1CloudInitConfigDriveSource getCloudInitConfigDrive() {
    return cloudInitConfigDrive;
  }

  public void setCloudInitConfigDrive(V1CloudInitConfigDriveSource cloudInitConfigDrive) {
    this.cloudInitConfigDrive = cloudInitConfigDrive;
  }

  public V1Volume cloudInitNoCloud(V1CloudInitNoCloudSource cloudInitNoCloud) {
    this.cloudInitNoCloud = cloudInitNoCloud;
    return this;
  }

   /**
   * CloudInitNoCloud represents a cloud-init NoCloud user-data source. The NoCloud data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html +optional
   * @return cloudInitNoCloud
  **/
  @ApiModelProperty(value = "CloudInitNoCloud represents a cloud-init NoCloud user-data source. The NoCloud data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html +optional")
  public V1CloudInitNoCloudSource getCloudInitNoCloud() {
    return cloudInitNoCloud;
  }

  public void setCloudInitNoCloud(V1CloudInitNoCloudSource cloudInitNoCloud) {
    this.cloudInitNoCloud = cloudInitNoCloud;
  }

  public V1Volume configMap(V1ConfigMapVolumeSource configMap) {
    this.configMap = configMap;
    return this;
  }

   /**
   * ConfigMapSource represents a reference to a ConfigMap in the same namespace. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/ +optional
   * @return configMap
  **/
  @ApiModelProperty(value = "ConfigMapSource represents a reference to a ConfigMap in the same namespace. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/ +optional")
  public V1ConfigMapVolumeSource getConfigMap() {
    return configMap;
  }

  public void setConfigMap(V1ConfigMapVolumeSource configMap) {
    this.configMap = configMap;
  }

  public V1Volume containerDisk(V1ContainerDiskSource containerDisk) {
    this.containerDisk = containerDisk;
    return this;
  }

   /**
   * ContainerDisk references a docker image, embedding a qcow or raw disk. More info: https://kubevirt.gitbooks.io/user-guide/registry-disk.html +optional
   * @return containerDisk
  **/
  @ApiModelProperty(value = "ContainerDisk references a docker image, embedding a qcow or raw disk. More info: https://kubevirt.gitbooks.io/user-guide/registry-disk.html +optional")
  public V1ContainerDiskSource getContainerDisk() {
    return containerDisk;
  }

  public void setContainerDisk(V1ContainerDiskSource containerDisk) {
    this.containerDisk = containerDisk;
  }

  public V1Volume dataVolume(V1DataVolumeSource dataVolume) {
    this.dataVolume = dataVolume;
    return this;
  }

   /**
   * DataVolume represents the dynamic creation a PVC for this volume as well as the process of populating that PVC with a disk image. +optional
   * @return dataVolume
  **/
  @ApiModelProperty(value = "DataVolume represents the dynamic creation a PVC for this volume as well as the process of populating that PVC with a disk image. +optional")
  public V1DataVolumeSource getDataVolume() {
    return dataVolume;
  }

  public void setDataVolume(V1DataVolumeSource dataVolume) {
    this.dataVolume = dataVolume;
  }

  public V1Volume emptyDisk(V1EmptyDiskSource emptyDisk) {
    this.emptyDisk = emptyDisk;
    return this;
  }

   /**
   * EmptyDisk represents a temporary disk which shares the vmis lifecycle. More info: https://kubevirt.gitbooks.io/user-guide/disks-and-volumes.html +optional
   * @return emptyDisk
  **/
  @ApiModelProperty(value = "EmptyDisk represents a temporary disk which shares the vmis lifecycle. More info: https://kubevirt.gitbooks.io/user-guide/disks-and-volumes.html +optional")
  public V1EmptyDiskSource getEmptyDisk() {
    return emptyDisk;
  }

  public void setEmptyDisk(V1EmptyDiskSource emptyDisk) {
    this.emptyDisk = emptyDisk;
  }

  public V1Volume ephemeral(V1EphemeralVolumeSource ephemeral) {
    this.ephemeral = ephemeral;
    return this;
  }

   /**
   * Ephemeral is a special volume source that \&quot;wraps\&quot; specified source and provides copy-on-write image on top of it. +optional
   * @return ephemeral
  **/
  @ApiModelProperty(value = "Ephemeral is a special volume source that \"wraps\" specified source and provides copy-on-write image on top of it. +optional")
  public V1EphemeralVolumeSource getEphemeral() {
    return ephemeral;
  }

  public void setEphemeral(V1EphemeralVolumeSource ephemeral) {
    this.ephemeral = ephemeral;
  }

  public V1Volume hostDisk(V1HostDisk hostDisk) {
    this.hostDisk = hostDisk;
    return this;
  }

   /**
   * HostDisk represents a disk created on the cluster level +optional
   * @return hostDisk
  **/
  @ApiModelProperty(value = "HostDisk represents a disk created on the cluster level +optional")
  public V1HostDisk getHostDisk() {
    return hostDisk;
  }

  public void setHostDisk(V1HostDisk hostDisk) {
    this.hostDisk = hostDisk;
  }

  public V1Volume name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Volume&#39;s name. Must be a DNS_LABEL and unique within the vmi. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
   * @return name
  **/
  @ApiModelProperty(required = true, value = "Volume's name. Must be a DNS_LABEL and unique within the vmi. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public V1Volume persistentVolumeClaim(V1PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    this.persistentVolumeClaim = persistentVolumeClaim;
    return this;
  }

   /**
   * PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. Directly attached to the vmi via qemu. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims +optional
   * @return persistentVolumeClaim
  **/
  @ApiModelProperty(value = "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. Directly attached to the vmi via qemu. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims +optional")
  public V1PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
    return persistentVolumeClaim;
  }

  public void setPersistentVolumeClaim(V1PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    this.persistentVolumeClaim = persistentVolumeClaim;
  }

  public V1Volume secret(V1SecretVolumeSource secret) {
    this.secret = secret;
    return this;
  }

   /**
   * SecretVolumeSource represents a reference to a secret data in the same namespace. More info: https://kubernetes.io/docs/concepts/configuration/secret/ +optional
   * @return secret
  **/
  @ApiModelProperty(value = "SecretVolumeSource represents a reference to a secret data in the same namespace. More info: https://kubernetes.io/docs/concepts/configuration/secret/ +optional")
  public V1SecretVolumeSource getSecret() {
    return secret;
  }

  public void setSecret(V1SecretVolumeSource secret) {
    this.secret = secret;
  }

  public V1Volume serviceAccount(V1ServiceAccountVolumeSource serviceAccount) {
    this.serviceAccount = serviceAccount;
    return this;
  }

   /**
   * ServiceAccountVolumeSource represents a reference to a service account. There can only be one volume of this type! More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/ +optional
   * @return serviceAccount
  **/
  @ApiModelProperty(value = "ServiceAccountVolumeSource represents a reference to a service account. There can only be one volume of this type! More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/ +optional")
  public V1ServiceAccountVolumeSource getServiceAccount() {
    return serviceAccount;
  }

  public void setServiceAccount(V1ServiceAccountVolumeSource serviceAccount) {
    this.serviceAccount = serviceAccount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Volume v1Volume = (V1Volume) o;
    return Objects.equals(this.cloudInitConfigDrive, v1Volume.cloudInitConfigDrive) &&
        Objects.equals(this.cloudInitNoCloud, v1Volume.cloudInitNoCloud) &&
        Objects.equals(this.configMap, v1Volume.configMap) &&
        Objects.equals(this.containerDisk, v1Volume.containerDisk) &&
        Objects.equals(this.dataVolume, v1Volume.dataVolume) &&
        Objects.equals(this.emptyDisk, v1Volume.emptyDisk) &&
        Objects.equals(this.ephemeral, v1Volume.ephemeral) &&
        Objects.equals(this.hostDisk, v1Volume.hostDisk) &&
        Objects.equals(this.name, v1Volume.name) &&
        Objects.equals(this.persistentVolumeClaim, v1Volume.persistentVolumeClaim) &&
        Objects.equals(this.secret, v1Volume.secret) &&
        Objects.equals(this.serviceAccount, v1Volume.serviceAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cloudInitConfigDrive, cloudInitNoCloud, configMap, containerDisk, dataVolume, emptyDisk, ephemeral, hostDisk, name, persistentVolumeClaim, secret, serviceAccount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Volume {\n");
    
    sb.append("    cloudInitConfigDrive: ").append(toIndentedString(cloudInitConfigDrive)).append("\n");
    sb.append("    cloudInitNoCloud: ").append(toIndentedString(cloudInitNoCloud)).append("\n");
    sb.append("    configMap: ").append(toIndentedString(configMap)).append("\n");
    sb.append("    containerDisk: ").append(toIndentedString(containerDisk)).append("\n");
    sb.append("    dataVolume: ").append(toIndentedString(dataVolume)).append("\n");
    sb.append("    emptyDisk: ").append(toIndentedString(emptyDisk)).append("\n");
    sb.append("    ephemeral: ").append(toIndentedString(ephemeral)).append("\n");
    sb.append("    hostDisk: ").append(toIndentedString(hostDisk)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    persistentVolumeClaim: ").append(toIndentedString(persistentVolumeClaim)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    serviceAccount: ").append(toIndentedString(serviceAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

