/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenStackImageProviderBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderCertificatesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderServiceImpl;
import org.ovirt.engine.sdk4.internal.services.OpenstackImagesServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackImageProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackImageProviderWriter;
import org.ovirt.engine.sdk4.services.ExternalProviderCertificatesService;
import org.ovirt.engine.sdk4.services.OpenstackImageProviderService;
import org.ovirt.engine.sdk4.services.OpenstackImagesService;
import org.ovirt.engine.sdk4.types.OpenStackImageProvider;

public class OpenstackImageProviderServiceImpl
extends ExternalProviderServiceImpl
implements OpenstackImageProviderService {
    public OpenstackImageProviderServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackImageProviderService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public OpenstackImageProviderService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public OpenstackImageProviderService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public ExternalProviderCertificatesService certificatesService() {
        return new ExternalProviderCertificatesServiceImpl(this.getConnection(), this.getPath() + "/certificates");
    }

    @Override
    public OpenstackImagesService imagesService() {
        return new OpenstackImagesServiceImpl(this.getConnection(), this.getPath() + "/images");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("certificates")) {
            return this.certificatesService();
        }
        if (path.startsWith("certificates/")) {
            return this.certificatesService().service(path.substring(13));
        }
        if (path.equals("images")) {
            return this.imagesService();
        }
        if (path.startsWith("images/")) {
            return this.imagesService().service(path.substring(7));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "OpenstackImageProviderService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements OpenstackImageProviderService.UpdateResponse {
        private OpenStackImageProvider provider;

        private UpdateResponseImpl() {
        }

        public void provider(OpenStackImageProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackImageProvider provider() {
            return this.provider;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<OpenstackImageProviderService.UpdateRequest, OpenstackImageProviderService.UpdateResponse>
    implements OpenstackImageProviderService.UpdateRequest {
        private Boolean async;
        private OpenStackImageProvider provider;

        private UpdateRequestImpl() {
        }

        @Override
        public OpenstackImageProviderService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackImageProviderService.UpdateRequest provider(OpenStackImageProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public OpenstackImageProviderService.UpdateRequest provider(OpenStackImageProviderBuilder provider) {
            this.provider = provider.build();
            return this;
        }

        @Override
        public OpenstackImageProviderService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackImageProviderServiceImpl.this.getConnection().getUrl() + OpenstackImageProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlOpenStackImageProviderWriter.writeOne(this.provider, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackImageProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.provider(XmlOpenStackImageProviderReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackImageProviderServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements OpenstackImageProviderService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<OpenstackImageProviderService.RemoveRequest, OpenstackImageProviderService.RemoveResponse>
    implements OpenstackImageProviderService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public OpenstackImageProviderService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackImageProviderService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackImageProviderServiceImpl.this.getConnection().getUrl() + OpenstackImageProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackImageProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            OpenstackImageProviderServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements OpenstackImageProviderService.GetResponse {
        private OpenStackImageProvider provider;

        private GetResponseImpl() {
        }

        public void provider(OpenStackImageProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackImageProvider provider() {
            return this.provider;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<OpenstackImageProviderService.GetRequest, OpenstackImageProviderService.GetResponse>
    implements OpenstackImageProviderService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public OpenstackImageProviderService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackImageProviderService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackImageProviderServiceImpl.this.getConnection().getUrl() + OpenstackImageProviderServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackImageProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.provider(XmlOpenStackImageProviderReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackImageProviderServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

