/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.AffinityLabelContainer;
import org.ovirt.engine.sdk4.types.AffinityLabel;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class AffinityLabelBuilder {
    private String comment;
    private String description;
    private Boolean hasImplicitAffinityGroup;
    private List<Host> hosts;
    private String href;
    private String id;
    private String name;
    private Boolean readOnly;
    private List<Vm> vms;

    public AffinityLabelBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public AffinityLabelBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public AffinityLabelBuilder hasImplicitAffinityGroup(boolean newHasImplicitAffinityGroup) {
        this.hasImplicitAffinityGroup = newHasImplicitAffinityGroup;
        return this;
    }

    public AffinityLabelBuilder hasImplicitAffinityGroup(Boolean newHasImplicitAffinityGroup) {
        this.hasImplicitAffinityGroup = newHasImplicitAffinityGroup;
        return this;
    }

    public AffinityLabelBuilder hosts(List<Host> newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts);
            } else {
                this.hosts.addAll(newHosts);
            }
        }
        return this;
    }

    public AffinityLabelBuilder hosts(Host ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            Collections.addAll(this.hosts, newHosts);
        }
        return this;
    }

    public AffinityLabelBuilder hosts(HostBuilder ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            for (HostBuilder builder : newHosts) {
                this.hosts.add(builder.build());
            }
        }
        return this;
    }

    public AffinityLabelBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public AffinityLabelBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public AffinityLabelBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public AffinityLabelBuilder readOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public AffinityLabelBuilder readOnly(Boolean newReadOnly) {
        this.readOnly = newReadOnly;
        return this;
    }

    public AffinityLabelBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public AffinityLabelBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public AffinityLabelBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public AffinityLabel build() {
        AffinityLabelContainer container = new AffinityLabelContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.hasImplicitAffinityGroup(this.hasImplicitAffinityGroup);
        container.hosts(this.hosts);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.readOnly(this.readOnly);
        container.vms(this.vms);
        return container;
    }
}

