/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedRolesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedTagsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlGroupReader;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.AssignedRolesService;
import org.ovirt.engine.sdk4.services.AssignedTagsService;
import org.ovirt.engine.sdk4.services.GroupService;
import org.ovirt.engine.sdk4.types.Group;

public class GroupServiceImpl
extends ServiceImpl
implements GroupService {
    public GroupServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public GroupService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public GroupService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public AssignedRolesService rolesService() {
        return new AssignedRolesServiceImpl(this.getConnection(), this.getPath() + "/roles");
    }

    @Override
    public AssignedTagsService tagsService() {
        return new AssignedTagsServiceImpl(this.getConnection(), this.getPath() + "/tags");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("roles")) {
            return this.rolesService();
        }
        if (path.startsWith("roles/")) {
            return this.rolesService().service(path.substring(6));
        }
        if (path.equals("tags")) {
            return this.tagsService();
        }
        if (path.startsWith("tags/")) {
            return this.tagsService().service(path.substring(5));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "GroupService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements GroupService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<GroupService.RemoveRequest, GroupService.RemoveResponse>
    implements GroupService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public GroupService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GroupService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GroupServiceImpl.this.getConnection().getUrl() + GroupServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GroupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            GroupServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements GroupService.GetResponse {
        private Group get;

        private GetResponseImpl() {
        }

        public void get(Group get) {
            this.get = get;
        }

        @Override
        public Group get() {
            return this.get;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<GroupService.GetRequest, GroupService.GetResponse>
    implements GroupService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public GroupService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public GroupService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GroupServiceImpl.this.getConnection().getUrl() + GroupServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GroupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.get(XmlGroupReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GroupServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

