/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.BalanceBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.BalanceServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlBalanceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlBalanceWriter;
import org.ovirt.engine.sdk4.services.BalanceService;
import org.ovirt.engine.sdk4.services.BalancesService;
import org.ovirt.engine.sdk4.types.Balance;

public class BalancesServiceImpl
extends ServiceImpl
implements BalancesService {
    public BalancesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public BalancesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public BalancesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public BalanceService balanceService(String id) {
        return new BalanceServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.balanceService(path);
        }
        return this.balanceService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "BalancesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements BalancesService.ListResponse {
        private List<Balance> balances;

        private ListResponseImpl() {
        }

        public void balances(List<Balance> balances) {
            this.balances = balances;
        }

        @Override
        public List<Balance> balances() {
            return this.balances;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<BalancesService.ListRequest, BalancesService.ListResponse>
    implements BalancesService.ListRequest {
        private Boolean filter;
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public BalancesService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public BalancesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public BalancesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public BalancesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public BalancesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public BalancesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BalancesServiceImpl.this.getConnection().getUrl() + BalancesServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BalancesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.balances(XmlBalanceReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            BalancesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements BalancesService.AddResponse {
        private Balance balance;

        private AddResponseImpl() {
        }

        public void balance(Balance balance) {
            this.balance = balance;
        }

        @Override
        public Balance balance() {
            return this.balance;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<BalancesService.AddRequest, BalancesService.AddResponse>
    implements BalancesService.AddRequest {
        private Balance balance;

        private AddRequestImpl() {
        }

        @Override
        public BalancesService.AddRequest balance(Balance balance) {
            this.balance = balance;
            return this;
        }

        @Override
        public BalancesService.AddRequest balance(BalanceBuilder balance) {
            this.balance = balance.build();
            return this;
        }

        @Override
        public BalancesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BalancesServiceImpl.this.getConnection().getUrl() + BalancesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlBalanceWriter.writeOne(this.balance, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BalancesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.balance(XmlBalanceReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            BalancesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

